# Coverage - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage - base**

## Resource Profile: Coverage - base 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Coverage-it-base | *Version*:0.1.1 |
| Active as of 2020-06-03 | *Computable Name*:CoverageItBase |

 
Profilo base generico per Coverage: include la rappresentazione dell'ASL di residenza e delle esensioni. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Coverage-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Coverage-it-base.csv), [Excel](StructureDefinition-Coverage-it-base.xlsx), [Schematron](StructureDefinition-Coverage-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Coverage-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/Coverage-it-base",
  "version" : "0.1.1",
  "name" : "CoverageItBase",
  "title" : "Coverage - base",
  "status" : "active",
  "date" : "2020-06-03T11:10:33+02:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base generico per Coverage: include la rappresentazione dell'ASL di residenza e delle esensioni.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage"
      },
      {
        "id" : "Coverage.beneficiary",
        "path" : "Coverage.beneficiary",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.costToBeneficiary",
        "path" : "Coverage.costToBeneficiary"
      },
      {
        "id" : "Coverage.costToBeneficiary.value[x]",
        "path" : "Coverage.costToBeneficiary.value[x]"
      },
      {
        "id" : "Coverage.costToBeneficiary.value[x].extension:absenceReason",
        "path" : "Coverage.costToBeneficiary.value[x].extension",
        "sliceName" : "absenceReason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/data-absent-reason"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.costToBeneficiary.exception",
        "path" : "Coverage.costToBeneficiary.exception",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.costToBeneficiary.exception.extension",
        "path" : "Coverage.costToBeneficiary.exception.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Coverage.costToBeneficiary.exception.extension:stato-esenzione",
        "path" : "Coverage.costToBeneficiary.exception.extension",
        "sliceName" : "stato-esenzione",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/coverage-exceptionStatus"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.costToBeneficiary.exception.type",
        "path" : "Coverage.costToBeneficiary.exception.type",
        "short" : "codice esensione",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.it/ValueSet/minsan-esenzioni"
        }
      },
      {
        "id" : "Coverage.costToBeneficiary.exception.period",
        "path" : "Coverage.costToBeneficiary.exception.period",
        "mustSupport" : true
      }
    ]
  }
}

```
