# Persona di Contatto - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Persona di Contatto**

## Logical Model: Persona di Contatto ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/ContattoPersona | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:ContattoPersona |

 
Modello Logico che definisce il set di dati che caratterizzano una persona identificato come possibile contatto per il paziente. 

**Usages:**

* Use this Logical Model: [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/ContattoPersona)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ContattoPersona.csv), [Excel](StructureDefinition-ContattoPersona.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ContattoPersona",
  "url" : "http://hl7.it/fhir/StructureDefinition/ContattoPersona",
  "version" : "0.1.1",
  "name" : "ContattoPersona",
  "title" : "Persona di Contatto",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set di dati che caratterizzano una persona identificato come possibile contatto per il paziente.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir-it",
      "uri" : "http://hl7.it/fhir",
      "name" : "HL7 FHIR IT Profiles"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "ContattoPersona",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ContattoPersona",
        "path" : "ContattoPersona",
        "short" : "ContattoPersona",
        "definition" : "Modello Logico che definisce il set di dati che caratterizzano i documenti di Identificazione (e.g. Passaporto, CI)",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact"
          }
        ]
      },
      {
        "id" : "ContattoPersona.nome",
        "path" : "ContattoPersona.nome",
        "short" : "Nome del Contatto",
        "definition" : "Nome del Contatto",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/HumanName"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.name"
          }
        ]
      },
      {
        "id" : "ContattoPersona.tipoRelazione",
        "path" : "ContattoPersona.tipoRelazione",
        "short" : "Tipo di relazione fra contatto e paziente (e.g. parente, amico, tutore)",
        "definition" : "Tipo di relazione fra contatto e paziente (e.g. parente, amico, tutore)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.relationship"
          }
        ]
      },
      {
        "id" : "ContattoPersona.indirizzo",
        "path" : "ContattoPersona.indirizzo",
        "short" : "Indirizzo del contatto",
        "definition" : "Indirizzo del contatto",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/Indirizzo"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.address"
          }
        ]
      },
      {
        "id" : "ContattoPersona.recapiti",
        "path" : "ContattoPersona.recapiti",
        "short" : "Recapiti (telecom)",
        "definition" : "Recapiti del paziente (telecom)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.telecom"
          }
        ]
      },
      {
        "id" : "ContattoPersona.recapiti.telefono",
        "path" : "ContattoPersona.recapiti.telefono",
        "short" : "telefono",
        "definition" : "telefono",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.telecom.where(system = 'phone')"
          }
        ]
      },
      {
        "id" : "ContattoPersona.recapiti.eMail",
        "path" : "ContattoPersona.recapiti.eMail",
        "short" : "eMail",
        "definition" : "eMail",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.telecom.where(system = 'email')"
          }
        ]
      },
      {
        "id" : "ContattoPersona.recapiti.pec",
        "path" : "ContattoPersona.recapiti.pec",
        "short" : "pec",
        "definition" : "pec",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.telecom.where(system = 'email')"
          }
        ]
      },
      {
        "id" : "ContattoPersona.recapiti.cellulare",
        "path" : "ContattoPersona.recapiti.cellulare",
        "short" : "Cellulare",
        "definition" : "Cellulare",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.telecom.where(system = 'mobile')"
          }
        ]
      }
    ]
  }
}

```
