# Azienda Sanitaria - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Azienda Sanitaria**

## Logical Model: Azienda Sanitaria ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/AziendaSanitaria | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:AziendaSanitaria |

 
Modello Logico che definisce il set minimo di dati che caratterizzano una Azienda Sanitaria. 

**Usages:**

* Use this Logical Model: [Medico Curante](StructureDefinition-MedicoCurante.md) and [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/AziendaSanitaria)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AziendaSanitaria.csv), [Excel](StructureDefinition-AziendaSanitaria.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AziendaSanitaria",
  "url" : "http://hl7.it/fhir/StructureDefinition/AziendaSanitaria",
  "version" : "0.1.1",
  "name" : "AziendaSanitaria",
  "title" : "Azienda Sanitaria",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set minimo di dati che caratterizzano una Azienda Sanitaria.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir-it",
      "uri" : "http://hl7.it/fhir",
      "name" : "HL7 FHIR IT Profiles"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "AziendaSanitaria",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AziendaSanitaria",
        "path" : "AziendaSanitaria",
        "short" : "Azienda Sanitaria",
        "definition" : "Modello Logico che definisce il set minimo di dati che caratterizzano una Azienda Sanitaria",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Organization.conformsTo('http://hl7.it/fhir/StructureDefinition/Organization-it-AziendaSanitaria')"
          }
        ]
      },
      {
        "id" : "AziendaSanitaria.identificativo",
        "path" : "AziendaSanitaria.identificativo",
        "short" : "ID Azienda Sanitaria",
        "definition" : "ID Azienda Sanitaria",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Organization.conformsTo('http://hl7.it/fhir/StructureDefinition/Organization-it-AziendaSanitaria').identifier"
          }
        ]
      },
      {
        "id" : "AziendaSanitaria.nome",
        "path" : "AziendaSanitaria.nome",
        "short" : "Nome Azienda",
        "definition" : "Nome Azienda",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Organization.conformsTo('http://hl7.it/fhir/StructureDefinition/Organization-it-AziendaSanitaria').name"
          }
        ]
      }
    ]
  }
}

```
