# Patient. Esempio con Codice Fiscale, Residenza e Domicilio - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient. Esempio con Codice Fiscale, Residenza e Domicilio**

## Example Patient: Patient. Esempio con Codice Fiscale, Residenza e Domicilio

Martino Rossi (no stated gender), DoB Unknown ( http://hl7.it/sid/codiceFiscale#RSSMRT57D12D612R)

-------

| | |
| :--- | :--- |
| [Professione del paziente](StructureDefinition-patient-occupation-it.md) | Medici |
| [Titolo di Studio del paziente](StructureDefinition-patient-qualification-it.md) | Medicina e chirurgia |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "esempio-professione",
  "extension" : [
    {
      "url" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.it/CodeSystem/istat-professioni",
            "code" : "2.4.1",
            "display" : "Medici"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.it/CodeSystem/istat-ctsi03",
            "code" : "72004001",
            "display" : "Medicina e chirurgia"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://hl7.it/sid/codiceFiscale",
      "value" : "RSSMRT57D12D612R"
    }
  ],
  "name" : [
    {
      "family" : "Rossi",
      "given" : ["Martino"]
    }
  ]
}

```
