# Patient. Esempio con Codice Fiscale, Residenza e Domicilio - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient. Esempio con Codice Fiscale, Residenza e Domicilio**

## Example Patient: Patient. Esempio con Codice Fiscale, Residenza e Domicilio

DANTE ALIGHIERI (official) Male, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#TSTPSN80A01D612A)

-------

| | |
| :--- | :--- |
| Active: | true |
| Contact Detail | * Viale della Repubblica 12, PANTIGLIATE - 20090 - Italia(home)
* Via Capitolina 27 - interno 5b - 34131 - TRIESTE(home)
 |
| Contact: | * ph: 33312345678
 |
| [Patient Birth Place](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html) | Italia |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "esempio-CF-residenza",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
      "valueAddress" : {
        "country" : "Italia",
        "_country" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
              "valueCoding" : {
                "system" : "http://terminology.hl7.it/sid/mef-ae-comuni",
                "code" : "F979",
                "display" : "NUORO"
              }
            }
          ]
        }
      }
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.it/fhir/StructureDefinition/recordCertification",
          "extension" : [
            {
              "url" : "when",
              "valueDateTime" : "2020-04-06"
            },
            {
              "url" : "who",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.it/CodeSystem/it-tipoEntita",
                    "code" : "mef",
                    "display" : "Ministero Economia e Finanze"
                  }
                ]
              }
            }
          ]
        }
      ],
      "system" : "http://hl7.it/sid/codiceFiscale",
      "value" : "TSTPSN80A01D612A"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "family" : "ALIGHIERI",
      "given" : ["DANTE"]
    }
  ],
  "gender" : "male",
  "birthDate" : "1971-05-01",
  "address" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/address-official",
          "valueBoolean" : true
        }
      ],
      "use" : "home",
      "type" : "postal",
      "text" : "Viale della Repubblica 12, PANTIGLIATE - 20090 - Italia",
      "line" : ["Viale della Repubblica 12, scala 2"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Viale della Repubblica"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType",
              "valueString" : "VIALE"
            },
            {
              "url" : "http://hl7.it/fhir/StructureDefinition/address-dug",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://registry.geodati.gov.it/dug",
                    "code" : "76",
                    "display" : "viale"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase",
              "valueString" : "DELLA REPUBBLICA"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "12"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-additionalLocator",
              "valueString" : "scala 2"
            }
          ]
        }
      ],
      "city" : "PANTIGLIATE",
      "postalCode" : "20090",
      "country" : "Italia"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/address-official",
          "valueBoolean" : false
        }
      ],
      "use" : "home",
      "type" : "postal",
      "text" : "Via Capitolina 27 - interno 5b - 34131 - TRIESTE",
      "line" : ["Via Capitolina 27 - interno 5b"],
      "city" : "TRIESTE",
      "postalCode" : "34131",
      "country" : "Italia",
      "period" : {
        "start" : "2009-06-09T00:00:00+02:00"
      }
    }
  ],
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "33312345678"
        }
      ]
    }
  ]
}

```
