# Organization. Esempio di Azienda Sanitaria Locale - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization. Esempio di Azienda Sanitaria Locale**

## Example Organization: Organization. Esempio di Azienda Sanitaria Locale

**identifier**: `http://hl7.it/sid/fls`/020101, `http://hl7.it/sid/vda/asl`/101, `http://hl7.it/sid/partitaIva`/00177330073, `http://hl7.it/sid/codiceFiscale`/91001750073

**active**: true

**type**: Azienda Sanitaria Locale

**name**: AZIENDA U.S.L. VALLE D'AOSTA

**telecom**: ph: (0165) 5431, fax: (0165) 544587, [protocollo@pec.ausl.vda.it](mailto:protocollo@pec.ausl.vda.it), [http://www.ausl.vda.it](http://www.ausl.vda.it)

**address**: VIA GUIDO REY 1 AOSTA VALLE D'AOSTA 11100 IT 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "asl-020101",
  "identifier" : [
    {
      "system" : "http://hl7.it/sid/fls",
      "value" : "020101"
    },
    {
      "system" : "http://hl7.it/sid/vda/asl",
      "value" : "101"
    },
    {
      "system" : "http://hl7.it/sid/partitaIva",
      "value" : "00177330073"
    },
    {
      "system" : "http://hl7.it/sid/codiceFiscale",
      "value" : "91001750073"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.it/CodeSystem/it-tipoEntita",
          "code" : "asl",
          "display" : "Azienda Sanitaria Locale"
        }
      ]
    }
  ],
  "name" : "AZIENDA U.S.L. VALLE D'AOSTA",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(0165) 5431"
    },
    {
      "system" : "fax",
      "value" : "(0165) 544587"
    },
    {
      "system" : "email",
      "value" : "protocollo@pec.ausl.vda.it"
    },
    {
      "system" : "url",
      "value" : "http://www.ausl.vda.it"
    }
  ],
  "address" : [
    {
      "line" : ["VIA GUIDO REY 1"],
      "city" : "AOSTA",
      "_city" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "http://terminology.hl7.it/sid/istat-unitaAmministrativeTerritoriali",
              "code" : "007003",
              "display" : "AOSTA"
            }
          }
        ]
      },
      "district" : "AO",
      "state" : "VALLE D'AOSTA",
      "_state" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "http://terminology.hl7.it/CodeSystem/minsan-regione",
              "code" : "020",
              "display" : "VALLE D'AOSTA"
            }
          }
        ]
      },
      "postalCode" : "11100",
      "country" : "IT"
    }
  ]
}

```
