# IG Home Page - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* **IG Home Page**

## IG Home Page

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/ImplementationGuide/hl7.fhir.it.base | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:HL7ITFhirBase |

### Scopo

Raccogliere i profili [HL7 FHIR](http://hl7.org/fhir) base sviluppati da [HL7 Italia](http://hl7.it) e le principali risorse (e.g. modelli logici, value set, code system) da usarsi trasversalmente in vari scenari di uso.

### Introduzione

Questa guida raccoglie i profili [HL7 FHIR](http://hl7.org/fhir) base sviluppati da [HL7 Italia](http://hl7.it), identificati come ****Profili FHIR IT Base****, e le principali risorse (e.g. modelli logici, value set, code system) da usarsi trasversalmente in vari scenari di uso.

I profili proposti sono stati sviluppati a partire da una serie di ****Modelli Logici****, rappresentati come HL7 FHIR logical model, inclusi in questa guida che fungeranno da guida per altre possibili rappresentazioni non FHIR.

Una esplicita mappatura fra gli elementi dei modelli logici e la loro rappresentazione in FHIR è fornita in questa guida nel tab **Mapping**.

### Caveat

I **Profili FHIR IT base** presenti in questa guida hanno come loro principale scopo quello di facilitare una rappresentazione comune di informazioni tipicamente usate nel contesto italiano. In questo senso:

* non pretendono di rappresentare ogni possibile informazione associabile alle classi rappresentate e potenzialmente di interesse in specifici scenari d’uso (e.g. colore dei capelli della persona);
* né di definire un set minimo comune di dati.

Future guide definiranno ulteriori vincoli da applicarsi a questi profili per specifici casi d'uso (e.g. Patient Summary; accesso del Paziente alle proprie informazioni).

Le terminologie (i.e. i code system) di terze parti (e.g. tabelle ISTAT, codici ministeriali) incluse in questa versione della guida sono fornite per fini esplicativi, non costituiscono un riferimento ufficiale per le terminologie in oggetto. Le condizioni di uso per le terminologie esterne usate sono descritte in [Copyright](copyright.md).

### Contenuti della guida

| | |
| :--- | :--- |
| ![](home-1.png)Figura 1 – Contenuti dell’Implementation Guide HL7 FHIR IT Base | Questa guida include principalmente tre tipologie di artefatti:1. I**Modelli Logici**: che descrivono il contenuto atteso per le diverse classi informative (e.g. Paziente), indipendentemente dalla loro rappresentazione fisica. I modelli sono formalizzati come modelli logici FHIR, ma la loro implementazione potrebbe non essere realizzata necessariamente in FHIR
1. I**Profili**: che descrivono come rappresentare in HL7 FHIR le informazioni incluse nei modelli logici
1. Le**Terminologie**che includono sistemi di codifica ([**Code System**](https://www.hl7.org/fhir/codesystem.html)); liste di valori ([**Value Set**](https://www.hl7.org/fhir/terminologies-valuesets.html)) e mappe concettuali ([**Concept Map**](https://www.hl7.org/fhir/terminologies-conceptmaps.html)).
 |

I **modelli logici** documentano anche come i singoli elementi dei modelli siano mappati nei diversi **profili FHIR** (**Model** **Mapping**).

Con **Profili** si intendono in questa guida:

1. risorse FHIR profilate
1. Estensioni e loro specializzazioni
1. Datatype profilati

I profili tipicamente descrivono quali artefatti terminologici usare e come (**Vocabulary Binding**)

### Struttura della guida

Le principali sezioni di questa guida sono:

* [Questa pagina](index.md) – definisce il contesto di questa guida
* Background - fornisce le informazioni che gli implementatori dovrebbero conoscere prima di leggere il resto dell'IG. Include due pagine:
* [Indice Artefatti](artifacts.md) – lista tutti gli artefatti FHIR inclusi in questa guida
* [Downloads](downloads.md) - consente di scaricare una copia di questa guida ed altre informazioni utili
* [Copyright](copyright.md) – specifica le condizioni d’uso di questa guida e di alcune terminologie referenziate

### Autori e Contributori

| | | | |
| :--- | :--- | :--- | :--- |
| Autore | Giorgio Cangioli | Consulente | giorgio.cangioli_at_gmail.com |
|  |  |  |  |
| Contributore | Elena Vio | Arsenàl.IT | evio_at_consorzioarsenal.it |
| Contributore | Ivano Christian Tomainu | Insiel S.p.A. | ivano.tomainu_at_insiel.it |
| Contributore | Paola Lupieri | Insiel S.p.A. | paola.lupieri_at_insiel.it |
| Contributore | Stefano Terreni | Insiel S.p.A. | stefano.terreni_at_insiel.it |
| Contributore | Flavio Mucchiut | Insiel S.p.A. | flavio.mucchiut_at_insiel.it |
| Contributore | Luca Del Col | IN. VA. S.p.A. | ldelcol_at_invallee.it |
| Contributore | Davide Corallo | CSI Piemonte | davide.corallo_at_csi.it |
| Contributore | Luigi Enrico Maccolini | Umbria Digitale | luigi.maccolini[at]umbriadigitale.it |
| Contributore | Mario Ciampi | CNR ICAR | mario.ciampi_at_icar.cnr.it |

