# Titolo di Studio del paziente - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Titolo di Studio del paziente**

## Extension: Titolo di Studio del paziente 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/patient-qualification-it | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:ExtTitoloStudioPaziente |

Estensione per gestire il Titolo di studio del paziente come CodeableConcept

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient - base](StructureDefinition-Patient-it-base.md)
* Examples for this Extension: [Patient/esempio-professione](Patient-esempio-professione.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/patient-qualification-it)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-qualification-it.csv), [Excel](StructureDefinition-patient-qualification-it.xlsx), [Schematron](StructureDefinition-patient-qualification-it.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-qualification-it",
  "url" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it",
  "version" : "0.1.1",
  "name" : "ExtTitoloStudioPaziente",
  "title" : "Titolo di Studio del paziente",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Estensione per gestire il Titolo di studio del paziente come CodeableConcept",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Titolo di Studio del paziente",
        "definition" : "Estensione per gestire il Titolo di studio del paziente come CodeableConcept"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-titoloStudio"
        }
      }
    ]
  }
}

```
