# Codice comune e/o stato di nascita - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Codice comune e/o stato di nascita**

## Extension: Codice comune e/o stato di nascita 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:ExtCodeableBirthPlace |

Codice comune e/o stato di nascita

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient - base](StructureDefinition-Patient-it-base.md)
* Examples for this Extension: [Patient/Patient-birthPlace-opt2](Patient-Patient-birthPlace-opt2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/patient-codeableBirthPlace)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-codeableBirthPlace.csv), [Excel](StructureDefinition-patient-codeableBirthPlace.xlsx), [Schematron](StructureDefinition-patient-codeableBirthPlace.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-codeableBirthPlace",
  "url" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace",
  "version" : "0.1.1",
  "name" : "ExtCodeableBirthPlace",
  "title" : "Codice comune e/o stato di nascita",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Codice comune e/o stato di nascita",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
