# DUG (Denominazione Urbanistica Generica) - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DUG (Denominazione Urbanistica Generica)**

## Extension: DUG (Denominazione Urbanistica Generica) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/address-dug | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:ExtDug |

Denominazione Urbanistica Ufficiale

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Address - base](StructureDefinition-Address-it-base.md)
* Examples for this Extension: [Patient/esempio-CF-residenza](Patient-esempio-CF-residenza.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/address-dug)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-address-dug.csv), [Excel](StructureDefinition-address-dug.xlsx), [Schematron](StructureDefinition-address-dug.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "address-dug",
  "url" : "http://hl7.it/fhir/StructureDefinition/address-dug",
  "version" : "0.1.1",
  "name" : "ExtDug",
  "title" : "DUG (Denominazione Urbanistica Generica)",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Denominazione Urbanistica Ufficiale",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address.line"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/address-dug"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-dug"
        }
      }
    ]
  }
}

```
