# Money - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Money - base**

## Data Type Profile: Money - base 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Money-it-base | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:MoneyItBase |

 
Profilo base generico per Money 

**Usages:**

* This DataType Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Money-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Money-it-base.csv), [Excel](StructureDefinition-Money-it-base.xlsx), [Schematron](StructureDefinition-Money-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Money-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/Money-it-base",
  "version" : "0.1.1",
  "name" : "MoneyItBase",
  "title" : "Money - base",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base generico per Money",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Money",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Money",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Money",
        "path" : "Money"
      },
      {
        "id" : "Money.currency",
        "path" : "Money.currency",
        "min" : 1,
        "patternCode" : "EUR",
        "mustSupport" : true
      }
    ]
  }
}

```
