# Esenzione - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Esenzione**

## Logical Model: Esenzione ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Esenzione | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:Esenzione |

 
Modello Logico che definisce il set minimo di dati che caratterizzano una Esenzione. 

**Usages:**

* Use this Logical Model: [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Esenzione)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Esenzione.csv), [Excel](StructureDefinition-Esenzione.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Esenzione",
  "url" : "http://hl7.it/fhir/StructureDefinition/Esenzione",
  "version" : "0.1.1",
  "name" : "Esenzione",
  "title" : "Esenzione",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set minimo di dati che caratterizzano una Esenzione.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir-it",
      "uri" : "http://hl7.it/fhir",
      "name" : "HL7 FHIR IT Profiles"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "Esenzione",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Esenzione",
        "path" : "Esenzione",
        "short" : "Esenzione",
        "definition" : "Modello Logico che definisce il set minimo di dati che caratterizzano una Esenzione",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.costToBeneficiary.exception"
          }
        ]
      },
      {
        "id" : "Esenzione.stato",
        "path" : "Esenzione.stato",
        "short" : "Stato dell'esenzione",
        "definition" : "Stato dell'esenzione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.costToBeneficiary.exception.extension('StatoEsenzioneCoverageIT')"
          }
        ]
      },
      {
        "id" : "Esenzione.tipo",
        "path" : "Esenzione.tipo",
        "short" : "Tipo Esenzione",
        "definition" : "Tipo Esenzione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.costToBeneficiary.exception.type"
          }
        ]
      },
      {
        "id" : "Esenzione.codice",
        "path" : "Esenzione.codice",
        "short" : "Codice Esenzione",
        "definition" : "Codice Esenzione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.costToBeneficiary.exception.type"
          }
        ]
      },
      {
        "id" : "Esenzione.descrizione",
        "path" : "Esenzione.descrizione",
        "short" : "Descrizione dell'esenzione",
        "definition" : "Descrizione dell'esenzione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/string"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.costToBeneficiary.exception.type.text"
          },
          {
            "identity" : "fhir-it",
            "map" : "Coverage.text"
          }
        ]
      },
      {
        "id" : "Esenzione.periodoValidita",
        "path" : "Esenzione.periodoValidita",
        "short" : "Periodo di validità dell'esenzione",
        "definition" : "Periodo di validità dell'esenzione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Period",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Period"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.costToBeneficiary.exception.period"
          }
        ]
      }
    ]
  }
}

```
