# Address - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Address - base**

## Data Type Profile: Address - base 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Address-it-base | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:AddressItBase |
| **Copyright/Legal**: CC0 | |

 
Base StructureDefinition per il tipo Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese. 

### Caratterizzazione degli indirizzi

La capacità di individuare il tipo di indirizzo (e.g. indirizzo di residenza, di domicilio) è un requisito oggettivo di diversi contesti di uso.

Se per alcuni tipi, come quelli citati, esiste una condivisione del loro significato; per molti altri, non è sempre possible trovare una accezione comune.

Per questo motivo, in questa fase, è stato scelto di non sovra-specificare le diverse categorie; lasciando ad eventuali estensioni e vocabolari locali la capacità di descrivere queste ulteriori classi di indirizzi.

In generale le tipologie di indirizzo sono descritte attraverso un insieme di diversi elementi come: 
* address.use
* address.type
* address.extension['address-official']
 una estensione locale opzionale di tipo CodeableConcept potrà inoltre essere utilizzata per caratterizzare più dettagliatamente gli indirizzi.

In particolare: 
*  **address.use='home'** indica il **domicilio** 
*  **address.extension['address-official']='true'** indica la **residenza** 
 l'assenza di extension['address-official'] non permette di desumere alcuna informazione riguardo alla residenza; considerazioni simili possono essere fatte riguardo l'assenza di address.use e domicilio.

**Usages:**

* Use this DataType Profile: [Patient - base](StructureDefinition-Patient-it-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Address-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Address-it-base.csv), [Excel](StructureDefinition-Address-it-base.xlsx), [Schematron](StructureDefinition-Address-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Address-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/Address-it-base",
  "version" : "0.1.1",
  "name" : "AddressItBase",
  "title" : "Address - base",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Base StructureDefinition per il tipo Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento  Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese.",
  "_description" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "lang",
            "valueCode" : "en"
          },
          {
            "url" : "content",
            "valueString" : "Base StructureDefinition for Address Type with additions for Italian addresses. This profile breaks down the Address.line in several parts, allows the coding of some of these parts and highlights 'officially registered' addresses ('Residenza'). This first draft version is ispired to the Dutch Address"
          }
        ],
        "url" : "http://hl7.org/fhir/StructureDefinition/translation"
      }
    ]
  },
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Address",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address",
        "path" : "Address",
        "short" : "Indirizzo fisico o postale",
        "_short" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "lang",
                  "valueCode" : "en"
                },
                {
                  "url" : "content",
                  "valueString" : "A physical/postal address"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
            }
          ]
        },
        "definition" : "Esiste una varietà di formati di indirizzi postali definiti in tutto il mondo. Questo profilo (Address-it-base) estende il datatype base Address includendo una serie di informazioni rilevanti per esprimere gli indirizzi in Italia. \r \n \r \n Un Address-it-base è un indirizzo FHIR valido; i sistemi che non supportano le estensioni utilizzate saranno in grado comunque di eseguire il rendering e lavorare con un Address-it-base. \r \n \r \n Un indirizzo Address-it-base rende alcune parti di indirizzo comunicabili separatamente. Queste parti sono necessarie in alcuni scenari d'uso italiani, ma potrebbero non avere valore per i sistemi internazionali quando le informazioni vengono inviate all'estero.",
        "_definition" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "lang",
                  "valueCode" : "en"
                },
                {
                  "url" : "content",
                  "valueString" : "There is a variety of postal address formats defined around the world. This profile (Address-it-base) extends the base datatype Address adding a set of components relevant to express Italian addresses. \r\n\r\nAn Address-it-base Address is a proper FHIR Address. Systems that do not understand any of the extensions, will be able to render and work with a thus address. \r \n \r \n Address-it-base addresses make certain address parts separately communicable. These parts are required for some Italian use cases when dealing with IT  addresses, but may not have value for international systems when information gets sent abroad."
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
            }
          ]
        },
        "comment" : "Nota: address è per indirizzi postali, non per la localizzazione fisica.",
        "_comment" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "lang",
                  "valueCode" : "en"
                },
                {
                  "url" : "content",
                  "valueString" : "Note: address is for postal addresses, not physical locations."
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
            }
          ]
        },
        "alias" : ["Indirizzo"],
        "example" : [
          {
            "label" : "Completo",
            "valueAddress" : {
              "line" : ["Via dei Ciliegi 15"],
              "city" : "Artimino",
              "state" : "PO",
              "postalCode" : "59015",
              "country" : "IT"
            }
          }
        ],
        "constraint" : [
          {
            "key" : "it-address-official",
            "severity" : "error",
            "human" : "Se Address rappresenta la residenza allora city e line devono essere inclusi",
            "expression" : "extension.where(url = 'http://hl7.org/fhir/StructureDefinition/address-official').valueBoolean.where(true).empty() or ( line.exists() and city.exists() )",
            "source" : "http://hl7.org/fhir/StructureDefinition/Address"
          }
        ]
      },
      {
        "id" : "Address.extension:residenza",
        "path" : "Address.extension",
        "sliceName" : "residenza",
        "short" : "Indica l'indirizzo di residenza",
        "definition" : "Indica se questo indirizzo è quello di residenza, come indirizzo 'ufficialmente registrato' address.",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/address-official"]
          }
        ]
      },
      {
        "id" : "Address.extension:certificazioneIndirizzo",
        "path" : "Address.extension",
        "sliceName" : "certificazioneIndirizzo",
        "short" : "Certificazione Indirizzo",
        "definition" : "Indica che i dati di questo indirizzo sono stati certificati da una specifica entità",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Address.line",
        "path" : "Address.line",
        "short" : "Nome completo strada (e.g. Via Corta 1, interno 2)",
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Via Corta 1, interno 2"
          }
        ]
      },
      {
        "id" : "Address.line.extension:odonimo",
        "path" : "Address.line.extension",
        "sliceName" : "odonimo",
        "short" : "Odonimo, Toponimo Stradale",
        "requirements" : "Nome della Strada",
        "alias" : ["Toponimo Stradale"],
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Via Corta"
          }
        ]
      },
      {
        "id" : "Address.line.extension:denominazioneUrbanisticaGenerica",
        "path" : "Address.line.extension",
        "sliceName" : "denominazioneUrbanisticaGenerica",
        "short" : "Denominazione Urbanistica Generica (DUG)",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Via"
          }
        ]
      },
      {
        "id" : "Address.line.extension:dugCode",
        "path" : "Address.line.extension",
        "sliceName" : "dugCode",
        "short" : "Codice Denominazione Urbanistica Generica (DUG)",
        "alias" : ["specie"],
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/address-dug"]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://registry.geodati.gov.it/dug",
                  "code" : "67",
                  "display" : "via"
                }
              ]
            }
          }
        ]
      },
      {
        "id" : "Address.line.extension:denominazioneUrbanisticaUfficiale",
        "path" : "Address.line.extension",
        "sliceName" : "denominazioneUrbanisticaUfficiale",
        "short" : "Denominazione Urbanistica Ufficiale (DUF)",
        "alias" : ["denominazione"],
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Corta"
          }
        ]
      },
      {
        "id" : "Address.line.extension:houseNumber",
        "path" : "Address.line.extension",
        "sliceName" : "houseNumber",
        "short" : "Numero Civico",
        "requirements" : "Numero Civico",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "1"
          }
        ]
      },
      {
        "id" : "Address.city",
        "path" : "Address.city",
        "definition" : "The name of the city, town, village or other community or delivery center.",
        "alias" : ["Comune"],
        "example" : [
          {
            "label" : "General",
            "valueString" : "Bagno a Ripoli"
          }
        ]
      },
      {
        "id" : "Address.city.extension:codiceComune",
        "path" : "Address.city.extension",
        "sliceName" : "codiceComune",
        "short" : "Codice Comune",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-comune"
        }
      },
      {
        "id" : "Address.district",
        "path" : "Address.district",
        "short" : "Nome della Provincia",
        "definition" : "Nome dell'area amministrativa (county).\r\nPer gli indirizzi italiani è usato per indicare la Provincia",
        "alias" : ["Provincia"],
        "example" : [
          {
            "label" : "General",
            "valueString" : "Campobasso"
          }
        ]
      },
      {
        "id" : "Address.district.extension:codiceProvincia",
        "path" : "Address.district.extension",
        "sliceName" : "codiceProvincia",
        "short" : "Codice Provincia",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-provincia"
        }
      },
      {
        "id" : "Address.state",
        "path" : "Address.state",
        "short" : "Sotto-unità dello stato (Regione).",
        "definition" : "Sotto-unità dello stato con limitata sovranità in uno stato oragnizzato federalmente.\r\nNel contesto italiano indica la \"Regione\"",
        "alias" : ["Regione"],
        "example" : [
          {
            "label" : "Regione",
            "valueString" : "Lazio"
          }
        ]
      },
      {
        "id" : "Address.state.extension:codiceRegione",
        "path" : "Address.state.extension",
        "sliceName" : "codiceRegione",
        "short" : "Codice Regione",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-regione"
        }
      },
      {
        "id" : "Address.postalCode",
        "path" : "Address.postalCode",
        "comment" : "I codici postali italiani hanno un pattern '[1,9]\\d{4}'.",
        "alias" : ["CAP", "postcode"],
        "example" : [
          {
            "label" : "General",
            "valueString" : "50125"
          }
        ],
        "condition" : ["it-postal-code-pattern"],
        "constraint" : [
          {
            "key" : "it-postal-code-pattern",
            "severity" : "error",
            "human" : "I codici postali italiani hanno un pattern 'nnnnn' (n intero)",
            "expression" : "(country in 'it' | 'ita' | 'italia' | 'italy').not() or matches('^[1-9]\\\\d{4}$')",
            "xpath" : "not(../f:country[lower-case(@value)=('it','ita','italia', 'italy')]) or matches(@value,'^[1-9]\\d{4}$')",
            "source" : "http://hl7.org/fhir/StructureDefinition/Address"
          }
        ]
      },
      {
        "id" : "Address.country",
        "path" : "Address.country",
        "short" : "Stato",
        "example" : [
          {
            "label" : "Nome Stato",
            "valueString" : "Italia"
          }
        ]
      },
      {
        "id" : "Address.country.extension:codiceStato",
        "path" : "Address.country.extension",
        "sliceName" : "codiceStato",
        "short" : "Codice Stato",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.it/ValueSet/istat-stato"
        }
      }
    ]
  }
}

```
