# PractitionerRole. Medico di Medicina Generale - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole. Medico di Medicina Generale**

## Example PractitionerRole: PractitionerRole. Medico di Medicina Generale

**identifier**: `http://hl7.it/sid/codiceFiscale`/RSSMRT57D12D612R, `http://example.org/sid/codiceRegionale`/123456789

**period**: 1997-09-01 --> (ongoing)

**practitioner**: [Practitioner Martino Rossi](Practitioner-PractitionerMMGExample.md)

**organization**: [Organization AZIENDA U.S.L. VALLE D'AOSTA](Organization-asl-020101.md)

**code**: MMG



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "PractitionerRoleMMGExample",
  "identifier" : [
    {
      "system" : "http://hl7.it/sid/codiceFiscale",
      "value" : "RSSMRT57D12D612R"
    },
    {
      "system" : "http://example.org/sid/codiceRegionale",
      "value" : "123456789"
    }
  ],
  "period" : {
    "start" : "1997-09-01"
  },
  "practitioner" : {
    "reference" : "Practitioner/PractitionerMMGExample"
  },
  "organization" : {
    "reference" : "Organization/asl-020101"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.it/CodeSystem/it-v3RoleCode",
          "code" : "MMG"
        }
      ]
    }
  ]
}

```
