# Artifacts Summary - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Patient: XpanDH](StructureDefinition-Patient-eu-xpandh.md) | This profile defines how to represent Patient in FHIR for the purpose of the XpanDH project. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Absent or Unknown Allergies](ValueSet-eHDSIAbsentOrUnknownAllergy.md) | Absent or Unknown Allergies |
| [Absent or Unknown Device](ValueSet-eHDSIAbsentOrUnknownDevice.md) | Absent or Unknown Device |
| [Absent or Unknown Medication](ValueSet-eHDSIAbsentOrUnknownMedication.md) | Absent or Unknown Medication |
| [Absent or Unknown Problem](ValueSet-eHDSIAbsentOrUnknownProblem.md) | Absent or Unknown Problem |
| [Absent or Unknown Procedure](ValueSet-eHDSIAbsentOrUnknownProcedure.md) | Absent or Unknown Procedure |
| [Adverse Event Type](ValueSet-eHDSIAdverseEventType.md) | Adverse Event Type |
| [Allergen No Drug](ValueSet-eHDSIAllergenNoDrug.md) | The value set is used to code the patient's kind of adverse reactions against substance, food or drugs |
| [Allergy Certainty](ValueSet-eHDSIAllergyCertainty.md) | Value Set is used to support or decline the clinical status of the allergy or intolerance |
| [Allergy Status](ValueSet-eHDSIAllergyStatus.md) | The value set is used to code the Allergy or Intolerance Clinical Status |
| [Blood Group](ValueSet-eHDSIBloodGroup.md) | The Value Set is used to code the value of patient's blood group + Rh |
| [Blood Pressure](ValueSet-eHDSIBloodPressure.md) | The Value Set is used for the observations of Blood Pressure recorded in the section for Vital Signs Observations in the Patient Summary. It codes what type of pressure (diastolic, systolic) is measured. |
| [Certainty](ValueSet-eHDSICertainty.md) | Value Set is used to support or decline the clinical status of the condition or diagnosis |
| [Confidentiality](ValueSet-eHDSIConfidentiality.md) | The Value Set is used for encoding the confidentiality level of the entire CDA. This Value Set encodes the level of access with regards to the content of the Value Set ? for example N concerns all the medical team, R is restricted for specialist that take care of the patient in certain circumstances, and VIP would be for the persons that need the Privacy Officer present or other special consideration (for example a celebrity hospitalized who needs their records protected) |
| [Country](ValueSet-eHDSICountry.md) | The Value Set is used to identify the nationality of all persons and organizations. |
| [Criticality](ValueSet-eHDSICriticality.md) | Value set is used to estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance |
| [Current Pregnancy Status](ValueSet-eHDSICurrentPregnancyStatus.md) | Value set is used to provide the woman's current state at the date the observation was made |
| [Document Code](ValueSet-eHDSIDocumentCode.md) | Defines to which category the document belongs to : summary, prescription, or dispensation. |
| [Dose Form](ValueSet-eHDSIDoseForm.md) | Dose Form |
| [Healthcare Professional Role](ValueSet-eHDSIHealthcareProfessionalRole.md) | Healthcare Professional Role |
| [Hospital Discharge Report Type](ValueSet-eHDSIHospitalDischargeReportType.md) | Hospital Discharge Report Type |
| [Problems](ValueSet-eHDSICodeProb.md) | The Value Set is used as an optional description of a problem in the patient Summary. It gives an information on the circumstances under which the problem was defined/discovered. |
| [Procedure](ValueSet-eHDSIProcedure.md) | Procedure |
| [Reaction Allergy](ValueSet-eHDSIReactionAllergy.md) | Reaction Allergy |
| [Severity](ValueSet-eHDSISeverity.md) | The Value Set is used for all Problems and Allergies in the Patient Summary to indicate the severity of the problem (or Allergy) |
| [Vaccine](ValueSet-eHDSIVaccine.md) | The Value Set is used to identify the patient's vaccinations in the Patient Summary |
| [eHDSI Social History](ValueSet-eHDSISocialHistory.md) | The Value Set is used to code the different elements of the patient's social history. |

