# Criticality - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Criticality**

## ValueSet: Criticality 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSICriticality | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSICriticality |

 
Value set is used to estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSICriticality",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSICriticality",
  "version" : "0.1.0",
  "name" : "EHDSICriticality",
  "title" : "Criticality",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Value set is used to estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/allergy-intolerance-criticality",
        "concept" : [
          {
            "code" : "low",
            "display" : "Low Risk"
          },
          {
            "code" : "high",
            "display" : "High Risk"
          },
          {
            "code" : "unable-to-assess",
            "display" : "Unable to Assess Risk"
          }
        ]
      }
    ]
  }
}

```
