# Confidentiality - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Confidentiality**

## ValueSet: Confidentiality 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIConfidentiality | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSIConfidentiality |

 
The Value Set is used for encoding the confidentiality level of the entire CDA. This Value Set encodes the level of access with regards to the content of the Value Set ? for example N concerns all the medical team, R is restricted for specialist that take care of the patient in certain circumstances, and VIP would be for the persons that need the Privacy Officer present or other special consideration (for example a celebrity hospitalized who needs their records protected) 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSIConfidentiality",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIConfidentiality",
  "version" : "0.1.0",
  "name" : "EHDSIConfidentiality",
  "title" : "Confidentiality",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "The Value Set is used for encoding the confidentiality level of the entire CDA. This Value Set encodes the level of access with regards to the content of the Value Set ? for example N concerns all the medical team, R is restricted for specialist that take care of the patient in certain circumstances, and VIP would be for the persons that need the Privacy Officer present or other special consideration (for example a celebrity hospitalized who needs their records protected)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
        "concept" : [
          {
            "code" : "N",
            "display" : "normal"
          },
          {
            "code" : "R",
            "display" : "restricted"
          },
          {
            "code" : "V",
            "display" : "very restricted"
          }
        ]
      }
    ]
  }
}

```
