# Certainty - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Certainty**

## ValueSet: Certainty 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSICertainty | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSICertainty |

 
Value Set is used to support or decline the clinical status of the condition or diagnosis 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSICertainty",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSICertainty",
  "version" : "0.1.0",
  "name" : "EHDSICertainty",
  "title" : "Certainty",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Value Set is used to support or decline the clinical status of the condition or diagnosis",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "concept" : [
          {
            "code" : "unconfirmed",
            "display" : "Unconfirmed"
          },
          {
            "code" : "provisional",
            "display" : "Provisional"
          },
          {
            "code" : "differential",
            "display" : "Differential"
          },
          {
            "code" : "confirmed",
            "display" : "Confirmed"
          },
          {
            "code" : "refuted",
            "display" : "Refuted"
          }
        ]
      }
    ]
  }
}

```
