# Allergen No Drug - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Allergen No Drug**

## ValueSet: Allergen No Drug 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIAllergenNoDrug | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSIAllergenNoDrug |

 
The value set is used to code the patient's kind of adverse reactions against substance, food or drugs 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 288 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSIAllergenNoDrug",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIAllergenNoDrug",
  "version" : "0.1.0",
  "name" : "EHDSIAllergenNoDrug",
  "title" : "Allergen No Drug",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "The value set is used to code the patient\\'s kind of adverse reactions against substance, food or drugs",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "1003736004",
            "display" : "Mammalian milk based food"
          },
          {
            "code" : "102259006",
            "display" : "Citrus fruit"
          },
          {
            "code" : "102261002",
            "display" : "Strawberry"
          },
          {
            "code" : "102262009",
            "display" : "Chocolate"
          },
          {
            "code" : "102263004",
            "display" : "Eggs"
          },
          {
            "code" : "102264005",
            "display" : "Cheese"
          },
          {
            "code" : "105590001",
            "display" : "Substance"
          },
          {
            "code" : "111088007",
            "display" : "Latex"
          },
          {
            "code" : "111095003",
            "display" : "Formaldehyde"
          },
          {
            "code" : "11526002",
            "display" : "Aspartame"
          },
          {
            "code" : "115589000",
            "display" : "Ethanolamine"
          },
          {
            "code" : "116274004",
            "display" : "Artificial sweetener"
          },
          {
            "code" : "116549003",
            "display" : "Organochlorine pesticide"
          },
          {
            "code" : "116637007",
            "display" : "Fungal antigen"
          },
          {
            "code" : "11894001",
            "display" : "Clostridium botulinum toxin"
          },
          {
            "code" : "119417004",
            "display" : "Organophosphate insecticide"
          },
          {
            "code" : "12503006",
            "display" : "Aluminum"
          },
          {
            "code" : "12510000",
            "display" : "Eucalyptus oil"
          },
          {
            "code" : "128488006",
            "display" : "House dust"
          },
          {
            "code" : "128489003",
            "display" : "Sand"
          },
          {
            "code" : "13577000",
            "display" : "Nut"
          },
          {
            "code" : "13652007",
            "display" : "Silicone"
          },
          {
            "code" : "14006006",
            "display" : "Ethylene oxide"
          },
          {
            "code" : "14402002",
            "display" : "Wood"
          },
          {
            "code" : "14423008",
            "display" : "Adhesive bandage"
          },
          {
            "code" : "16313001",
            "display" : "Tea"
          },
          {
            "code" : "19893005",
            "display" : "Potassium dichromate"
          },
          {
            "code" : "2159007",
            "display" : "Azorubin S stain"
          },
          {
            "code" : "21592006",
            "display" : "Tartrazine stain"
          },
          {
            "code" : "226491003",
            "display" : "Apple juice"
          },
          {
            "code" : "226723006",
            "display" : "Buckwheat - cereal"
          },
          {
            "code" : "226915003",
            "display" : "Red meat"
          },
          {
            "code" : "226916002",
            "display" : "Beef"
          },
          {
            "code" : "226934003",
            "display" : "Pork"
          },
          {
            "code" : "226942002",
            "display" : "Lamb"
          },
          {
            "code" : "226955001",
            "display" : "Chicken - meat"
          },
          {
            "code" : "226967004",
            "display" : "Turkey - meat"
          },
          {
            "code" : "227038007",
            "display" : "White fish"
          },
          {
            "code" : "227110001",
            "display" : "Fatty fish"
          },
          {
            "code" : "227144008",
            "display" : "Tuna fish"
          },
          {
            "code" : "227150003",
            "display" : "Mussel"
          },
          {
            "code" : "227151004",
            "display" : "Prawns"
          },
          {
            "code" : "227219006",
            "display" : "Eggplant"
          },
          {
            "code" : "227220000",
            "display" : "Beetroot"
          },
          {
            "code" : "227313005",
            "display" : "Pulse vegetables"
          },
          {
            "code" : "227346004",
            "display" : "Chick peas"
          },
          {
            "code" : "227350006",
            "display" : "Lentils"
          },
          {
            "code" : "227362005",
            "display" : "Red kidney beans"
          },
          {
            "code" : "227374009",
            "display" : "Herbs and spices"
          },
          {
            "code" : "227376006",
            "display" : "Anise seed"
          },
          {
            "code" : "227379004",
            "display" : "Bay leaf"
          },
          {
            "code" : "227382009",
            "display" : "Cardamom"
          },
          {
            "code" : "227385006",
            "display" : "Chili powder"
          },
          {
            "code" : "227388008",
            "display" : "Cinnamon"
          },
          {
            "code" : "227389000",
            "display" : "Clove"
          },
          {
            "code" : "227390009",
            "display" : "Coriander leaf"
          },
          {
            "code" : "227391008",
            "display" : "Coriander seed"
          },
          {
            "code" : "227395004",
            "display" : "Curry powder"
          },
          {
            "code" : "227396003",
            "display" : "Fennel"
          },
          {
            "code" : "227400003",
            "display" : "Ginger"
          },
          {
            "code" : "227404007",
            "display" : "Mace"
          },
          {
            "code" : "227405008",
            "display" : "Marjoram"
          },
          {
            "code" : "227407000",
            "display" : "Oregano"
          },
          {
            "code" : "227408005",
            "display" : "Paprika"
          },
          {
            "code" : "227409002",
            "display" : "Poppy seed"
          },
          {
            "code" : "227411006",
            "display" : "Sage"
          },
          {
            "code" : "227413009",
            "display" : "Thyme"
          },
          {
            "code" : "227423000",
            "display" : "Dates - food"
          },
          {
            "code" : "227425007",
            "display" : "Figs"
          },
          {
            "code" : "227444000",
            "display" : "Raspberries"
          },
          {
            "code" : "227447007",
            "display" : "Sharon fruit"
          },
          {
            "code" : "227493005",
            "display" : "Cashew nut"
          },
          {
            "code" : "227501001",
            "display" : "Macadamia nut"
          },
          {
            "code" : "227511008",
            "display" : "Pine nut"
          },
          {
            "code" : "227512001",
            "display" : "Pistachio nut"
          },
          {
            "code" : "227514000",
            "display" : "Pumpkin seed"
          },
          {
            "code" : "227515004",
            "display" : "Quinoa"
          },
          {
            "code" : "227598003",
            "display" : "Honey"
          },
          {
            "code" : "22836000",
            "display" : "Vegetable"
          },
          {
            "code" : "230034002",
            "display" : "Nuts and seeds"
          },
          {
            "code" : "2309006",
            "display" : "Gold"
          },
          {
            "code" : "23182003",
            "display" : "Cereal"
          },
          {
            "code" : "24515005",
            "display" : "Spice"
          },
          {
            "code" : "255640000",
            "display" : "Biocide"
          },
          {
            "code" : "255667006",
            "display" : "Paraffin"
          },
          {
            "code" : "255769001",
            "display" : "Hexahydrophthalic anhydride"
          },
          {
            "code" : "255772008",
            "display" : "Diphenylmethane di-isocyanate"
          },
          {
            "code" : "255775005",
            "display" : "Maleic anhydride"
          },
          {
            "code" : "255786007",
            "display" : "Toluene di-isocyanate"
          },
          {
            "code" : "256248008",
            "display" : "Plant material"
          },
          {
            "code" : "256259004",
            "display" : "Pollen"
          },
          {
            "code" : "256260009",
            "display" : "Tree and shrub pollen"
          },
          {
            "code" : "256262001",
            "display" : "Silver birch pollen"
          },
          {
            "code" : "256277009",
            "display" : "Grass pollen"
          },
          {
            "code" : "256292005",
            "display" : "Flower and weed pollen"
          },
          {
            "code" : "256293000",
            "display" : "Mugwort pollen"
          },
          {
            "code" : "256303006",
            "display" : "Ragweed pollen"
          },
          {
            "code" : "256305004",
            "display" : "Tree resin"
          },
          {
            "code" : "256306003",
            "display" : "Orange - fruit"
          },
          {
            "code" : "256307007",
            "display" : "Banana"
          },
          {
            "code" : "256313003",
            "display" : "Pineapple"
          },
          {
            "code" : "256315005",
            "display" : "Grapefruit"
          },
          {
            "code" : "256316006",
            "display" : "Tangerine"
          },
          {
            "code" : "256317002",
            "display" : "Grapes"
          },
          {
            "code" : "256318007",
            "display" : "Green bean"
          },
          {
            "code" : "256319004",
            "display" : "Carrot"
          },
          {
            "code" : "256326004",
            "display" : "Celery"
          },
          {
            "code" : "256329006",
            "display" : "Spinach"
          },
          {
            "code" : "256331002",
            "display" : "Dill"
          },
          {
            "code" : "256350002",
            "display" : "Almond"
          },
          {
            "code" : "256351003",
            "display" : "Brazil nut"
          },
          {
            "code" : "256352005",
            "display" : "Walnut - nut"
          },
          {
            "code" : "256353000",
            "display" : "Hazelnut"
          },
          {
            "code" : "256355007",
            "display" : "Soya bean"
          },
          {
            "code" : "256363008",
            "display" : "Animal material"
          },
          {
            "code" : "256406004",
            "display" : "Animal epithelium"
          },
          {
            "code" : "256417003",
            "display" : "Horse dander"
          },
          {
            "code" : "256419000",
            "display" : "Mouse epithelium"
          },
          {
            "code" : "256435007",
            "display" : "Feathers"
          },
          {
            "code" : "256440004",
            "display" : "Wasp venom"
          },
          {
            "code" : "256443002",
            "display" : "Egg white"
          },
          {
            "code" : "256504004",
            "display" : "Polycarbonate dental material"
          },
          {
            "code" : "256506002",
            "display" : "Stainless steel material"
          },
          {
            "code" : "260118006",
            "display" : "Wall pellitory pollen"
          },
          {
            "code" : "260126003",
            "display" : "Olive pollen"
          },
          {
            "code" : "260131001",
            "display" : "Eucalyptus pollen"
          },
          {
            "code" : "260152009",
            "display" : "Cat dander"
          },
          {
            "code" : "260153004",
            "display" : "Cow dander"
          },
          {
            "code" : "260154005",
            "display" : "Dog dander"
          },
          {
            "code" : "260156007",
            "display" : "Mouse urine proteins"
          },
          {
            "code" : "260167008",
            "display" : "Sesame seed"
          },
          {
            "code" : "260168003",
            "display" : "White bean"
          },
          {
            "code" : "260176001",
            "display" : "Kiwi fruit"
          },
          {
            "code" : "260177005",
            "display" : "Melon"
          },
          {
            "code" : "260179008",
            "display" : "Mango fruit"
          },
          {
            "code" : "260184002",
            "display" : "Pea"
          },
          {
            "code" : "260189007",
            "display" : "Pecan nut"
          },
          {
            "code" : "260204008",
            "display" : "Cotton seed"
          },
          {
            "code" : "260205009",
            "display" : "Sunflower seed"
          },
          {
            "code" : "261243003",
            "display" : "Brass"
          },
          {
            "code" : "264287008",
            "display" : "Animal dander"
          },
          {
            "code" : "264295007",
            "display" : "Cow's milk protein"
          },
          {
            "code" : "264331002",
            "display" : "Grain"
          },
          {
            "code" : "264337003",
            "display" : "Seed"
          },
          {
            "code" : "27119002",
            "display" : "Trimellitic anhydride"
          },
          {
            "code" : "276310004",
            "display" : "Animal hair"
          },
          {
            "code" : "278840001",
            "display" : "Shrimp"
          },
          {
            "code" : "2799001",
            "display" : "Methylbenzethonium chloride"
          },
          {
            "code" : "280939008",
            "display" : "Insect venom"
          },
          {
            "code" : "28230009",
            "display" : "Poultry"
          },
          {
            "code" : "28647000",
            "display" : "Meat"
          },
          {
            "code" : "288328004",
            "display" : "Bee venom"
          },
          {
            "code" : "289122001",
            "display" : "Cosmetic material"
          },
          {
            "code" : "289949002",
            "display" : "Cypress pollen"
          },
          {
            "code" : "289954006",
            "display" : "Fungal material"
          },
          {
            "code" : "29263009",
            "display" : "Coffee"
          },
          {
            "code" : "303300008",
            "display" : "Egg protein"
          },
          {
            "code" : "303314008",
            "display" : "Scorpion venom"
          },
          {
            "code" : "303315009",
            "display" : "Spider venom"
          },
          {
            "code" : "31006001",
            "display" : "Kingdom Plantae"
          },
          {
            "code" : "311846002",
            "display" : "Pyrethroid insecticide"
          },
          {
            "code" : "33008008",
            "display" : "Dust"
          },
          {
            "code" : "33396006",
            "display" : "Nickel"
          },
          {
            "code" : "37017009",
            "display" : "Helminth"
          },
          {
            "code" : "3718001",
            "display" : "Cow's milk"
          },
          {
            "code" : "37663002",
            "display" : "Venom"
          },
          {
            "code" : "38271009",
            "display" : "Saffron stain"
          },
          {
            "code" : "3829006",
            "display" : "Iron"
          },
          {
            "code" : "386936005",
            "display" : "Azelaic acid"
          },
          {
            "code" : "387293003",
            "display" : "Anthralin"
          },
          {
            "code" : "387398009",
            "display" : "Podophyllum resin"
          },
          {
            "code" : "391737006",
            "display" : "Almond oil"
          },
          {
            "code" : "395734009",
            "display" : "Guar gum"
          },
          {
            "code" : "396031000",
            "display" : "Dimethicone"
          },
          {
            "code" : "406774009",
            "display" : "Fish derived omega 3 fatty acid"
          },
          {
            "code" : "410853002",
            "display" : "Perfluorochemical"
          },
          {
            "code" : "412056003",
            "display" : "Lima beans"
          },
          {
            "code" : "412060000",
            "display" : "Black pepper"
          },
          {
            "code" : "412061001",
            "display" : "Blueberries"
          },
          {
            "code" : "412068007",
            "display" : "Rye"
          },
          {
            "code" : "412070003",
            "display" : "Vanilla"
          },
          {
            "code" : "412071004",
            "display" : "Wheat"
          },
          {
            "code" : "412145001",
            "display" : "Hair dye"
          },
          {
            "code" : "412150007",
            "display" : "Insect debris"
          },
          {
            "code" : "412153009",
            "display" : "Rabbit dander"
          },
          {
            "code" : "412156001",
            "display" : "Silk"
          },
          {
            "code" : "412161004",
            "display" : "Wool"
          },
          {
            "code" : "412357001",
            "display" : "Corn"
          },
          {
            "code" : "415710007",
            "display" : "Terpene"
          },
          {
            "code" : "418266005",
            "display" : "Yellow paraffin"
          },
          {
            "code" : "418504009",
            "display" : "Oats"
          },
          {
            "code" : "418785009",
            "display" : "Perfume"
          },
          {
            "code" : "418920007",
            "display" : "Adhesive agent"
          },
          {
            "code" : "419420009",
            "display" : "Watermelon"
          },
          {
            "code" : "419604006",
            "display" : "Weed pollen"
          },
          {
            "code" : "419633007",
            "display" : "White paraffin"
          },
          {
            "code" : "41967008",
            "display" : "Silver"
          },
          {
            "code" : "421556008",
            "display" : "Capsicum - pepper"
          },
          {
            "code" : "42416001",
            "display" : "Lanolin"
          },
          {
            "code" : "425620007",
            "display" : "Metal"
          },
          {
            "code" : "430503006",
            "display" : "Glutamate"
          },
          {
            "code" : "43230003",
            "display" : "Rubber"
          },
          {
            "code" : "43735007",
            "display" : "Sulfur"
          },
          {
            "code" : "44027008",
            "display" : "Seafood"
          },
          {
            "code" : "442571000124108",
            "display" : "Tree nut"
          },
          {
            "code" : "47703008",
            "display" : "Lactose"
          },
          {
            "code" : "50593009",
            "display" : "Casein"
          },
          {
            "code" : "51386004",
            "display" : "Food preservative"
          },
          {
            "code" : "51503008",
            "display" : "Rose oil"
          },
          {
            "code" : "51905005",
            "display" : "Mustard"
          },
          {
            "code" : "52454007",
            "display" : "Albumin"
          },
          {
            "code" : "57126000",
            "display" : "Glue"
          },
          {
            "code" : "59351004",
            "display" : "Citrate"
          },
          {
            "code" : "59533004",
            "display" : "Food additive"
          },
          {
            "code" : "59545008",
            "display" : "Pesticide"
          },
          {
            "code" : "61789006",
            "display" : "Dye"
          },
          {
            "code" : "63045006",
            "display" : "Berry"
          },
          {
            "code" : "63338004",
            "display" : "Drug flavoring"
          },
          {
            "code" : "63995005",
            "display" : "Bandage"
          },
          {
            "code" : "64601002",
            "display" : "Wood dust"
          },
          {
            "code" : "66925006",
            "display" : "Copper"
          },
          {
            "code" : "67324005",
            "display" : "Rice"
          },
          {
            "code" : "68524009",
            "display" : "Tragacanth"
          },
          {
            "code" : "70813002",
            "display" : "Milk"
          },
          {
            "code" : "710179004",
            "display" : "Lupine seed"
          },
          {
            "code" : "711089007",
            "display" : "Mite protein"
          },
          {
            "code" : "72179002",
            "display" : "Oxybenzone"
          },
          {
            "code" : "72511004",
            "display" : "Fruit"
          },
          {
            "code" : "726759005",
            "display" : "Cuttlefish"
          },
          {
            "code" : "726764009",
            "display" : "Broad bean"
          },
          {
            "code" : "734881000",
            "display" : "Tomato"
          },
          {
            "code" : "735004000",
            "display" : "Sweet potato"
          },
          {
            "code" : "735006003",
            "display" : "Squid"
          },
          {
            "code" : "735029006",
            "display" : "Shellfish"
          },
          {
            "code" : "735030001",
            "display" : "Garlic"
          },
          {
            "code" : "735042006",
            "display" : "Lettuce"
          },
          {
            "code" : "735045008",
            "display" : "Mushroom"
          },
          {
            "code" : "735046009",
            "display" : "Nutmeg"
          },
          {
            "code" : "735047000",
            "display" : "Onion"
          },
          {
            "code" : "735049002",
            "display" : "Peach"
          },
          {
            "code" : "735050002",
            "display" : "Pear"
          },
          {
            "code" : "735051003",
            "display" : "Plum"
          },
          {
            "code" : "735053000",
            "display" : "Potato"
          },
          {
            "code" : "735106000",
            "display" : "Basil"
          },
          {
            "code" : "735108004",
            "display" : "Cabbage"
          },
          {
            "code" : "735123009",
            "display" : "Broccoli"
          },
          {
            "code" : "735124003",
            "display" : "Barley"
          },
          {
            "code" : "735211005",
            "display" : "Coconut"
          },
          {
            "code" : "735212003",
            "display" : "Papaya"
          },
          {
            "code" : "735213008",
            "display" : "Cucumber"
          },
          {
            "code" : "735214002",
            "display" : "Apricot"
          },
          {
            "code" : "735215001",
            "display" : "Apple"
          },
          {
            "code" : "735245003",
            "display" : "Cod"
          },
          {
            "code" : "735246002",
            "display" : "Eel"
          },
          {
            "code" : "735248001",
            "display" : "Cherry"
          },
          {
            "code" : "735249009",
            "display" : "Avocado"
          },
          {
            "code" : "735336002",
            "display" : "Cauliflower"
          },
          {
            "code" : "735340006",
            "display" : "Lemon"
          },
          {
            "code" : "735341005",
            "display" : "Fish oil"
          },
          {
            "code" : "735959004",
            "display" : "Marine mollusk"
          },
          {
            "code" : "735971005",
            "display" : "Fish"
          },
          {
            "code" : "735972003",
            "display" : "Crayfish"
          },
          {
            "code" : "735977009",
            "display" : "Marine crustacean"
          },
          {
            "code" : "735979007",
            "display" : "Octopus"
          },
          {
            "code" : "736027000",
            "display" : "Scallop"
          },
          {
            "code" : "736030007",
            "display" : "Clam"
          },
          {
            "code" : "736031006",
            "display" : "Oyster"
          },
          {
            "code" : "736159005",
            "display" : "Crab"
          },
          {
            "code" : "736162008",
            "display" : "Lobster"
          },
          {
            "code" : "736258006",
            "display" : "Insect salivary substance"
          },
          {
            "code" : "75665004",
            "display" : "Monosodium glutamate"
          },
          {
            "code" : "762766007",
            "display" : "Edible substance"
          },
          {
            "code" : "762952008",
            "display" : "Peanut"
          },
          {
            "code" : "767406000",
            "display" : "Sulfite and sulfite derivative"
          },
          {
            "code" : "772245002",
            "display" : "Wool alcohol"
          },
          {
            "code" : "77249007",
            "display" : "Phthalic anhydride"
          },
          {
            "code" : "7791007",
            "display" : "Soy protein"
          },
          {
            "code" : "80237000",
            "display" : "Cocoa butter"
          },
          {
            "code" : "80259003",
            "display" : "Food flavoring agent"
          },
          {
            "code" : "82566005",
            "display" : "Animal feed"
          },
          {
            "code" : "83595008",
            "display" : "Goat's milk"
          },
          {
            "code" : "83619009",
            "display" : "Polyvinyl alcohol"
          },
          {
            "code" : "87918000",
            "display" : "Mineral"
          },
          {
            "code" : "89811004",
            "display" : "Gluten"
          },
          {
            "code" : "89889006",
            "display" : "Cotton fiber"
          },
          {
            "code" : "9021002",
            "display" : "Carbaryl"
          },
          {
            "code" : "91598004",
            "display" : "Benzoyl peroxide"
          },
          {
            "code" : "91606004",
            "display" : "Cochineal stain"
          }
        ]
      }
    ]
  }
}

```
