# Patient: XpanDH - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient: XpanDH**

## Resource Profile: Patient: XpanDH 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/StructureDefinition/Patient-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:PatientXpandh |

 
This profile defines how to represent Patient in FHIR for the purpose of the XpanDH project. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh|current/StructureDefinition/Patient-eu-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-eu-xpandh.csv), [Excel](StructureDefinition-Patient-eu-xpandh.xlsx), [Schematron](StructureDefinition-Patient-eu-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/StructureDefinition/Patient-eu-xpandh",
  "version" : "0.1.0",
  "name" : "PatientXpandh",
  "title" : "Patient: XpanDH",
  "status" : "draft",
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Patient in FHIR for the purpose of the XpanDH project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.extension:nationality",
        "path" : "Patient.extension",
        "sliceName" : "nationality",
        "short" : "Nationality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-nationality"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "short" : "patient identifier"
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "min" : 1
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "min" : 1
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "A contact detail for the patient"
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "The gender of the patient used for administrative purposes."
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "The date of birth for the patient"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "short" : "Patient Address"
      },
      {
        "id" : "Patient.contact.name.family",
        "path" : "Patient.contact.name.family",
        "min" : 1
      },
      {
        "id" : "Patient.contact.name.given",
        "path" : "Patient.contact.name.given",
        "min" : 1
      },
      {
        "id" : "Patient.contact.telecom",
        "path" : "Patient.contact.telecom",
        "short" : "Contact details for the person"
      },
      {
        "id" : "Patient.contact.address",
        "path" : "Patient.contact.address",
        "short" : "Contact person address"
      },
      {
        "id" : "Patient.communication.language",
        "path" : "Patient.communication.language",
        "short" : "Communication language"
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "short" : "Patient's nominated primary care provider.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole"
            ]
          }
        ]
      }
    ]
  }
}

```
