# Home - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ImplementationGuide/hl7.eu.fhir.xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:XpandhIg |

> The specification herewith documented is a working specification, and may not be used for any implementation purposes. No liability can be inferred from the use or misuse of this specification, or its consequences.

### Scope

 This is the access point to the XpanDH project open repositories and artefacts for the EEHRxF specifications organised per adoption domain. 

 This includes the HL7 FHIR Implementation Guides, created to assist the work of the pilots for the [XpanDH exprimentation bubbles](#adoption-domains). 

### XpanDH open repository structure

The follwing figure shows the relationships among the XpanDH repositories and artefacts (including HL7 FHIR Gs)


 
* This guide is the entry point for the: 
* The [Laboratory Report Implementation Guide](https://build.fhir.org/ig/hl7-eu/xpandh-lab)
* The [Hospital Discharge Report Implementation Guide](https://build.fhir.org/ig/hl7-eu/xpandh-hdr)
* The [Patient Summary Implementation Guide](https://build.fhir.org/ig/hl7-eu/xpandh-ps)
* The [Medicinal Prescription and Dispense (MPD) Implementation Guide](https://build.fhir.org/ig/hl7-eu/xpandh-mpd)
 
* All the source files are stored in dedicated GitHub Repositories: 
* The [XpanDH project GitHub](https://github.com/hl7-eu/xpandh) repository
* The [Laboratory Report GitHub](https://github.com/hl7-eu/xpandh-lab) repository
* The [Hospital Discharge Report GitHub](https://github.com/hl7-eu/xpandh-hdr) repository
* The [Patient Summary GitHub](https://github.com/hl7-eu/xpandh-ps) repository
* The [Medicinal Prescription and Dispense (MPD) GitHub](https://github.com/hl7-eu/xpandh-mpd) repository
 
* All the examples created for supporting the X-Bubbles are stored in the GitHub Repositories. Some of them are also accessible thorugh the dedicated FHIR IG
 

### The project

#### The mission

Help individuals and organizations successfully adopt the European Electronic Health Record Exchange Format (EEHRxF) in a way that is empowering and supportive. 

#### How to:

Mobilizing and building capacity to ensure the widespread adoption of the European Electronic Health Records Exchange Format (EEHRxF) across Europe. 

More details in [XpanDH Web Site](https://xpandh-project.iscte-iul.pt/) 

### XpanDH Adoption Domains/X-Bubbles

#### What is:

An EEHRxF adoption domain could be considered as an instantiation of a use case, with a specific case application, that has meaning from a health system or clinical perspective, with defined implementable requirements (simple if only one EEHRxF priority category is uses or composite if data from more than one is required), that satisfies all the conditions for users to be ready to implement data exchange in conformity to EEHRxF guidelines and specifications 

XpanDH will exercise a set of adoption domains, involving Hospitals, Regional/National organziation, vendors,.., thorugh experimentaion bubbles (in the Hpandh jargon called X-Bubbles)

#### Adoption domains / X-Bubbles:

* X-Bubble 1: OKFO; organisation to organisation (national level). Communicate a specific set of laboratory results of patients between different organisations so that each organisation can maintain a complete record of the results, in order to ensure continuity of care, and possibility to generate alerts to their General Practitioner (GP), nurse, etc.
* X-Bubble 2: CHUP; organisation to patient (national level). Communicate the latest set of laboratory results to the patient so they can follow up on any pre-agreed actions, track their progress and contact the treating clinician with any concerns or questions.
* X-Bubble 3: NCZI; organisation to organisation (national). Exchange of discharge reports between different organisations, such as a hospital and a GP or between a hospital local to the patient and a specialist centre treating a disease such as a cancer, in order to enable each clinical actor to be well informed and contribute accurately to the same patient care pathway.
* X-Bubble 4: CHUP; organisation to patient (national. Communicate discharge reports from a hospital to the patient (within the same country) so that they can be informed, raise questions if needed, share this information with other caregivers and take any self-care actions indicated in the report.
* X-Bubble 5: KETEKNY; organisation to national authority.Communicate discharge reports from a hospital to a national authority to support reimbursement decisions or to contribute content to a national registry.
* X-Bubble 6: KETEKNY; national authority to organisation. The national authority communicates discharge reports to a hospital treating a patient, that it has previously received from other hospitals treating that patient, to enable a smooth transfer and continuity of care (e.g. if a patient moves home).

More details on X-Bubbles and Adoption Doamin in XpanDH deliverable D1.4 and D4.1 [XpanDH Web Site](https://xpandh-project.iscte-iul.pt/) 

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.eu.fhir.xpandh.r4)](package.r4.tgz) and [R4B (hl7.eu.fhir.xpandh.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [EHDSICountry](ValueSet-eHDSICountry.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [EHDSIAbsentOrUnknownAllergy](ValueSet-eHDSIAbsentOrUnknownAllergy.md), [EHDSIAbsentOrUnknownDevice](ValueSet-eHDSIAbsentOrUnknownDevice.md), [EHDSIAbsentOrUnknownMedication](ValueSet-eHDSIAbsentOrUnknownMedication.md), [EHDSIAbsentOrUnknownProblem](ValueSet-eHDSIAbsentOrUnknownProblem.md) and [EHDSIAbsentOrUnknownProcedure](ValueSet-eHDSIAbsentOrUnknownProcedure.md)


* This artifact includes content from International Standard Classification of Occupations (ISCO). ISCO is copyright International Labour Organization (ILO). Terms & Conditions in [http://www.ilo.org/global/copyright/lang--en/index.htm](http://www.ilo.org/global/copyright/lang--en/index.htm)

* [International Standard Classification of Occupations (ISCO)](http://tx.fhir.org/r4/ValueSet/isco): [EHDSIHealthcareProfessionalRole](ValueSet-eHDSIHealthcareProfessionalRole.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [EHDSIBloodPressure](ValueSet-eHDSIBloodPressure.md), [EHDSIDocumentCode](ValueSet-eHDSIDocumentCode.md) and [EHDSIHospitalDischargeReportType](ValueSet-eHDSIHospitalDischargeReportType.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [EHDSIAdverseEventType](ValueSet-eHDSIAdverseEventType.md), [EHDSIAllergenNoDrug](ValueSet-eHDSIAllergenNoDrug.md)...Show 8 more,[EHDSIBloodGroup](ValueSet-eHDSIBloodGroup.md),[EHDSICodeProb](ValueSet-eHDSICodeProb.md),[EHDSICurrentPregnancyStatus](ValueSet-eHDSICurrentPregnancyStatus.md),[EHDSIProcedure](ValueSet-eHDSIProcedure.md),[EHDSIReactionAllergy](ValueSet-eHDSIReactionAllergy.md),[EHDSISeverity](ValueSet-eHDSISeverity.md),[EHDSISocialHistory](ValueSet-eHDSISocialHistory.md)and[EHDSIVaccine](ValueSet-eHDSIVaccine.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [EHDSIAllergyStatus](ValueSet-eHDSIAllergyStatus.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-verification.html): [EHDSIAllergyCertainty](ValueSet-eHDSIAllergyCertainty.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [EHDSICertainty](ValueSet-eHDSICertainty.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [EHDSIConfidentiality](ValueSet-eHDSIConfidentiality.md)


### Authors and Contributors

