# Procedure - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure**

## ValueSet: Procedure 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIProcedure | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSIProcedure |

 
Procedure 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set has 1,052 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSIProcedure",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIProcedure",
  "version" : "0.1.0",
  "name" : "EHDSIProcedure",
  "title" : "Procedure",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Procedure",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "10197000",
            "display" : "Psychiatric interview and evaluation"
          },
          {
            "code" : "10326007",
            "display" : "Coronary artery bypass with autogenous graft, three grafts"
          },
          {
            "code" : "103716009",
            "display" : "Placement of stent"
          },
          {
            "code" : "103735009",
            "display" : "Palliative care"
          },
          {
            "code" : "103742009",
            "display" : "Renewal of prescription"
          },
          {
            "code" : "10458001",
            "display" : "Evacuation of intracerebral haematoma"
          },
          {
            "code" : "105373008",
            "display" : "Percutaneous insertion of intravascular filter"
          },
          {
            "code" : "105386004",
            "display" : "Respite care of patient"
          },
          {
            "code" : "105387008",
            "display" : "Holiday relief care of patient"
          },
          {
            "code" : "107733003",
            "display" : "Introduction procedure"
          },
          {
            "code" : "107907001",
            "display" : "Operative procedure on digestive system"
          },
          {
            "code" : "107936001",
            "display" : "Operative procedure on small intestine"
          },
          {
            "code" : "107938000",
            "display" : "Small intestine excision"
          },
          {
            "code" : "107957009",
            "display" : "Operative procedure on digestive organ"
          },
          {
            "code" : "107963000",
            "display" : "Excision of liver"
          },
          {
            "code" : "107987003",
            "display" : "Endocrine system destructive procedure"
          },
          {
            "code" : "108021004",
            "display" : "Operative procedure on male genitourinary system"
          },
          {
            "code" : "108022006",
            "display" : "Kidney excision"
          },
          {
            "code" : "108034003",
            "display" : "Bladder excision"
          },
          {
            "code" : "108101003",
            "display" : "Obstetrics incision"
          },
          {
            "code" : "108189003",
            "display" : "Abdomen excision"
          },
          {
            "code" : "108217004",
            "display" : "Interview, history AND/OR physical examination"
          },
          {
            "code" : "108231004",
            "display" : "Analysis of electronic device used in cardiovascular system"
          },
          {
            "code" : "108241001",
            "display" : "Dialysis procedure"
          },
          {
            "code" : "108290001",
            "display" : "Radiation oncology AND/OR radiotherapy"
          },
          {
            "code" : "108311000",
            "display" : "Psychiatric procedure, interview AND/OR consultation"
          },
          {
            "code" : "10836008",
            "display" : "Decompression of spinal cord"
          },
          {
            "code" : "10847001",
            "display" : "Bronchoscopy"
          },
          {
            "code" : "10849003",
            "display" : "Removal of foreign body"
          },
          {
            "code" : "11050006",
            "display" : "Closure of vesicouterine fistula with hysterectomy"
          },
          {
            "code" : "11101003",
            "display" : "Percutaneous transluminal coronary angioplasty"
          },
          {
            "code" : "112695004",
            "display" : "Closure"
          },
          {
            "code" : "112697007",
            "display" : "Operation on musculoskeletal system"
          },
          {
            "code" : "112698002",
            "display" : "Operation on joint"
          },
          {
            "code" : "112727005",
            "display" : "Revision of hip replacement"
          },
          {
            "code" : "112746006",
            "display" : "Operative procedure on hand"
          },
          {
            "code" : "112788002",
            "display" : "Operation on accessory sinus"
          },
          {
            "code" : "112802009",
            "display" : "Cardiovascular surgical procedure"
          },
          {
            "code" : "112811009",
            "display" : "Atrioseptoplasty"
          },
          {
            "code" : "112828007",
            "display" : "Femoral-popliteal artery bypass graft"
          },
          {
            "code" : "112871003",
            "display" : "Anastomosis of large intestine to large intestine"
          },
          {
            "code" : "112892003",
            "display" : "Radical excision of iliac lymph nodes"
          },
          {
            "code" : "11291002",
            "display" : "Excision of lesion of omentum"
          },
          {
            "code" : "112925006",
            "display" : "Repair of obstetric laceration of vulva"
          },
          {
            "code" : "11401008",
            "display" : "Dilation and curettage of uterus"
          },
          {
            "code" : "11429006",
            "display" : "Consultation"
          },
          {
            "code" : "1144279009",
            "display" : "Fitting of complete denture"
          },
          {
            "code" : "11466000",
            "display" : "Caesarean section"
          },
          {
            "code" : "116028008",
            "display" : "Salpingo-oophorectomy"
          },
          {
            "code" : "116140006",
            "display" : "Total hysterectomy"
          },
          {
            "code" : "116141005",
            "display" : "Abdominal hysterectomy"
          },
          {
            "code" : "116142003",
            "display" : "Radical hysterectomy"
          },
          {
            "code" : "116143008",
            "display" : "Total abdominal hysterectomy"
          },
          {
            "code" : "116144002",
            "display" : "Total abdominal hysterectomy with bilateral salpingo-oophorectomy"
          },
          {
            "code" : "116241004",
            "display" : "Pancreaticoduodenectomy"
          },
          {
            "code" : "1163360005",
            "display" : "Surgical procedure on skeletal system"
          },
          {
            "code" : "116361007",
            "display" : "Creation of venovenous bypass"
          },
          {
            "code" : "116859006",
            "display" : "Transfusion of blood product"
          },
          {
            "code" : "1172563000",
            "display" : "Insertion of peritoneal dialysis catheter"
          },
          {
            "code" : "1179121008",
            "display" : "Insertion of atrial baffle"
          },
          {
            "code" : "118153004",
            "display" : "Gastrointestinal tract repair"
          },
          {
            "code" : "118292001",
            "display" : "Removal"
          },
          {
            "code" : "118442004",
            "display" : "Drainage of abscess"
          },
          {
            "code" : "118470002",
            "display" : "Internal skeletal fixation"
          },
          {
            "code" : "118664000",
            "display" : "Procedure on body system"
          },
          {
            "code" : "118666003",
            "display" : "Procedure on musculoskeletal system"
          },
          {
            "code" : "118668002",
            "display" : "Procedure on articular system"
          },
          {
            "code" : "118672003",
            "display" : "Procedure on cardiovascular system"
          },
          {
            "code" : "118673008",
            "display" : "Procedure on digestive system"
          },
          {
            "code" : "118674002",
            "display" : "Procedure on genitourinary system"
          },
          {
            "code" : "118675001",
            "display" : "Procedure on female genital system"
          },
          {
            "code" : "118678004",
            "display" : "Procedure on nervous system"
          },
          {
            "code" : "118679007",
            "display" : "Procedure on central nervous system"
          },
          {
            "code" : "118681009",
            "display" : "Procedure on endocrine system"
          },
          {
            "code" : "118683007",
            "display" : "Procedure on ear and related structures"
          },
          {
            "code" : "118690002",
            "display" : "Procedure on head"
          },
          {
            "code" : "118693000",
            "display" : "Procedure on neck"
          },
          {
            "code" : "118694006",
            "display" : "Procedure on trunk"
          },
          {
            "code" : "118698009",
            "display" : "Procedure on abdomen"
          },
          {
            "code" : "118716003",
            "display" : "Procedure on foot"
          },
          {
            "code" : "118717007",
            "display" : "Procedure on organ"
          },
          {
            "code" : "118738001",
            "display" : "Procedure on soft tissue"
          },
          {
            "code" : "118745001",
            "display" : "Procedure on joint"
          },
          {
            "code" : "118754003",
            "display" : "Procedure on gland"
          },
          {
            "code" : "118766009",
            "display" : "Procedure on thyroid gland"
          },
          {
            "code" : "118795000",
            "display" : "Procedure on pleura"
          },
          {
            "code" : "118797008",
            "display" : "Procedure on heart"
          },
          {
            "code" : "118804001",
            "display" : "Procedure on blood vessel"
          },
          {
            "code" : "118821005",
            "display" : "Procedure on digestive organ"
          },
          {
            "code" : "118826000",
            "display" : "Procedure on digestive tract"
          },
          {
            "code" : "118830002",
            "display" : "Procedure on stomach"
          },
          {
            "code" : "118831003",
            "display" : "Procedure on intestine"
          },
          {
            "code" : "118832005",
            "display" : "Procedure on small intestine"
          },
          {
            "code" : "118835007",
            "display" : "Procedure on ileum"
          },
          {
            "code" : "118864003",
            "display" : "Procedure on uterus"
          },
          {
            "code" : "118885003",
            "display" : "Procedure on brain"
          },
          {
            "code" : "118949002",
            "display" : "Procedure on extremity"
          },
          {
            "code" : "118950002",
            "display" : "Procedure on head AND/OR neck"
          },
          {
            "code" : "118955007",
            "display" : "Implantation to cardiovascular system"
          },
          {
            "code" : "119283008",
            "display" : "Open biopsy"
          },
          {
            "code" : "119561005",
            "display" : "Grafting procedure"
          },
          {
            "code" : "119566000",
            "display" : "Creation of cerebrospinal fluid shunt"
          },
          {
            "code" : "119583009",
            "display" : "Trunk excision"
          },
          {
            "code" : "119594008",
            "display" : "Neck destructive procedure"
          },
          {
            "code" : "119614000",
            "display" : "Hip joint reconstruction"
          },
          {
            "code" : "119762001",
            "display" : "Cardiovascular system transplantation"
          },
          {
            "code" : "119922005",
            "display" : "Biliary tract endoscopy"
          },
          {
            "code" : "119954001",
            "display" : "Adenoid excision"
          },
          {
            "code" : "120001005",
            "display" : "Testis excision"
          },
          {
            "code" : "12132004",
            "display" : "Langenbeck operation, cleft palate repair"
          },
          {
            "code" : "122459003",
            "display" : "Dissection procedure"
          },
          {
            "code" : "122461007",
            "display" : "Evacuation procedure"
          },
          {
            "code" : "122462000",
            "display" : "Drainage procedure"
          },
          {
            "code" : "122465003",
            "display" : "Reconstruction procedure"
          },
          {
            "code" : "122470005",
            "display" : "Reduction of closed fracture"
          },
          {
            "code" : "122471009",
            "display" : "Reduction of open fracture"
          },
          {
            "code" : "122548005",
            "display" : "Biopsy of breast"
          },
          {
            "code" : "122945004",
            "display" : "Procedure on skeletal system"
          },
          {
            "code" : "123014005",
            "display" : "Excision of pelvis"
          },
          {
            "code" : "1231734007",
            "display" : "Excision of breast"
          },
          {
            "code" : "12398007",
            "display" : "Excision of endometrial synechiae"
          },
          {
            "code" : "125571002",
            "display" : "Lobectomy"
          },
          {
            "code" : "12658000",
            "display" : "Operation on female genital organs"
          },
          {
            "code" : "12660003",
            "display" : "Repair of complete shoulder cuff avulsion, chronic"
          },
          {
            "code" : "127601009",
            "display" : "Hammer toe operation"
          },
          {
            "code" : "12826007",
            "display" : "Dorrance operation, push-back operation for cleft palate"
          },
          {
            "code" : "128303001",
            "display" : "Surgical removal"
          },
          {
            "code" : "128312004",
            "display" : "Procedure on female genital organ"
          },
          {
            "code" : "128323000",
            "display" : "Revision of implant"
          },
          {
            "code" : "128927009",
            "display" : "Procedure by method"
          },
          {
            "code" : "128952006",
            "display" : "Catheterization of both left and right heart with graft"
          },
          {
            "code" : "129112001",
            "display" : "Aspiration from trachea"
          },
          {
            "code" : "129233004",
            "display" : "Procedure on bone (organ)"
          },
          {
            "code" : "129252005",
            "display" : "Suprapubic cystostomy"
          },
          {
            "code" : "12976005",
            "display" : "Donor nephrectomy"
          },
          {
            "code" : "13091001",
            "display" : "Dilation and curettage"
          },
          {
            "code" : "13254001",
            "display" : "Abdominal hysterectomy with colpo-urethrocystopexy, Marshall-Marchetti-Krantz type"
          },
          {
            "code" : "133858001",
            "display" : "Preoperative procedure"
          },
          {
            "code" : "133864008",
            "display" : "Lithotripsy"
          },
          {
            "code" : "133899007",
            "display" : "Postoperative care"
          },
          {
            "code" : "133906008",
            "display" : "Postpartum care"
          },
          {
            "code" : "134435003",
            "display" : "Routine antenatal care"
          },
          {
            "code" : "13529000",
            "display" : "Nasal septoplasty"
          },
          {
            "code" : "13619001",
            "display" : "Thyroidectomy"
          },
          {
            "code" : "13662000",
            "display" : "Anastomosis of pulmonary-subclavian artery by Blalock-Taussig operation"
          },
          {
            "code" : "13714004",
            "display" : "Arthroscopy"
          },
          {
            "code" : "13793006",
            "display" : "Extracapsular extraction of lens"
          },
          {
            "code" : "13910004",
            "display" : "Combined anteroposterior colporrhaphy"
          },
          {
            "code" : "14766002",
            "display" : "Aspiration"
          },
          {
            "code" : "150062003",
            "display" : "Osteotomy"
          },
          {
            "code" : "15018006",
            "display" : "Laparoscopic repair of inguinal hernia"
          },
          {
            "code" : "15023006",
            "display" : "Thromboendarterectomy with graft of carotid artery by neck incision"
          },
          {
            "code" : "152198000",
            "display" : "Brachytherapy"
          },
          {
            "code" : "15413009",
            "display" : "High forceps delivery with episiotomy"
          },
          {
            "code" : "15463004",
            "display" : "Operation on thyroid gland"
          },
          {
            "code" : "15617002",
            "display" : "Ligation of varicose vein of lower limb"
          },
          {
            "code" : "15726007",
            "display" : "Fistulization of cerebral ventricle"
          },
          {
            "code" : "16453004",
            "display" : "Operation on stomach"
          },
          {
            "code" : "16545005",
            "display" : "Operation on nervous system"
          },
          {
            "code" : "16564004",
            "display" : "Hartmann operation, rectal resection"
          },
          {
            "code" : "16965008",
            "display" : "Insertion of intra-aortic balloon counterpulsation"
          },
          {
            "code" : "171509005",
            "display" : "Brain cerebrospinal fluid pathway operation"
          },
          {
            "code" : "171841007",
            "display" : "Endoscopic carpal tunnel release"
          },
          {
            "code" : "172043006",
            "display" : "Simple mastectomy"
          },
          {
            "code" : "172049005",
            "display" : "Quadrantectomy of breast"
          },
          {
            "code" : "172132001",
            "display" : "Enucleation of eyeball"
          },
          {
            "code" : "172485001",
            "display" : "Laser trabeculoplasty"
          },
          {
            "code" : "172523009",
            "display" : "Intracapsular extraction of lens"
          },
          {
            "code" : "172524003",
            "display" : "Forceps extraction of lens"
          },
          {
            "code" : "172532006",
            "display" : "YAG laser capsulotomy of lens"
          },
          {
            "code" : "172555009",
            "display" : "Anterior vitrectomy"
          },
          {
            "code" : "172571009",
            "display" : "Epiretinal dissection"
          },
          {
            "code" : "172676009",
            "display" : "Myringotomy and insertion of short-term tympanic ventilation tube"
          },
          {
            "code" : "172679002",
            "display" : "Myringotomy and insertion of T tube"
          },
          {
            "code" : "172732009",
            "display" : "Implantation of intracochlear prosthesis"
          },
          {
            "code" : "172790004",
            "display" : "Submucous resection of nasal septum"
          },
          {
            "code" : "172805009",
            "display" : "Cauterization of nasal turbinate"
          },
          {
            "code" : "172812000",
            "display" : "Cauterization of internal nose"
          },
          {
            "code" : "172825008",
            "display" : "Nasal polypectomy"
          },
          {
            "code" : "17293009",
            "display" : "Bilateral segmental vasectomy and ligation"
          },
          {
            "code" : "173171007",
            "display" : "Lobectomy of lung"
          },
          {
            "code" : "173422009",
            "display" : "Tonsillectomy"
          },
          {
            "code" : "173747005",
            "display" : "Roux-en-Y gastrojejunostomy"
          },
          {
            "code" : "173830003",
            "display" : "Irrigation of stomach"
          },
          {
            "code" : "173977007",
            "display" : "Creation of ileostomy"
          },
          {
            "code" : "173984004",
            "display" : "Attention to ileostomy"
          },
          {
            "code" : "174036004",
            "display" : "Emergency appendectomy"
          },
          {
            "code" : "174396007",
            "display" : "Pilonidal sinus operation"
          },
          {
            "code" : "174776001",
            "display" : "Total splenectomy"
          },
          {
            "code" : "174822005",
            "display" : "Atrial inversion operation using atrial wall"
          },
          {
            "code" : "174826008",
            "display" : "Arterial switch operation"
          },
          {
            "code" : "174830006",
            "display" : "Repair of total anomalous pulmonary venous connection"
          },
          {
            "code" : "174836000",
            "display" : "Repair of defect of the atrioventricular septum"
          },
          {
            "code" : "174900004",
            "display" : "Repair of partial anomalous pulmonary venous connection"
          },
          {
            "code" : "174929002",
            "display" : "Mechanical prosthetic aortic valve replacement"
          },
          {
            "code" : "175095005",
            "display" : "Open ablation of atrioventricular node"
          },
          {
            "code" : "175125003",
            "display" : "Percutaneous transluminal ablation of atrioventricular node"
          },
          {
            "code" : "175135009",
            "display" : "Introduction of cardiac pacemaker system via vein"
          },
          {
            "code" : "175905003",
            "display" : "Total nephrectomy"
          },
          {
            "code" : "175907006",
            "display" : "Nephroureterectomy"
          },
          {
            "code" : "176258007",
            "display" : "Open prostatectomy"
          },
          {
            "code" : "17636008",
            "display" : "Specimen collection"
          },
          {
            "code" : "176548009",
            "display" : "Standard circumcision"
          },
          {
            "code" : "176766002",
            "display" : "Avulsion of lesion of cervix uteri"
          },
          {
            "code" : "176785004",
            "display" : "Non-obstetric encircling suture of cervical os"
          },
          {
            "code" : "176795006",
            "display" : "Subtotal abdominal hysterectomy"
          },
          {
            "code" : "176820000",
            "display" : "Curettage of uterus"
          },
          {
            "code" : "177141003",
            "display" : "Elective cesarean section"
          },
          {
            "code" : "177142005",
            "display" : "Elective upper segment cesarean section"
          },
          {
            "code" : "177143000",
            "display" : "Elective lower segment cesarean section"
          },
          {
            "code" : "177184002",
            "display" : "Normal delivery procedure"
          },
          {
            "code" : "177217006",
            "display" : "Immediate repair of obstetric laceration"
          },
          {
            "code" : "177218001",
            "display" : "Immediate repair of obstetric laceration of uterus or cervix uteri"
          },
          {
            "code" : "177219009",
            "display" : "Immediate repair of obstetric laceration of perineum and sphincter of anus"
          },
          {
            "code" : "177220003",
            "display" : "Immediate repair of obstetric laceration of vagina and floor of pelvis"
          },
          {
            "code" : "177221004",
            "display" : "Immediate repair of minor obstetric laceration"
          },
          {
            "code" : "177250006",
            "display" : "Abdominoplasty"
          },
          {
            "code" : "17744000",
            "display" : "Subtotal hysterectomy after cesarean delivery"
          },
          {
            "code" : "177694006",
            "display" : "Incision and drainage of wound"
          },
          {
            "code" : "177735003",
            "display" : "Excision of wedge of nail"
          },
          {
            "code" : "177765008",
            "display" : "Opening of chest"
          },
          {
            "code" : "177854007",
            "display" : "Simple excision of inguinal hernial sac"
          },
          {
            "code" : "177860007",
            "display" : "Primary repair of inguinal hernia"
          },
          {
            "code" : "177866001",
            "display" : "Bilateral inguinal hernia repair"
          },
          {
            "code" : "178095009",
            "display" : "Excision of ganglion of wrist"
          },
          {
            "code" : "178097001",
            "display" : "Excision of ganglion of knee"
          },
          {
            "code" : "178155009",
            "display" : "Plastic repair of tendon"
          },
          {
            "code" : "178283002",
            "display" : "Block dissection of cervical lymph nodes"
          },
          {
            "code" : "178517008",
            "display" : "Primary excision of cervical intervertebral disc"
          },
          {
            "code" : "17860005",
            "display" : "Low forceps delivery with episiotomy"
          },
          {
            "code" : "178618008",
            "display" : "Primary lumbar discectomy"
          },
          {
            "code" : "178668000",
            "display" : "Percutaneous discectomy"
          },
          {
            "code" : "178728009",
            "display" : "Removal of ureteral stent"
          },
          {
            "code" : "178814008",
            "display" : "Spinal facet joint denervation"
          },
          {
            "code" : "179342005",
            "display" : "Knee joint operation"
          },
          {
            "code" : "179381005",
            "display" : "Arthroscopic partial medial meniscectomy"
          },
          {
            "code" : "179382003",
            "display" : "Arthroscopic total medial meniscectomy"
          },
          {
            "code" : "179383008",
            "display" : "Arthroscopic partial lateral meniscectomy"
          },
          {
            "code" : "180030006",
            "display" : "Amputation of the foot"
          },
          {
            "code" : "180040009",
            "display" : "Amputation lesser toe"
          },
          {
            "code" : "18027006",
            "display" : "Transplantation of liver"
          },
          {
            "code" : "180284004",
            "display" : "Donation of bone marrow"
          },
          {
            "code" : "182678001",
            "display" : "Hyposensitisation to allergens"
          },
          {
            "code" : "182744004",
            "display" : "Extracorporeal circulation procedure"
          },
          {
            "code" : "182764009",
            "display" : "Anticoagulant therapy"
          },
          {
            "code" : "182832007",
            "display" : "Management of drug regimen"
          },
          {
            "code" : "182836005",
            "display" : "Review of medication"
          },
          {
            "code" : "18286008",
            "display" : "Catheter ablation of tissue of heart"
          },
          {
            "code" : "182964004",
            "display" : "Terminal care"
          },
          {
            "code" : "18302006",
            "display" : "Hysterotomy and termination of pregnancy"
          },
          {
            "code" : "183651009",
            "display" : "Chemotherapy follow-up"
          },
          {
            "code" : "183668008",
            "display" : "Total avulsion of nail plate"
          },
          {
            "code" : "185317003",
            "display" : "Telephone encounter"
          },
          {
            "code" : "185389009",
            "display" : "Follow-up visit"
          },
          {
            "code" : "18557009",
            "display" : "Closure by suture"
          },
          {
            "code" : "18629005",
            "display" : "Administration of medication"
          },
          {
            "code" : "18692006",
            "display" : "Bypass gastroenterostomy"
          },
          {
            "code" : "18949003",
            "display" : "Change of dressing"
          },
          {
            "code" : "19063003",
            "display" : "Arthroplasty of knee"
          },
          {
            "code" : "19273005",
            "display" : "Repair of recurrent inguinal hernia"
          },
          {
            "code" : "195565004",
            "display" : "Dilation of esophagus"
          },
          {
            "code" : "19578002",
            "display" : "Arthrodesis"
          },
          {
            "code" : "20418004",
            "display" : "Wedge resection"
          },
          {
            "code" : "20470003",
            "display" : "Destructive procedure on thyroid gland"
          },
          {
            "code" : "20701002",
            "display" : "Open reduction of fracture with internal fixation"
          },
          {
            "code" : "20805001",
            "display" : "Rhinoseptoplasty"
          },
          {
            "code" : "21371007",
            "display" : "Operation on abdominal region"
          },
          {
            "code" : "21525004",
            "display" : "Excision of regional lymph nodes"
          },
          {
            "code" : "21574003",
            "display" : "Repair of aneurysm of abdominal aorta with graft"
          },
          {
            "code" : "225100009",
            "display" : "Replacing dentures"
          },
          {
            "code" : "225113003",
            "display" : "Timed urine collection"
          },
          {
            "code" : "22523008",
            "display" : "Vasectomy"
          },
          {
            "code" : "225271002",
            "display" : "Collection of mid-stream specimen of urine"
          },
          {
            "code" : "225297008",
            "display" : "Care planning and problem solving actions"
          },
          {
            "code" : "225299006",
            "display" : "Equipment-related procedure"
          },
          {
            "code" : "225307000",
            "display" : "Special observation"
          },
          {
            "code" : "225308005",
            "display" : "Observation regime"
          },
          {
            "code" : "225355000",
            "display" : "Care of patient states"
          },
          {
            "code" : "225365006",
            "display" : "Care regime"
          },
          {
            "code" : "225372007",
            "display" : "Total parenteral nutrition"
          },
          {
            "code" : "226007004",
            "display" : "Post-surgical wound care"
          },
          {
            "code" : "228114008",
            "display" : "Child health procedures"
          },
          {
            "code" : "22890008",
            "display" : "Augmentation mammoplasty"
          },
          {
            "code" : "229065009",
            "display" : "Exercise therapy"
          },
          {
            "code" : "229912004",
            "display" : "Enteral feeding"
          },
          {
            "code" : "229917005",
            "display" : "Gastrostomy feeding"
          },
          {
            "code" : "230810008",
            "display" : "Excision of tumor of brain meninges"
          },
          {
            "code" : "231710008",
            "display" : "Keratomileusis"
          },
          {
            "code" : "231734003",
            "display" : "Trabeculoplasty"
          },
          {
            "code" : "231751005",
            "display" : "Exchange of intraocular lens"
          },
          {
            "code" : "232470004",
            "display" : "Reconstruction of nose"
          },
          {
            "code" : "232613003",
            "display" : "Attention to tracheostomy"
          },
          {
            "code" : "232632009",
            "display" : "Wedge excision of lung"
          },
          {
            "code" : "232658009",
            "display" : "Double lung transplant"
          },
          {
            "code" : "232717009",
            "display" : "Coronary artery bypass graft"
          },
          {
            "code" : "232720001",
            "display" : "Coronary artery bypass grafts x 2"
          },
          {
            "code" : "232721002",
            "display" : "Coronary artery bypass grafts x 3"
          },
          {
            "code" : "232722009",
            "display" : "Coronary artery bypass grafts x 4"
          },
          {
            "code" : "232723004",
            "display" : "Coronary artery bypass grafts x 5"
          },
          {
            "code" : "232834008",
            "display" : "Balloon aortic valvotomy"
          },
          {
            "code" : "232841002",
            "display" : "Repair of implanted aortic paravalvular leak"
          },
          {
            "code" : "232957001",
            "display" : "Cardiac support procedure"
          },
          {
            "code" : "233022006",
            "display" : "Construction of conduit - right atrium to pulmonary trunk"
          },
          {
            "code" : "233037005",
            "display" : "Operation to close an interatrial communication"
          },
          {
            "code" : "233134001",
            "display" : "Damus-Stansel-Kaye operation"
          },
          {
            "code" : "233139006",
            "display" : "Norwood type operation"
          },
          {
            "code" : "233143005",
            "display" : "Construction of a cardiac conduit"
          },
          {
            "code" : "233159005",
            "display" : "Ablation operation for arrhythmia"
          },
          {
            "code" : "233161001",
            "display" : "Cryoablation operation for arrhythmia"
          },
          {
            "code" : "233163003",
            "display" : "Radiofrequency ablation operation for arrhythmia"
          },
          {
            "code" : "233169004",
            "display" : "Automatic defibrillator procedure"
          },
          {
            "code" : "233170003",
            "display" : "Implantation of automatic cardiac defibrillator"
          },
          {
            "code" : "233171004",
            "display" : "Removal of automatic cardiac defibrillator"
          },
          {
            "code" : "233174007",
            "display" : "Cardiac pacemaker procedure"
          },
          {
            "code" : "233182007",
            "display" : "Permanent cardiac pacemaker procedure"
          },
          {
            "code" : "233184008",
            "display" : "Maintenance procedure for cardiac pacemaker system"
          },
          {
            "code" : "233185009",
            "display" : "Reprogramming of cardiac pacemaker"
          },
          {
            "code" : "233188006",
            "display" : "Removal of cardiac pacing electrode"
          },
          {
            "code" : "233199008",
            "display" : "Closure of ductus arteriosus with clip"
          },
          {
            "code" : "233224003",
            "display" : "Central aortopulmonary shunt operation"
          },
          {
            "code" : "233230003",
            "display" : "Hemi-Fontan operation"
          },
          {
            "code" : "233370007",
            "display" : "Aortic aneurysm repair"
          },
          {
            "code" : "233445008",
            "display" : "Transjugular intrahepatic portosystemic shunt"
          },
          {
            "code" : "233456008",
            "display" : "Stripping of vein"
          },
          {
            "code" : "233527006",
            "display" : "Central venous cannula insertion"
          },
          {
            "code" : "233553003",
            "display" : "Vascular cannula removal"
          },
          {
            "code" : "234319005",
            "display" : "Splenectomy"
          },
          {
            "code" : "234335003",
            "display" : "Allogeneic unrelated bone marrow transplant"
          },
          {
            "code" : "234336002",
            "display" : "Haemopoietic stem cell transplant"
          },
          {
            "code" : "234647001",
            "display" : "Repair of cleft lip"
          },
          {
            "code" : "234650003",
            "display" : "Repair of bilateral cleft lip"
          },
          {
            "code" : "234808001",
            "display" : "Fit partial denture"
          },
          {
            "code" : "234890003",
            "display" : "Repair of cleft palate"
          },
          {
            "code" : "234891004",
            "display" : "Repair of cleft of hard palate"
          },
          {
            "code" : "234892006",
            "display" : "Repair of cleft of soft palate"
          },
          {
            "code" : "235157009",
            "display" : "Endoscopic brushings of GIT"
          },
          {
            "code" : "235159007",
            "display" : "Percutaneous endoscopic gastrostomy"
          },
          {
            "code" : "235222001",
            "display" : "Attention to gastrostomy"
          },
          {
            "code" : "235462000",
            "display" : "Live donor partial hepatectomy"
          },
          {
            "code" : "235570008",
            "display" : "Dilatation of bile duct"
          },
          {
            "code" : "23580000",
            "display" : "Hemisection of tooth"
          },
          {
            "code" : "236258004",
            "display" : "Needle biopsy of prostate"
          },
          {
            "code" : "236886002",
            "display" : "Hysterectomy"
          },
          {
            "code" : "236887006",
            "display" : "Laparoscopic hysterectomy"
          },
          {
            "code" : "236946009",
            "display" : "Macdonald's cervical cerclage"
          },
          {
            "code" : "236947000",
            "display" : "Shirodkar's cervical cerclage"
          },
          {
            "code" : "236973005",
            "display" : "Delivery procedure"
          },
          {
            "code" : "236974004",
            "display" : "Instrumental delivery"
          },
          {
            "code" : "236985002",
            "display" : "Emergency lower segment cesarean section"
          },
          {
            "code" : "236986001",
            "display" : "Emergency upper segment cesarean section"
          },
          {
            "code" : "236987005",
            "display" : "Emergency cesarean hysterectomy"
          },
          {
            "code" : "236988000",
            "display" : "Elective cesarean hysterectomy"
          },
          {
            "code" : "236989008",
            "display" : "Abdominal delivery for shoulder dystocia"
          },
          {
            "code" : "236991000",
            "display" : "Operation to facilitate delivery"
          },
          {
            "code" : "23719005",
            "display" : "Transplantation of bone marrow"
          },
          {
            "code" : "237406004",
            "display" : "Plastic operation on the breast"
          },
          {
            "code" : "238192002",
            "display" : "Repair of hernia of anterior abdominal wall"
          },
          {
            "code" : "238318009",
            "display" : "Continuous ambulatory peritoneal dialysis"
          },
          {
            "code" : "239431009",
            "display" : "Reconstruction of anterior cruciate ligament of knee joint"
          },
          {
            "code" : "239503002",
            "display" : "Resurfacing of the patella"
          },
          {
            "code" : "23968004",
            "display" : "Colectomy"
          },
          {
            "code" : "240977001",
            "display" : "Biopsy of skin"
          },
          {
            "code" : "24139008",
            "display" : "Cystoscopy"
          },
          {
            "code" : "243120004",
            "display" : "Regimes and therapies"
          },
          {
            "code" : "243121000",
            "display" : "Medical therapy"
          },
          {
            "code" : "243306000",
            "display" : "Ureteroileostomy"
          },
          {
            "code" : "24420007",
            "display" : "Sigmoidoscopy"
          },
          {
            "code" : "24443003",
            "display" : "Total thyroidectomy"
          },
          {
            "code" : "24496007",
            "display" : "Hemorrhoidectomy"
          },
          {
            "code" : "248273008",
            "display" : "Aspiration curettage of uterus after delivery"
          },
          {
            "code" : "250980009",
            "display" : "Cardioversion"
          },
          {
            "code" : "25156005",
            "display" : "Intravenous feeding of patient"
          },
          {
            "code" : "25353009",
            "display" : "Craniotomy"
          },
          {
            "code" : "257822003",
            "display" : "Extracapsular extraction"
          },
          {
            "code" : "257833000",
            "display" : "Internal fixation using staple"
          },
          {
            "code" : "257834006",
            "display" : "Internal fixation using screw"
          },
          {
            "code" : "257835007",
            "display" : "Internal fixation using plate"
          },
          {
            "code" : "25789004",
            "display" : "Lumbosacral arthrodesis"
          },
          {
            "code" : "25811000",
            "display" : "Bilateral complete salpingectomy"
          },
          {
            "code" : "25828002",
            "display" : "Mid forceps delivery with episiotomy"
          },
          {
            "code" : "25953003",
            "display" : "Colostomy management and care"
          },
          {
            "code" : "2598006",
            "display" : "Open heart surgery"
          },
          {
            "code" : "260216002",
            "display" : "ICCE"
          },
          {
            "code" : "261537001",
            "display" : "Insertion of interatrial baffle"
          },
          {
            "code" : "261540001",
            "display" : "Laminotomy"
          },
          {
            "code" : "26212005",
            "display" : "Replacement of aortic valve"
          },
          {
            "code" : "26294005",
            "display" : "Radical prostatectomy"
          },
          {
            "code" : "26313002",
            "display" : "Delivery by vacuum extraction with episiotomy"
          },
          {
            "code" : "26390003",
            "display" : "Total colectomy"
          },
          {
            "code" : "26476002",
            "display" : "Operation on bronchus"
          },
          {
            "code" : "264957007",
            "display" : "Insertion of pleural tube drain"
          },
          {
            "code" : "264959005",
            "display" : "Primary repair of femoral hernia"
          },
          {
            "code" : "265056007",
            "display" : "Vaginal hysterectomy"
          },
          {
            "code" : "265060005",
            "display" : "Endometrial ablation"
          },
          {
            "code" : "265132005",
            "display" : "Primary open reduction and internal fixation of proximal femoral fracture with screw/nail and plate device"
          },
          {
            "code" : "265157000",
            "display" : "Total prosthetic replacement of hip joint using cement"
          },
          {
            "code" : "265160007",
            "display" : "Total prosthetic replacement of hip joint not using cement"
          },
          {
            "code" : "265170009",
            "display" : "Total prosthetic replacement of knee joint using cement"
          },
          {
            "code" : "265244003",
            "display" : "Endocrine system and/or breast operations"
          },
          {
            "code" : "265246001",
            "display" : "Thyroid gland and/or parathyroid gland operations"
          },
          {
            "code" : "265250008",
            "display" : "Reduction mammoplasty, bilateral"
          },
          {
            "code" : "265472007",
            "display" : "Plastic repair of mitral valve"
          },
          {
            "code" : "265473002",
            "display" : "Plastic repair of aortic valve"
          },
          {
            "code" : "265542003",
            "display" : "Ligation of long saphenous vein"
          },
          {
            "code" : "265636007",
            "display" : "Cerclage of uterine cervix"
          },
          {
            "code" : "265703000",
            "display" : "Jaw and temporomandibular joint operations"
          },
          {
            "code" : "265764009",
            "display" : "Renal dialysis"
          },
          {
            "code" : "26578004",
            "display" : "Hysterotomy with removal of hydatidiform mole"
          },
          {
            "code" : "265855005",
            "display" : "Varicose vein stripping"
          },
          {
            "code" : "266700009",
            "display" : "Assisted breathing"
          },
          {
            "code" : "266717002",
            "display" : "Hormone replacement therapy"
          },
          {
            "code" : "266740003",
            "display" : "Orthoptic treatment"
          },
          {
            "code" : "26786002",
            "display" : "Scleral buckling"
          },
          {
            "code" : "268481000",
            "display" : "Child health care"
          },
          {
            "code" : "271422003",
            "display" : "Fit denture"
          },
          {
            "code" : "272300006",
            "display" : "Closed reduction of fracture of femur with internal fixation"
          },
          {
            "code" : "27315000",
            "display" : "Removal of breast implant"
          },
          {
            "code" : "274022008",
            "display" : "Repair of coarctation of aorta"
          },
          {
            "code" : "274023003",
            "display" : "Varicose vein operation"
          },
          {
            "code" : "274026006",
            "display" : "Gastrointestinal anastomosis procedure"
          },
          {
            "code" : "274068006",
            "display" : "Excision of lipoma"
          },
          {
            "code" : "274330002",
            "display" : "Surgical biopsy"
          },
          {
            "code" : "274331003",
            "display" : "Surgical biopsy of breast"
          },
          {
            "code" : "274407009",
            "display" : "Intrauterine device check"
          },
          {
            "code" : "27480002",
            "display" : "Excision of bunion"
          },
          {
            "code" : "275001008",
            "display" : "Myringotomy and insertion of long-term ventilation tube"
          },
          {
            "code" : "275066000",
            "display" : "Open insertion of Hickman central venous catheter"
          },
          {
            "code" : "275227003",
            "display" : "Myocardial revascularization"
          },
          {
            "code" : "275305005",
            "display" : "Antenatal/postnatal care"
          },
          {
            "code" : "276239002",
            "display" : "Therapy"
          },
          {
            "code" : "276272002",
            "display" : "Catheter procedure"
          },
          {
            "code" : "276861004",
            "display" : "Percutaneous balloon angioplasty of artery"
          },
          {
            "code" : "277762005",
            "display" : "Lumbar puncture"
          },
          {
            "code" : "277764006",
            "display" : "Fusion of posterior lumbar spine"
          },
          {
            "code" : "278257006",
            "display" : "Peripheral blood stem cell graft"
          },
          {
            "code" : "278414003",
            "display" : "Pain management"
          },
          {
            "code" : "27842006",
            "display" : "Radical excision of lymph nodes"
          },
          {
            "code" : "278450005",
            "display" : "Finger stick"
          },
          {
            "code" : "27865001",
            "display" : "Excision of bilateral breasts"
          },
          {
            "code" : "280392009",
            "display" : "Shunt procedure into peritoneum"
          },
          {
            "code" : "280478004",
            "display" : "Gastrointestinal and digestive anastomosis"
          },
          {
            "code" : "281811000",
            "display" : "Arthroscopic knee operation"
          },
          {
            "code" : "282191000",
            "display" : "Laminotomy for decompression and exploration"
          },
          {
            "code" : "284181007",
            "display" : "Incision and drainage of abscess"
          },
          {
            "code" : "284532000",
            "display" : "Myringotomy and insertion of tympanic ventilation tube"
          },
          {
            "code" : "28510009",
            "display" : "Replacement of tracheal stent"
          },
          {
            "code" : "285570007",
            "display" : "Taking of swab"
          },
          {
            "code" : "285662005",
            "display" : "Removal of plate from bone"
          },
          {
            "code" : "285663000",
            "display" : "Removal of bone screw from bone"
          },
          {
            "code" : "287310004",
            "display" : "Lung tumour excision"
          },
          {
            "code" : "287664005",
            "display" : "Bilateral tubal ligation"
          },
          {
            "code" : "28768007",
            "display" : "Incisional biopsy of breast mass"
          },
          {
            "code" : "287708003",
            "display" : "Transurethral bladder excision"
          },
          {
            "code" : "287793003",
            "display" : "Intestine bypass shunt"
          },
          {
            "code" : "287977004",
            "display" : "Dilation/incision of cervix - delivery aid"
          },
          {
            "code" : "288042004",
            "display" : "Hysterectomy and fetus removal"
          },
          {
            "code" : "288043009",
            "display" : "Hysterectomy in pregnancy"
          },
          {
            "code" : "288161003",
            "display" : "Orthopedic device application"
          },
          {
            "code" : "28913000",
            "display" : "Tonsillectomy and adenoidectomy"
          },
          {
            "code" : "293820001",
            "display" : "Keratoplasty"
          },
          {
            "code" : "29672006",
            "display" : "Partial oophorectomy"
          },
          {
            "code" : "297279009",
            "display" : "Administration of steroid"
          },
          {
            "code" : "297709009",
            "display" : "Open acromioplasty for decompression of rotator cuff"
          },
          {
            "code" : "29827000",
            "display" : "Bilateral salpingectomy with oophorectomy"
          },
          {
            "code" : "300009002",
            "display" : "Removal of acoustic neuroma"
          },
          {
            "code" : "300589005",
            "display" : "Excision of sebaceous cyst"
          },
          {
            "code" : "30123000",
            "display" : "Repair of atrial septal defect with prosthesis by closed heart technique"
          },
          {
            "code" : "301784005",
            "display" : "Ileostomy operation"
          },
          {
            "code" : "301889008",
            "display" : "Excision of malignant skin tumor"
          },
          {
            "code" : "301890004",
            "display" : "Excision of skin cyst"
          },
          {
            "code" : "302152006",
            "display" : "Small intestine stoma procedure"
          },
          {
            "code" : "302171008",
            "display" : "Adjust hearing aid settings"
          },
          {
            "code" : "302190000",
            "display" : "Abdominal hysterectomy and right salpingo-oophorectomy"
          },
          {
            "code" : "302191001",
            "display" : "Abdominal hysterectomy and left salpingo-oophorectomy"
          },
          {
            "code" : "302343007",
            "display" : "Insertion of prosthesis for breast"
          },
          {
            "code" : "302369001",
            "display" : "Clitoridectomy"
          },
          {
            "code" : "302375005",
            "display" : "Operative termination of pregnancy"
          },
          {
            "code" : "302441008",
            "display" : "Liposuction of subcutaneous tissue"
          },
          {
            "code" : "302490008",
            "display" : "Arthroscopic meniscectomy"
          },
          {
            "code" : "302497006",
            "display" : "Haemodialysis"
          },
          {
            "code" : "302605004",
            "display" : "Forced manual dilatation of anus"
          },
          {
            "code" : "303633008",
            "display" : "Irrigation of maxillary antrum"
          },
          {
            "code" : "303648002",
            "display" : "Excision of papilloma"
          },
          {
            "code" : "303650005",
            "display" : "Removal of mole of skin by excision"
          },
          {
            "code" : "304039000",
            "display" : "Skin flap operation"
          },
          {
            "code" : "304040003",
            "display" : "Grafting to skin"
          },
          {
            "code" : "304384006",
            "display" : "Complete repair of rotator cuff"
          },
          {
            "code" : "30456009",
            "display" : "Open heart valvuloplasty without replacement of valve"
          },
          {
            "code" : "30542005",
            "display" : "Implantation of umbrella into vena cava"
          },
          {
            "code" : "30549001",
            "display" : "Removal of suture"
          },
          {
            "code" : "307273008",
            "display" : "Cautery of wart"
          },
          {
            "code" : "307279007",
            "display" : "Prosthetic replacement of heart valve"
          },
          {
            "code" : "307280005",
            "display" : "Implantation of cardiac pacemaker"
          },
          {
            "code" : "307546008",
            "display" : "Operation on brain ventricle"
          },
          {
            "code" : "307771009",
            "display" : "Radical abdominal hysterectomy"
          },
          {
            "code" : "307815000",
            "display" : "Arthroplasty of hip without cement"
          },
          {
            "code" : "308665009",
            "display" : "Repair of pulmonary valve with tissue graft"
          },
          {
            "code" : "308695001",
            "display" : "Intracapsular cataract extraction and insertion of intraocular lens"
          },
          {
            "code" : "308696000",
            "display" : "Coarctation angioplasty"
          },
          {
            "code" : "30880003",
            "display" : "Trabeculectomy ab externo"
          },
          {
            "code" : "30904006",
            "display" : "Vascular surgery procedure"
          },
          {
            "code" : "309430005",
            "display" : "Excision of skin tag"
          },
          {
            "code" : "309431009",
            "display" : "Arthroscopy of knee"
          },
          {
            "code" : "30956003",
            "display" : "Subtotal thyroidectomy"
          },
          {
            "code" : "309879006",
            "display" : "Abdominal hysterocolpectomy"
          },
          {
            "code" : "310582005",
            "display" : "Implantation of intravenous dual chamber permanent cardiac pacemaker"
          },
          {
            "code" : "311774002",
            "display" : "Colonoscopic polypectomy"
          },
          {
            "code" : "312235007",
            "display" : "Radiolabeled antibody therapy"
          },
          {
            "code" : "312775003",
            "display" : "Debridement of ulcer"
          },
          {
            "code" : "312876006",
            "display" : "Taking urethral swab"
          },
          {
            "code" : "312879004",
            "display" : "Taking ear swab"
          },
          {
            "code" : "312965008",
            "display" : "Laser assisted in situ keratomileusis"
          },
          {
            "code" : "312968005",
            "display" : "Excision biopsy of skin lesion"
          },
          {
            "code" : "313039003",
            "display" : "Solid organ transplant"
          },
          {
            "code" : "313270001",
            "display" : "Percutaneous insertion of nephrostomy tube"
          },
          {
            "code" : "314128006",
            "display" : "Laparoscopic Nissen fundoplication using abdominal approach"
          },
          {
            "code" : "31501000",
            "display" : "Ethmoid sinusectomy"
          },
          {
            "code" : "315059002",
            "display" : "Laparoscopic salpingectomy"
          },
          {
            "code" : "315308008",
            "display" : "Dilatation of cervix for delivery"
          },
          {
            "code" : "31932005",
            "display" : "Tympanomastoidectomy"
          },
          {
            "code" : "32413006",
            "display" : "Transplantation of heart"
          },
          {
            "code" : "32477003",
            "display" : "Heart-lung transplant with recipient cardiectomy-pneumonectomy"
          },
          {
            "code" : "3249005",
            "display" : "Surgical construction of filtration bleb"
          },
          {
            "code" : "33149006",
            "display" : "Pancreatectomy"
          },
          {
            "code" : "33195004",
            "display" : "External beam radiation therapy procedure"
          },
          {
            "code" : "33496007",
            "display" : "Mammoplasty"
          },
          {
            "code" : "34068001",
            "display" : "Heart valve replacement"
          },
          {
            "code" : "3418002",
            "display" : "Chondrectomy of spine"
          },
          {
            "code" : "34238000",
            "display" : "Lumbar and lumbosacral fusion by posterior technique"
          },
          {
            "code" : "34536000",
            "display" : "Amniocentesis"
          },
          {
            "code" : "34853001",
            "display" : "Operation on intestine"
          },
          {
            "code" : "34969007",
            "display" : "Operation on retroperitoneum"
          },
          {
            "code" : "3515001",
            "display" : "Replacement of electronic heart device, pulse generator"
          },
          {
            "code" : "35350000",
            "display" : "Implantation of aortic valve prosthesis or synthetic device"
          },
          {
            "code" : "35646002",
            "display" : "Excision of lesion of skin"
          },
          {
            "code" : "35860002",
            "display" : "Repair by nailing"
          },
          {
            "code" : "359551000",
            "display" : "Angioplasty of vein"
          },
          {
            "code" : "359608009",
            "display" : "Implantation of cochlear prosthetic device, electrode and receiver"
          },
          {
            "code" : "359612003",
            "display" : "Implantation of cochlear prosthetic device"
          },
          {
            "code" : "359623004",
            "display" : "Total lobectomy of lung"
          },
          {
            "code" : "35963001",
            "display" : "Removal of staples"
          },
          {
            "code" : "359715005",
            "display" : "Upper gastrointestinal procedure"
          },
          {
            "code" : "359718007",
            "display" : "Upper digestive tract operation"
          },
          {
            "code" : "359722002",
            "display" : "Upper gastrointestinal operation"
          },
          {
            "code" : "359887003",
            "display" : "Nissen fundoplication"
          },
          {
            "code" : "359901001",
            "display" : "Neuroplasty and transposition of median nerve at carpal tunnel"
          },
          {
            "code" : "359908007",
            "display" : "Repair of paraesophageal diaphragmatic hernia"
          },
          {
            "code" : "361222003",
            "display" : "Wertheim-Meigs abdominal hysterectomy"
          },
          {
            "code" : "361223008",
            "display" : "Wertheim operation"
          },
          {
            "code" : "36228007",
            "display" : "Ophthalmic examination and evaluation"
          },
          {
            "code" : "362958002",
            "display" : "Procedure by site"
          },
          {
            "code" : "363066000",
            "display" : "Destructive procedure by anatomic site"
          },
          {
            "code" : "363187007",
            "display" : "Limb operation"
          },
          {
            "code" : "363259005",
            "display" : "Patient management procedure"
          },
          {
            "code" : "363691001",
            "display" : "Procedure categorized by device involved"
          },
          {
            "code" : "36576007",
            "display" : "Infusion"
          },
          {
            "code" : "367336001",
            "display" : "Chemotherapy"
          },
          {
            "code" : "36969009",
            "display" : "Placement of stent in coronary artery"
          },
          {
            "code" : "36995006",
            "display" : "Drainage of external ear"
          },
          {
            "code" : "37053006",
            "display" : "Open reduction of fracture of humerus with internal fixation"
          },
          {
            "code" : "370611004",
            "display" : "Excision of malignant neoplasm"
          },
          {
            "code" : "370612006",
            "display" : "Excision of neoplasm"
          },
          {
            "code" : "371186005",
            "display" : "Amputation of toe"
          },
          {
            "code" : "3713005",
            "display" : "Release for de Quervain's tenosynovitis of hand"
          },
          {
            "code" : "371345007",
            "display" : "Laser iridotomy"
          },
          {
            "code" : "37153009",
            "display" : "Implantation of heart valve with tissue graft"
          },
          {
            "code" : "372246008",
            "display" : "Intracranial procedure"
          },
          {
            "code" : "37236007",
            "display" : "Dermabrasion"
          },
          {
            "code" : "372456005",
            "display" : "Repair of obstetric laceration"
          },
          {
            "code" : "373353005",
            "display" : "Surgical procedure on eye proper"
          },
          {
            "code" : "373385008",
            "display" : "Surgical repair of head and neck structure"
          },
          {
            "code" : "373415004",
            "display" : "Implantation of posterior chamber intraocular lens"
          },
          {
            "code" : "37508003",
            "display" : "Operation on neck"
          },
          {
            "code" : "37661000",
            "display" : "Operation on digestive tract"
          },
          {
            "code" : "37705003",
            "display" : "Collection of sputum"
          },
          {
            "code" : "38102005",
            "display" : "Cholecystectomy"
          },
          {
            "code" : "384641003",
            "display" : "Repair of mitral valve"
          },
          {
            "code" : "384642005",
            "display" : "Mitral valvuloplasty"
          },
          {
            "code" : "384643000",
            "display" : "Repair of tricuspid valve"
          },
          {
            "code" : "384676001",
            "display" : "Operation on mouth"
          },
          {
            "code" : "384692006",
            "display" : "Intracavitary brachytherapy"
          },
          {
            "code" : "384719006",
            "display" : "Procedure on gastrointestinal tract"
          },
          {
            "code" : "384723003",
            "display" : "Radical mastectomy"
          },
          {
            "code" : "38526002",
            "display" : "Vaginoscopy with biopsy of cervix"
          },
          {
            "code" : "385468004",
            "display" : "Cataract extraction and insertion of intraocular lens"
          },
          {
            "code" : "385487005",
            "display" : "Surgical procedure on thorax"
          },
          {
            "code" : "385488000",
            "display" : "Surgical procedure on chest wall"
          },
          {
            "code" : "385712009",
            "display" : "Ostomy care"
          },
          {
            "code" : "385715006",
            "display" : "Cardiac care"
          },
          {
            "code" : "385759002",
            "display" : "Provision of community special services"
          },
          {
            "code" : "385904005",
            "display" : "Removal of ear wax"
          },
          {
            "code" : "385984007",
            "display" : "Growth and development treatments and procedures"
          },
          {
            "code" : "386087005",
            "display" : "Collection of aspirated sputum"
          },
          {
            "code" : "386089008",
            "display" : "Collection of coughed sputum"
          },
          {
            "code" : "386099003",
            "display" : "Spot urine procedure"
          },
          {
            "code" : "386230005",
            "display" : "Case management"
          },
          {
            "code" : "386333005",
            "display" : "Infant care"
          },
          {
            "code" : "386340006",
            "display" : "Intravenous therapy"
          },
          {
            "code" : "386556002",
            "display" : "Repair of middle ear"
          },
          {
            "code" : "386607008",
            "display" : "Iridotomy"
          },
          {
            "code" : "386609006",
            "display" : "Procedure on vein"
          },
          {
            "code" : "386621005",
            "display" : "Operation on gastrointestinal tract"
          },
          {
            "code" : "386637004",
            "display" : "Obstetric procedure"
          },
          {
            "code" : "386638009",
            "display" : "Obstetric operation"
          },
          {
            "code" : "386649003",
            "display" : "Partial hip replacement by prosthesis"
          },
          {
            "code" : "386718000",
            "display" : "Endoscopic retrograde cholangiopancreatography"
          },
          {
            "code" : "386745004",
            "display" : "Transurethral cystoscopy"
          },
          {
            "code" : "386765006",
            "display" : "Operation on mediastinum"
          },
          {
            "code" : "386792000",
            "display" : "Transurethral resection of bladder neoplasm"
          },
          {
            "code" : "386802000",
            "display" : "Endometrial biopsy"
          },
          {
            "code" : "387643005",
            "display" : "Partial hysterectomy"
          },
          {
            "code" : "387644004",
            "display" : "Supracervical hysterectomy"
          },
          {
            "code" : "387711001",
            "display" : "Pubiotomy to assist delivery"
          },
          {
            "code" : "387713003",
            "display" : "Surgical procedure"
          },
          {
            "code" : "387714009",
            "display" : "Operation on lung"
          },
          {
            "code" : "387715005",
            "display" : "Peritoneal lavage"
          },
          {
            "code" : "387731002",
            "display" : "Laminectomy"
          },
          {
            "code" : "387740003",
            "display" : "Removal of ovarian cyst"
          },
          {
            "code" : "387760006",
            "display" : "Infusion care"
          },
          {
            "code" : "38829003",
            "display" : "Partial excision"
          },
          {
            "code" : "389095005",
            "display" : "Contraception care"
          },
          {
            "code" : "390906007",
            "display" : "Follow-up encounter"
          },
          {
            "code" : "391897002",
            "display" : "Aspiration curettage of uterus for termination of pregnancy"
          },
          {
            "code" : "391998006",
            "display" : "Dilation and curettage of uterus after delivery"
          },
          {
            "code" : "392000009",
            "display" : "Hysterotomy for retained placenta"
          },
          {
            "code" : "392003006",
            "display" : "Colposcopy"
          },
          {
            "code" : "392011001",
            "display" : "Operation on skin"
          },
          {
            "code" : "39202005",
            "display" : "Coronary artery bypass with autogenous graft, four grafts"
          },
          {
            "code" : "392021009",
            "display" : "Lumpectomy of breast"
          },
          {
            "code" : "392031002",
            "display" : "Endarterectomy"
          },
          {
            "code" : "392048005",
            "display" : "Operation on urinary system"
          },
          {
            "code" : "392090004",
            "display" : "Operation on breast"
          },
          {
            "code" : "392134007",
            "display" : "Care regimes management"
          },
          {
            "code" : "392230005",
            "display" : "Catheterization of vein"
          },
          {
            "code" : "392236004",
            "display" : "Operative procedure on spinal structure"
          },
          {
            "code" : "392446004",
            "display" : "Attention to device, anastomosis AND/OR stoma"
          },
          {
            "code" : "395218007",
            "display" : "Implantation of internal cardiac defibrillator"
          },
          {
            "code" : "395321006",
            "display" : "Foley catheter long term use"
          },
          {
            "code" : "39633000",
            "display" : "Amputation of hallux"
          },
          {
            "code" : "396490007",
            "display" : "Myringoplasty"
          },
          {
            "code" : "397117006",
            "display" : "Amputation of lower limb"
          },
          {
            "code" : "397193006",
            "display" : "Percutaneous transluminal coronary angioplasty by rotoablation"
          },
          {
            "code" : "397395005",
            "display" : "Lavage of bronchus"
          },
          {
            "code" : "397431004",
            "display" : "Percutaneous transluminal coronary angioplasty with rotoablation, single vessel"
          },
          {
            "code" : "397516006",
            "display" : "Photorefractive keratoplasty"
          },
          {
            "code" : "397760009",
            "display" : "Tympanotomy"
          },
          {
            "code" : "397862008",
            "display" : "Tympanostomy"
          },
          {
            "code" : "398010007",
            "display" : "Prosthetic arthroplasty of hip"
          },
          {
            "code" : "398027004",
            "display" : "Excision of varicose vein of lower limb"
          },
          {
            "code" : "398182006",
            "display" : "Insertion of inferior vena caval filter"
          },
          {
            "code" : "39845007",
            "display" : "Anterior colporrhaphy"
          },
          {
            "code" : "398740003",
            "display" : "Colostomy"
          },
          {
            "code" : "399141000",
            "display" : "Male sterilization"
          },
          {
            "code" : "399315003",
            "display" : "Radionuclide therapy"
          },
          {
            "code" : "399867007",
            "display" : "Laser photocoagulation to retina"
          },
          {
            "code" : "400053006",
            "display" : "Amputation of limb"
          },
          {
            "code" : "40059006",
            "display" : "Creation of aortofemoral shunt"
          },
          {
            "code" : "40219000",
            "display" : "Delivery by Malstrom's extraction with episiotomy"
          },
          {
            "code" : "40250003",
            "display" : "Interatrial transposition of venous return"
          },
          {
            "code" : "405525004",
            "display" : "Repair of aneurysm of abdominal aorta"
          },
          {
            "code" : "405784000",
            "display" : "Pharmacological assessment"
          },
          {
            "code" : "40617009",
            "display" : "Artificial respiration"
          },
          {
            "code" : "406224006",
            "display" : "Reproductive care"
          },
          {
            "code" : "406505007",
            "display" : "Modified radical mastectomy"
          },
          {
            "code" : "40654000",
            "display" : "Operation on eyelid"
          },
          {
            "code" : "40862005",
            "display" : "Local excision of skin and subcutaneous tissue"
          },
          {
            "code" : "408817009",
            "display" : "Amniotomy at delivery"
          },
          {
            "code" : "409023009",
            "display" : "Professional / ancillary services care"
          },
          {
            "code" : "409061007",
            "display" : "Caretaking/parenting skills treatments and procedures"
          },
          {
            "code" : "410083007",
            "display" : "Rehabilitation therapy management"
          },
          {
            "code" : "41059002",
            "display" : "Cesarean hysterectomy"
          },
          {
            "code" : "410614008",
            "display" : "Construction"
          },
          {
            "code" : "413144006",
            "display" : "Abdominal hysterectomy with conservation of ovaries"
          },
          {
            "code" : "41339005",
            "display" : "Coronary angioplasty"
          },
          {
            "code" : "413467001",
            "display" : "Aftercare"
          },
          {
            "code" : "41371003",
            "display" : "Perineal prostatectomy"
          },
          {
            "code" : "414088005",
            "display" : "Emergency CABG"
          },
          {
            "code" : "41453009",
            "display" : "Strabismus surgery"
          },
          {
            "code" : "414582004",
            "display" : "Laser assisted subepithelial keratomileusis"
          },
          {
            "code" : "415070008",
            "display" : "Percutaneous coronary intervention"
          },
          {
            "code" : "41817002",
            "display" : "Closure of patent foramen ovale"
          },
          {
            "code" : "418285008",
            "display" : "Angioplasty of blood vessel"
          },
          {
            "code" : "418576007",
            "display" : "Harvesting of peripheral blood stem cells"
          },
          {
            "code" : "418926001",
            "display" : "Harvesting of stem cells"
          },
          {
            "code" : "41976001",
            "display" : "Cardiac catheterization"
          },
          {
            "code" : "42034009",
            "display" : "Enterostomy management and care"
          },
          {
            "code" : "42101009",
            "display" : "Penetrating keratoplasty"
          },
          {
            "code" : "42262007",
            "display" : "Total shoulder replacement"
          },
          {
            "code" : "423827005",
            "display" : "Endoscopy"
          },
          {
            "code" : "424525001",
            "display" : "Antenatal care"
          },
          {
            "code" : "425196008",
            "display" : "Insertion of peripherally inserted central catheter"
          },
          {
            "code" : "425435003",
            "display" : "Implantation of cardioverter defibrillator with one electrode lead"
          },
          {
            "code" : "425767004",
            "display" : "Implantation of radioactive seed into prostate"
          },
          {
            "code" : "425843001",
            "display" : "Allogeneic peripheral blood stem cell transplant"
          },
          {
            "code" : "425934009",
            "display" : "Cardioverter defibrillator procedure"
          },
          {
            "code" : "425983008",
            "display" : "Autologous peripheral blood stem cell transplant"
          },
          {
            "code" : "426153007",
            "display" : "Insertion of artificial airway"
          },
          {
            "code" : "426931009",
            "display" : "Subacute bacterial endocarditis prophylaxis"
          },
          {
            "code" : "427107006",
            "display" : "Excision of accessory uterus"
          },
          {
            "code" : "427508005",
            "display" : "Implantation of cardioverter defibrillator with two electrode leads"
          },
          {
            "code" : "427752004",
            "display" : "Excision of lamina of lumbar vertebra for decompression of spinal cord"
          },
          {
            "code" : "427886002",
            "display" : "Total cavopulmonary connection with lateral atrial tunnel"
          },
          {
            "code" : "428488008",
            "display" : "Placement of stent in anterior descending branch of left coronary artery"
          },
          {
            "code" : "428613004",
            "display" : "Correction of congenital cardiovascular deformity"
          },
          {
            "code" : "428625001",
            "display" : "Replacement of cardioverter defibrillator"
          },
          {
            "code" : "428663009",
            "display" : "Ablation of atrioventricular node"
          },
          {
            "code" : "428817001",
            "display" : "Insertion of stent into ureter"
          },
          {
            "code" : "428989006",
            "display" : "Operation on ganglion cyst"
          },
          {
            "code" : "429446009",
            "display" : "Insertion of catheter into blood vessel"
          },
          {
            "code" : "429595007",
            "display" : "Resection of neoplasm of heart"
          },
          {
            "code" : "429616001",
            "display" : "Aortopulmonary reconstruction with right ventricle to pulmonary arterial valveless conduit"
          },
          {
            "code" : "429620002",
            "display" : "Construction of left ventricle to aorta tunnel with right ventricle to pulmonary artery valved conduit"
          },
          {
            "code" : "429639007",
            "display" : "Percutaneous transluminal balloon angioplasty with insertion of stent into coronary artery"
          },
          {
            "code" : "429653007",
            "display" : "Repair of reducible inguinal hernia"
          },
          {
            "code" : "430715008",
            "display" : "Bariatric operative procedure"
          },
          {
            "code" : "43075005",
            "display" : "Partial resection of colon"
          },
          {
            "code" : "431316002",
            "display" : "Laparoscopic subtotal hysterectomy"
          },
          {
            "code" : "431339008",
            "display" : "Mechanical prosthetic mitral valve replacement"
          },
          {
            "code" : "432102000",
            "display" : "Administration of substance"
          },
          {
            "code" : "432114008",
            "display" : "Closure of atrial septal defect using fluoroscopic guidance"
          },
          {
            "code" : "432394003",
            "display" : "Repair of mitral valve using fluoroscopic guidance"
          },
          {
            "code" : "432670006",
            "display" : "Closure of patent foramen ovale using fluoroscopic guidance"
          },
          {
            "code" : "4365001",
            "display" : "Surgical repair"
          },
          {
            "code" : "43815004",
            "display" : "Implantation of cochlear prosthetic device, single channel"
          },
          {
            "code" : "439740005",
            "display" : "Postoperative follow-up visit"
          },
          {
            "code" : "439958008",
            "display" : "Sampling of cervix for Papanicolaou smear"
          },
          {
            "code" : "44119001",
            "display" : "Anastomosis of small intestine to small intestine"
          },
          {
            "code" : "441612006",
            "display" : "Repair of infrarenal abdominal aortic aneurysm with insertion of endovascular stent"
          },
          {
            "code" : "44166002",
            "display" : "Radical excision of skin lesion"
          },
          {
            "code" : "441676000",
            "display" : "Occlusion of patent ductus arteriosus using embolization coil"
          },
          {
            "code" : "441873006",
            "display" : "Percutaneous replacement of aortic valve using fluoroscopic guidance"
          },
          {
            "code" : "442087005",
            "display" : "Closure of ventricular septal defect using fluoroscopic guidance"
          },
          {
            "code" : "442123009",
            "display" : "Sano procedure"
          },
          {
            "code" : "44218004",
            "display" : "Implantation of cochlear electrode"
          },
          {
            "code" : "442249009",
            "display" : "Implantation of cardioverter defibrillator with three electrode leads"
          },
          {
            "code" : "442309004",
            "display" : "Insertion of tunnelled venous catheter"
          },
          {
            "code" : "442460002",
            "display" : "Procedure on wound"
          },
          {
            "code" : "442558001",
            "display" : "Partial amputation of hand"
          },
          {
            "code" : "44337006",
            "display" : "Incision of gallbladder"
          },
          {
            "code" : "443434006",
            "display" : "Replacement of dual chamber pulse generator"
          },
          {
            "code" : "443681002",
            "display" : "Total replacement of left knee joint"
          },
          {
            "code" : "443682009",
            "display" : "Total replacement of right knee joint"
          },
          {
            "code" : "44378008",
            "display" : "Partial colectomy with anastomosis"
          },
          {
            "code" : "443829004",
            "display" : "Percutaneous transluminal balloon angioplasty of coarctation of aorta with insertion of stent"
          },
          {
            "code" : "443887000",
            "display" : "Transapical implantation of aortic valve"
          },
          {
            "code" : "443906008",
            "display" : "Bypass of stomach with short limb Roux-en-Y gastroenterostomy"
          },
          {
            "code" : "443989003",
            "display" : "Bidirectional Glenn shunt procedure of left superior vena cava"
          },
          {
            "code" : "444001009",
            "display" : "Right Glenn shunt procedure"
          },
          {
            "code" : "444034006",
            "display" : "Bidirectional Glenn shunt procedure of right superior vena cava"
          },
          {
            "code" : "444178004",
            "display" : "Left Glenn shunt procedure"
          },
          {
            "code" : "44441009",
            "display" : "Flexible fibreoptic sigmoidoscopy"
          },
          {
            "code" : "444566006",
            "display" : "Replacement of cardiac pacemaker"
          },
          {
            "code" : "444588006",
            "display" : "Endovascular repair of abdominal aortic aneurysm"
          },
          {
            "code" : "444783004",
            "display" : "Screening colonoscopy"
          },
          {
            "code" : "444813003",
            "display" : "Prophylactic immunotherapy"
          },
          {
            "code" : "445185007",
            "display" : "Resurfacing of head of femur"
          },
          {
            "code" : "445223007",
            "display" : "Harvesting of stem cells for allotransplant"
          },
          {
            "code" : "445429009",
            "display" : "Cervical laminectomy"
          },
          {
            "code" : "44558001",
            "display" : "Repair of inguinal hernia"
          },
          {
            "code" : "445982009",
            "display" : "Endoscopy and biopsy of upper gastrointestinal tract"
          },
          {
            "code" : "446775007",
            "display" : "Collection of urine via indwelling urinary catheter"
          },
          {
            "code" : "446860008",
            "display" : "Collection of cerebrospinal fluid via ventriculoperitoneal shunt"
          },
          {
            "code" : "44777001",
            "display" : "Creation of conduit between right ventricle and pulmonary artery"
          },
          {
            "code" : "448808006",
            "display" : "Fusion of cervicothoracic region of spine by anterior approach"
          },
          {
            "code" : "448942003",
            "display" : "Fusion of lumbosacral region of spine by posterior approach"
          },
          {
            "code" : "448943008",
            "display" : "Fusion of thoracolumbar region of spine by anterior approach"
          },
          {
            "code" : "448944002",
            "display" : "Fusion of thoracolumbar region of spine by posterior approach"
          },
          {
            "code" : "449048009",
            "display" : "Fusion of lumbosacral region of spine by anterior approach"
          },
          {
            "code" : "449320003",
            "display" : "Ligation and stripping of varicose vein of lower limb"
          },
          {
            "code" : "449389000",
            "display" : "Placement of stent in cardiac conduit"
          },
          {
            "code" : "44946007",
            "display" : "Repair of umbilical hernia"
          },
          {
            "code" : "450350009",
            "display" : "Primary repair of cleft palate"
          },
          {
            "code" : "450779000",
            "display" : "Uncemented total replacement of joint"
          },
          {
            "code" : "450874000",
            "display" : "Collection of first stream urine specimen"
          },
          {
            "code" : "45211000",
            "display" : "Catheterization"
          },
          {
            "code" : "45595009",
            "display" : "Laparoscopic cholecystectomy"
          },
          {
            "code" : "45681003",
            "display" : "Incision, exploration and biopsy for determination of stage of disease"
          },
          {
            "code" : "45921003",
            "display" : "Removal of cardiac pacemaker electrodes with replacement"
          },
          {
            "code" : "45993005",
            "display" : "Cholecystectomy with exploration of common duct"
          },
          {
            "code" : "46116005",
            "display" : "Excision of malignant tumour of breast"
          },
          {
            "code" : "46681009",
            "display" : "Cerclage of cervix during pregnancy by abdominal approach"
          },
          {
            "code" : "46706006",
            "display" : "Replacement of intrauterine contraceptive device"
          },
          {
            "code" : "47020004",
            "display" : "Ventriculoperitoneal shunt"
          },
          {
            "code" : "47058000",
            "display" : "Heart transplant with recipient cardiectomy"
          },
          {
            "code" : "472917009",
            "display" : "Collection of device for submission as specimen"
          },
          {
            "code" : "47411002",
            "display" : "Implantation of penile prosthesis"
          },
          {
            "code" : "47432005",
            "display" : "Implantation of heart valve prosthesis or synthetic device"
          },
          {
            "code" : "47534009",
            "display" : "Decompression of median nerve"
          },
          {
            "code" : "4770005",
            "display" : "Colporrhaphy for repair of urethrocele"
          },
          {
            "code" : "48387007",
            "display" : "Incision of trachea"
          },
          {
            "code" : "48835001",
            "display" : "Esophagogastric fundoplasty"
          },
          {
            "code" : "49209004",
            "display" : "Subtotal gastrectomy"
          },
          {
            "code" : "49273004",
            "display" : "Laparoscopy with removal of adnexal structures"
          },
          {
            "code" : "49509003",
            "display" : "Operation on lymphatic structure"
          },
          {
            "code" : "49795001",
            "display" : "Total pneumonectomy"
          },
          {
            "code" : "50049003",
            "display" : "Urostomy management and care"
          },
          {
            "code" : "50172003",
            "display" : "Lumbar spinal fusion"
          },
          {
            "code" : "50216001",
            "display" : "Replacement of mitral valve with tissue graft"
          },
          {
            "code" : "50445001",
            "display" : "Mastoidectomy"
          },
          {
            "code" : "50465008",
            "display" : "Hernia repair"
          },
          {
            "code" : "50590007",
            "display" : "Trephine biopsy"
          },
          {
            "code" : "50676004",
            "display" : "Implantation of cochlear prosthetic device, multiple channels"
          },
          {
            "code" : "50807007",
            "display" : "Femoral-popliteal artery bypass graft with vein"
          },
          {
            "code" : "51241000",
            "display" : "Control of hemorrhage"
          },
          {
            "code" : "51302004",
            "display" : "Turbinectomy"
          },
          {
            "code" : "51683002",
            "display" : "Radial keratotomy"
          },
          {
            "code" : "52052004",
            "display" : "Rehabilitation therapy"
          },
          {
            "code" : "52247003",
            "display" : "Repair of aortic valve with tissue graft"
          },
          {
            "code" : "52660002",
            "display" : "Induced termination of pregnancy following intra-amniotic injection with hysterotomy"
          },
          {
            "code" : "52734007",
            "display" : "Total replacement of hip"
          },
          {
            "code" : "52852000",
            "display" : "Insertion of bilateral breast prostheses"
          },
          {
            "code" : "53059001",
            "display" : "Replacement of mitral valve"
          },
          {
            "code" : "53266006",
            "display" : "Operation on diaphragm"
          },
          {
            "code" : "53304009",
            "display" : "Parathyroidectomy"
          },
          {
            "code" : "53442002",
            "display" : "Gastrectomy"
          },
          {
            "code" : "53610001",
            "display" : "Nasal septoplasty with graft"
          },
          {
            "code" : "53958007",
            "display" : "Harvesting of donor material"
          },
          {
            "code" : "53976000",
            "display" : "Arthrodesis by anterior interbody technique of cervical region below C2 with bone graft"
          },
          {
            "code" : "54261007",
            "display" : "Excision of uterus and supporting structures"
          },
          {
            "code" : "5431005",
            "display" : "Percutaneous transluminal angioplasty"
          },
          {
            "code" : "54357003",
            "display" : "Partial excision of small intestine"
          },
          {
            "code" : "54535009",
            "display" : "Cone biopsy of cervix"
          },
          {
            "code" : "54621003",
            "display" : "Plastic repair with reduction"
          },
          {
            "code" : "54866009",
            "display" : "Initial implantation of cardiac single-chamber device"
          },
          {
            "code" : "54885007",
            "display" : "Extraction of cataract"
          },
          {
            "code" : "54956002",
            "display" : "Gastrostomy"
          },
          {
            "code" : "54974006",
            "display" : "Insertion of permanent pacemaker with transvenous electrodes, ventricular"
          },
          {
            "code" : "55162003",
            "display" : "Tooth extraction"
          },
          {
            "code" : "55244002",
            "display" : "Arthroscopically aided anterior cruciate ligament repair"
          },
          {
            "code" : "55253009",
            "display" : "Replacement of tricuspid valve with tissue graft"
          },
          {
            "code" : "55705006",
            "display" : "Spinal arthrodesis"
          },
          {
            "code" : "56060000",
            "display" : "Repair of musculotendinous cuff of shoulder"
          },
          {
            "code" : "56062008",
            "display" : "Repair of sliding inguinal hernia"
          },
          {
            "code" : "56283009",
            "display" : "Transplantation of small intestine"
          },
          {
            "code" : "56306000",
            "display" : "Cosmetic surgery"
          },
          {
            "code" : "56361007",
            "display" : "Excision of soft tissue"
          },
          {
            "code" : "56757003",
            "display" : "Scraping"
          },
          {
            "code" : "56783008",
            "display" : "Incision AND drainage"
          },
          {
            "code" : "57168000",
            "display" : "Operation on bone"
          },
          {
            "code" : "57217008",
            "display" : "Thompson operation, cleft lip repair"
          },
          {
            "code" : "57271003",
            "display" : "Extraperitoneal cesarean section"
          },
          {
            "code" : "57411006",
            "display" : "Colpoperineorrhaphy following delivery"
          },
          {
            "code" : "57470004",
            "display" : "Open reduction of fracture of femur with internal fixation"
          },
          {
            "code" : "5781000",
            "display" : "Operation on nasal septum"
          },
          {
            "code" : "58076004",
            "display" : "Refractive keratoplasty by laser surgery"
          },
          {
            "code" : "58390007",
            "display" : "Allogeneic bone marrow transplantation"
          },
          {
            "code" : "58776007",
            "display" : "Autologous bone marrow transplant"
          },
          {
            "code" : "58863009",
            "display" : "Initial implantation of cardiac dual-chamber device"
          },
          {
            "code" : "59213002",
            "display" : "Repair of ruptured supraspinatus tendon, acute"
          },
          {
            "code" : "59214008",
            "display" : "Reduction mammoplasty"
          },
          {
            "code" : "59300005",
            "display" : "Operation on spleen"
          },
          {
            "code" : "59657005",
            "display" : "Intestinal bypass for morbid obesity"
          },
          {
            "code" : "59703009",
            "display" : "Cervical arthrodesis by anterior technique"
          },
          {
            "code" : "59712006",
            "display" : "Evacuation of subdural haematoma"
          },
          {
            "code" : "60177007",
            "display" : "Mechanical vitrectomy"
          },
          {
            "code" : "6025007",
            "display" : "Laparoscopic appendicectomy"
          },
          {
            "code" : "60656008",
            "display" : "Corneal transplant"
          },
          {
            "code" : "60689008",
            "display" : "Home care of patient"
          },
          {
            "code" : "608785007",
            "display" : "Open reduction of fracture of radius and ulna with internal fixation"
          },
          {
            "code" : "609230000",
            "display" : "Laparoscopic bilateral salpingo-oophorectomy"
          },
          {
            "code" : "609588000",
            "display" : "Total knee replacement"
          },
          {
            "code" : "609637006",
            "display" : "Procedure on pelvic region of trunk"
          },
          {
            "code" : "609638001",
            "display" : "Operation on pelvic region of trunk"
          },
          {
            "code" : "6148000",
            "display" : "Chondrectomy of semilunar cartilage of knee"
          },
          {
            "code" : "61498008",
            "display" : "Complete external hemorrhoidectomy"
          },
          {
            "code" : "61557004",
            "display" : "Implantation of joint prosthesis"
          },
          {
            "code" : "61586001",
            "display" : "Delivery by vacuum extraction"
          },
          {
            "code" : "61661004",
            "display" : "Operative procedure on foot"
          },
          {
            "code" : "61774002",
            "display" : "Repair of rotator cuff by suture"
          },
          {
            "code" : "62141006",
            "display" : "Radical excision"
          },
          {
            "code" : "62317000",
            "display" : "Prosthodontic procedure"
          },
          {
            "code" : "6240004",
            "display" : "Operative procedure on knee"
          },
          {
            "code" : "62438007",
            "display" : "Transplantation of pancreas"
          },
          {
            "code" : "62881002",
            "display" : "Removal of cardiac pacemaker"
          },
          {
            "code" : "62972009",
            "display" : "Extraction"
          },
          {
            "code" : "63016009",
            "display" : "Complete cystectomy"
          },
          {
            "code" : "63697000",
            "display" : "Cardiopulmonary bypass operation"
          },
          {
            "code" : "64253000",
            "display" : "Implantation of heart assist system"
          },
          {
            "code" : "64368001",
            "display" : "Partial mastectomy"
          },
          {
            "code" : "64597002",
            "display" : "Destructive procedure"
          },
          {
            "code" : "64915003",
            "display" : "Operation on heart"
          },
          {
            "code" : "64978007",
            "display" : "Radionuclide therapy for hyperthyroidism"
          },
          {
            "code" : "65200003",
            "display" : "Insertion of intrauterine contraceptive device"
          },
          {
            "code" : "65551008",
            "display" : "Radical retropubic prostatectomy"
          },
          {
            "code" : "65659003",
            "display" : "Rotational atherectomy"
          },
          {
            "code" : "65801008",
            "display" : "Excision"
          },
          {
            "code" : "65854006",
            "display" : "Reexcision"
          },
          {
            "code" : "66692001",
            "display" : "Repair of ruptured supraspinatus tendon, chronic"
          },
          {
            "code" : "66951008",
            "display" : "Carotid endarterectomy"
          },
          {
            "code" : "67557008",
            "display" : "Laparoscopic cholecystectomy with exploration of common duct"
          },
          {
            "code" : "67629009",
            "display" : "Catheterisation of left heart"
          },
          {
            "code" : "68254000",
            "display" : "Removal of intrauterine device"
          },
          {
            "code" : "68265005",
            "display" : "Operation on the ear"
          },
          {
            "code" : "6832004",
            "display" : "Atherectomy"
          },
          {
            "code" : "68432004",
            "display" : "Open reduction of fracture of carpals and metacarpals with internal fixation"
          },
          {
            "code" : "68457009",
            "display" : "Percutaneous transluminal balloon angioplasty"
          },
          {
            "code" : "6853008",
            "display" : "Nasogastric tube aspiration"
          },
          {
            "code" : "68660007",
            "display" : "Punch biopsy"
          },
          {
            "code" : "68667005",
            "display" : "Insertion of permanent transvenous electrodes"
          },
          {
            "code" : "68792000",
            "display" : "Wardill operation, cleft palate repair"
          },
          {
            "code" : "69130005",
            "display" : "Stapedectomy"
          },
          {
            "code" : "69380006",
            "display" : "Venous catheterization for renal dialysis"
          },
          {
            "code" : "69483009",
            "display" : "Shunt of cerebral ventricle to extracranial site"
          },
          {
            "code" : "69724002",
            "display" : "Implantation of prosthetic intraocular lens"
          },
          {
            "code" : "6976007",
            "display" : "Craniocervical spinal fusion"
          },
          {
            "code" : "697984004",
            "display" : "Exteriorization of trachea"
          },
          {
            "code" : "700000006",
            "display" : "Vaginal delivery of fetus"
          },
          {
            "code" : "70183006",
            "display" : "Subcutaneous mastectomy"
          },
          {
            "code" : "703142009",
            "display" : "Prescription of contraception"
          },
          {
            "code" : "703145006",
            "display" : "Sterilization procedure"
          },
          {
            "code" : "70536003",
            "display" : "Transplant of kidney"
          },
          {
            "code" : "70586009",
            "display" : "Operation on brain"
          },
          {
            "code" : "70777001",
            "display" : "Urine specimen collection, catheterized"
          },
          {
            "code" : "708614008",
            "display" : "Laparoscopic lysis of adhesion of peritoneum"
          },
          {
            "code" : "708651002",
            "display" : "Partial excision of vertebra"
          },
          {
            "code" : "70871006",
            "display" : "Incisional biopsy"
          },
          {
            "code" : "708983005",
            "display" : "Laparoscopic bypass of stomach"
          },
          {
            "code" : "709013008",
            "display" : "Removal of implant device from bone"
          },
          {
            "code" : "710785000",
            "display" : "Laparoscopic repair of hernia"
          },
          {
            "code" : "710955000",
            "display" : "Biomedical equipment procedure"
          },
          {
            "code" : "71192002",
            "display" : "Peritoneal dialysis"
          },
          {
            "code" : "713541000",
            "display" : "Removal of entire genital organ"
          },
          {
            "code" : "718348005",
            "display" : "Cardiovascular care"
          },
          {
            "code" : "72010008",
            "display" : "Removal of internal fixation device"
          },
          {
            "code" : "72310004",
            "display" : "Circumcision"
          },
          {
            "code" : "72342005",
            "display" : "Shave biopsy"
          },
          {
            "code" : "726429001",
            "display" : "Radical mastectomy of left breast"
          },
          {
            "code" : "726430006",
            "display" : "Radical mastectomy of right breast"
          },
          {
            "code" : "726436000",
            "display" : "Modified radical mastectomy of right breast"
          },
          {
            "code" : "726437009",
            "display" : "Modified radical mastectomy of left breast"
          },
          {
            "code" : "72791001",
            "display" : "Laryngectomy"
          },
          {
            "code" : "73416001",
            "display" : "Urine specimen collection, clean catch"
          },
          {
            "code" : "735023007",
            "display" : "Fixation of left testis"
          },
          {
            "code" : "735024001",
            "display" : "Fixation of right testis"
          },
          {
            "code" : "73536002",
            "display" : "Myotomy of colon"
          },
          {
            "code" : "73544002",
            "display" : "Operation on heart valve"
          },
          {
            "code" : "73632009",
            "display" : "Laparoscopy"
          },
          {
            "code" : "737067005",
            "display" : "Repair of ventral hernia using graft"
          },
          {
            "code" : "73759005",
            "display" : "Duodenectomy"
          },
          {
            "code" : "73761001",
            "display" : "Colonoscopy"
          },
          {
            "code" : "74011006",
            "display" : "Open reduction of fracture of tibia and fibula with internal fixation"
          },
          {
            "code" : "74406002",
            "display" : "Open heart valvuloplasty of mitral valve without replacement"
          },
          {
            "code" : "746051007",
            "display" : "Endovascular insertion of drug coated stent"
          },
          {
            "code" : "7476006",
            "display" : "Special care of dentures"
          },
          {
            "code" : "74770008",
            "display" : "Exploratory laparotomy"
          },
          {
            "code" : "74943008",
            "display" : "Operation on trunk"
          },
          {
            "code" : "75170007",
            "display" : "Extraction of lens of eye"
          },
          {
            "code" : "75176001",
            "display" : "Tympanectomy"
          },
          {
            "code" : "75506009",
            "display" : "Construction of stoma"
          },
          {
            "code" : "75732000",
            "display" : "Vitrectomy"
          },
          {
            "code" : "75835007",
            "display" : "Laparoscopic-assisted vaginal hysterectomy"
          },
          {
            "code" : "76009000",
            "display" : "Esophagogastroduodenoscopy"
          },
          {
            "code" : "76025005",
            "display" : "Correction of ventricular septal defect"
          },
          {
            "code" : "76334006",
            "display" : "Immunological therapy"
          },
          {
            "code" : "76611008",
            "display" : "Atherectomy by laser"
          },
          {
            "code" : "76810006",
            "display" : "Diagnostic dilation and curettage of uterus"
          },
          {
            "code" : "76876009",
            "display" : "Bilateral oophorectomy"
          },
          {
            "code" : "76956004",
            "display" : "Amputation of finger, except thumb"
          },
          {
            "code" : "771329004",
            "display" : "Procedure on body region"
          },
          {
            "code" : "771453009",
            "display" : "Repair of abdominal aortic aneurysm with insertion of stent"
          },
          {
            "code" : "771626001",
            "display" : "Open repair of femoral hernia using sutures"
          },
          {
            "code" : "77166000",
            "display" : "Percutaneous balloon valvuloplasty of aortic valve"
          },
          {
            "code" : "771663005",
            "display" : "Open repair of umbilical hernia using sutures"
          },
          {
            "code" : "771713005",
            "display" : "Open repair of inguinal hernia using sutures"
          },
          {
            "code" : "771719009",
            "display" : "Open repair of epigastric hernia using sutures"
          },
          {
            "code" : "77181006",
            "display" : "Implantation of mitral valve prosthesis or synthetic device"
          },
          {
            "code" : "773261007",
            "display" : "Procedure related to reproduction"
          },
          {
            "code" : "77343006",
            "display" : "Angiography"
          },
          {
            "code" : "77465005",
            "display" : "Transplantation"
          },
          {
            "code" : "77543007",
            "display" : "Ligation of fallopian tube"
          },
          {
            "code" : "781087000",
            "display" : "Medical care"
          },
          {
            "code" : "782901001",
            "display" : "Insertion procedure"
          },
          {
            "code" : "782902008",
            "display" : "Implantation procedure"
          },
          {
            "code" : "782971002",
            "display" : "Bronchoalveolar lavage"
          },
          {
            "code" : "78418002",
            "display" : "Operation on heart and pericardium"
          },
          {
            "code" : "78559005",
            "display" : "Operative procedure on shoulder"
          },
          {
            "code" : "78817002",
            "display" : "Construction of anastomosis"
          },
          {
            "code" : "788180009",
            "display" : "Lower uterine segment cesarean section"
          },
          {
            "code" : "7908000",
            "display" : "Operation on ileum"
          },
          {
            "code" : "79095000",
            "display" : "Complete excision"
          },
          {
            "code" : "79121003",
            "display" : "Biopsy of stomach"
          },
          {
            "code" : "79537002",
            "display" : "Operation on endocrine system"
          },
          {
            "code" : "79544006",
            "display" : "Complete axillary lymphadenectomy"
          },
          {
            "code" : "79733001",
            "display" : "Amputation above-knee"
          },
          {
            "code" : "79876008",
            "display" : "Operation on uterus"
          },
          {
            "code" : "79917009",
            "display" : "Implantation of pulmonary valve prosthesis or synthetic device"
          },
          {
            "code" : "80146002",
            "display" : "Appendicectomy"
          },
          {
            "code" : "80402001",
            "display" : "Insertion of implantable venous access port"
          },
          {
            "code" : "8069005",
            "display" : "Implantation of tricuspid valve prosthesis or synthetic device"
          },
          {
            "code" : "80779005",
            "display" : "Repair of brain"
          },
          {
            "code" : "81099000",
            "display" : "Cervical arthrodesis"
          },
          {
            "code" : "81516001",
            "display" : "Partial nephrectomy"
          },
          {
            "code" : "81723002",
            "display" : "Amputation"
          },
          {
            "code" : "8180007",
            "display" : "Fiberoptic colonoscopy through colostomy"
          },
          {
            "code" : "81870009",
            "display" : "Parotidectomy"
          },
          {
            "code" : "82035006",
            "display" : "Resection of polyp"
          },
          {
            "code" : "82078001",
            "display" : "Collection of blood specimen for laboratory"
          },
          {
            "code" : "83152002",
            "display" : "Oophorectomy"
          },
          {
            "code" : "83333004",
            "display" : "Creation of cardiac pacemaker pocket new site in subcutaneous tissue"
          },
          {
            "code" : "8378006",
            "display" : "Trimming"
          },
          {
            "code" : "84088001",
            "display" : "Correction of atresia of external meatus of ear"
          },
          {
            "code" : "84100007",
            "display" : "History taking"
          },
          {
            "code" : "84149000",
            "display" : "Aspiration of cataract by phacoemulsification"
          },
          {
            "code" : "84195007",
            "display" : "Classical cesarean section"
          },
          {
            "code" : "8422009",
            "display" : "Destruction of hemorrhoids by sclerotherapy"
          },
          {
            "code" : "84267003",
            "display" : "Hysterotomy with removal of foreign body"
          },
          {
            "code" : "84275009",
            "display" : "Obstetrical hysterotomy"
          },
          {
            "code" : "84282008",
            "display" : "Hemorrhoidectomy by simple ligature"
          },
          {
            "code" : "84877006",
            "display" : "Arthroscopy of knee with meniscus repair"
          },
          {
            "code" : "85419002",
            "display" : "Orchidopexy"
          },
          {
            "code" : "85548006",
            "display" : "Episiotomy"
          },
          {
            "code" : "85921004",
            "display" : "Puncture procedure"
          },
          {
            "code" : "86088003",
            "display" : "Centesis"
          },
          {
            "code" : "860930005",
            "display" : "Surgery of cataract of left eye"
          },
          {
            "code" : "860934001",
            "display" : "Surgery of cataract of right eye"
          },
          {
            "code" : "8616005",
            "display" : "Rhinocheiloplasty repair for cleft lip"
          },
          {
            "code" : "86259008",
            "display" : "Biopsy of liver"
          },
          {
            "code" : "86273004",
            "display" : "Biopsy"
          },
          {
            "code" : "86477000",
            "display" : "Total hysterectomy with removal of both tubes and ovaries"
          },
          {
            "code" : "86480004",
            "display" : "Open reduction of fracture"
          },
          {
            "code" : "86481000",
            "display" : "Laparotomy"
          },
          {
            "code" : "86553008",
            "display" : "Immunosuppressive therapy"
          },
          {
            "code" : "86743009",
            "display" : "Local excision"
          },
          {
            "code" : "86749008",
            "display" : "Stripping and ligation"
          },
          {
            "code" : "86800006",
            "display" : "Operation on trachea"
          },
          {
            "code" : "87021001",
            "display" : "Mechanical vitrectomy by pars plana approach"
          },
          {
            "code" : "87366001",
            "display" : "Total elbow replacement"
          },
          {
            "code" : "87591000",
            "display" : "Curettage of skin lesion"
          },
          {
            "code" : "87795007",
            "display" : "Complete transurethral resection of prostate, including control of postoperative bleeding"
          },
          {
            "code" : "8782006",
            "display" : "Radical perineal prostatectomy"
          },
          {
            "code" : "87825006",
            "display" : "Initial implantation of electrode into cardiac atrium and ventricle"
          },
          {
            "code" : "88039007",
            "display" : "Transplant of lung"
          },
          {
            "code" : "88088007",
            "display" : "Radical excision with lymph node dissection"
          },
          {
            "code" : "88312006",
            "display" : "Amputation of leg through tibia and fibula"
          },
          {
            "code" : "88722002",
            "display" : "Initial implantation of electrode into cardiac atrium"
          },
          {
            "code" : "8874001",
            "display" : "Arthroscopy of knee with medial and lateral meniscectomy"
          },
          {
            "code" : "8889005",
            "display" : "Excisional biopsy"
          },
          {
            "code" : "88937006",
            "display" : "Prosthetic procedure"
          },
          {
            "code" : "89053004",
            "display" : "Vaginal cesarean section"
          },
          {
            "code" : "8920006",
            "display" : "Repair of retina for retinal detachment"
          },
          {
            "code" : "89355001",
            "display" : "Discectomy for intervertebral herniated disc, nucleus pulposus"
          },
          {
            "code" : "89432003",
            "display" : "Lemesurier operation, cleft lip repair"
          },
          {
            "code" : "89522007",
            "display" : "Colocolostomy"
          },
          {
            "code" : "89540006",
            "display" : "Segmental excision and ligation"
          },
          {
            "code" : "89814007",
            "display" : "Repair of ventricular septal defect with prosthesis"
          },
          {
            "code" : "89901005",
            "display" : "Operative procedure on head"
          },
          {
            "code" : "90199006",
            "display" : "Transurethral prostatectomy"
          },
          {
            "code" : "90442009",
            "display" : "Cerclage of cervix during pregnancy by vaginal approach"
          },
          {
            "code" : "90470006",
            "display" : "Prostatectomy"
          },
          {
            "code" : "91251008",
            "display" : "Physical therapy procedure"
          },
          {
            "code" : "91602002",
            "display" : "Thoracentesis"
          },
          {
            "code" : "9888007",
            "display" : "Excision of intracranial lesion"
          }
        ]
      }
    ]
  }
}

```
