# Problems - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problems**

## ValueSet: Problems 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSICodeProb | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSICodeProb |

 
The Value Set is used as an optional description of a problem in the patient Summary. It gives an information on the circumstances under which the problem was defined/discovered. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 7 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSICodeProb",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSICodeProb",
  "version" : "0.1.0",
  "name" : "EHDSICodeProb",
  "title" : "Problems",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "The Value Set is used as an optional description of a problem in the patient Summary. It gives an information on the circumstances under which the problem was defined/discovered.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "404684003",
            "display" : "Clinical finding"
          },
          {
            "code" : "409586006",
            "display" : "Complaint"
          },
          {
            "code" : "282291009",
            "display" : "Diagnosis interpretation"
          },
          {
            "code" : "64572001",
            "display" : "Disease"
          },
          {
            "code" : "248536006",
            "display" : "Finding of functional performance and activity"
          },
          {
            "code" : "418799008",
            "display" : "Finding reported by subject or history provider"
          },
          {
            "code" : "55607006",
            "display" : "Problem"
          }
        ]
      }
    ]
  }
}

```
