# Absent or Unknown Device - XpanDH Project v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Absent or Unknown Device**

## ValueSet: Absent or Unknown Device 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIAbsentOrUnknownDevice | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:EHDSIAbsentOrUnknownDevice |

 
Absent or Unknown Device 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eHDSIAbsentOrUnknownDevice",
  "url" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIAbsentOrUnknownDevice",
  "version" : "0.1.0",
  "name" : "EHDSIAbsentOrUnknownDevice",
  "title" : "Absent or Unknown Device",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T15:56:25+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Absent or Unknown Device",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips",
        "concept" : [
          {
            "code" : "no-device-info",
            "display" : "No information about device"
          },
          {
            "code" : "no-known-devices",
            "display" : "No known devices in use"
          }
        ]
      }
    ]
  }
}

```
