# Artifacts Summary - XpanDH Project Medication (e)Prescription and (e)Dispensation v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Prescription](StructureDefinition-Prescription.md) | Prescription. Several Sections of the eHN guideline. |
| [A.1.1 Patient administrative data](StructureDefinition-Subject.md) | Patient. Sections A1.1 of the eHN guideline. |
| [A1.4 Identification of the prescribed product](StructureDefinition-MedicinalProduct.md) | Identification of the prescribed product. Section A1.4 of the eHN guideline |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Medication: XpanDH](StructureDefinition-Medication-ep-eu-xpandh.md) | This profile defines how to represent MedicationRequest in FHIR for the purpose of the XpanDH project eP/eD POC. |
| [MedicationDispense: XpanDH](StructureDefinition-MedicationDispense-eu-xpandh.md) | This profile defines how to represent the supply and the associated administration instructions in HL7 FHIR for the purpose of this guide. |
| [MedicationRequest: XpanDH](StructureDefinition-MedicationRequest-eu-xpandh.md) | This profile defines how to represent MedicationRequest in FHIR for the purpose of the XpanDH project. |
| [Patient: XpanDH](StructureDefinition-Patient-eu-xpandh.md) | This profile defines how to represent Patient in FHIR for the purpose of the XpanDH project. |
| [Practitioner](StructureDefinition-Practitioner-eu-xpandh.md) | This profile defines how to represent Practitioners in FHIR for the purpose of the XpanDH project. |
| [PractitionerRole](StructureDefinition-PractitionerRole-eu-xpandh.md) | This profile defines how to represent Practitioners (with thier roles) in FHIR for the purpose of the XpanDH project. |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [eHN Medicinal Product to this guide Map](ConceptMap-medProd2FHIR-eu-xpandh.md) | eHN Medicinal Product Model to this guide Map |
| [eHN Subject to this guide Map](ConceptMap-eP2FHIR-eu-xpandh.md) | eHN ePrescription Model to this guide Map |

