# PractitionerRole - XpanDH Project Medication (e)Prescription and (e)Dispensation v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole**

## Resource Profile: PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/PractitionerRole-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:PractitionerRoleEpXpandh |

 
This profile defines how to represent Practitioners (with thier roles) in FHIR for the purpose of the XpanDH project. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.mpd|current/StructureDefinition/PractitionerRole-eu-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PractitionerRole-eu-xpandh.csv), [Excel](StructureDefinition-PractitionerRole-eu-xpandh.xlsx), [Schematron](StructureDefinition-PractitionerRole-eu-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PractitionerRole-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/PractitionerRole-eu-xpandh",
  "version" : "0.1.0",
  "name" : "PractitionerRoleEpXpandh",
  "title" : "PractitionerRole",
  "status" : "draft",
  "date" : "2025-10-10T16:31:37+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Practitioners (with thier roles) in FHIR for the purpose of the XpanDH project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/PractitionerRole-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "short" : "PractitionerRole identifier"
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Practitioner-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "PractitionerRole's organization"
      }
    ]
  }
}

```
