# Medication: XpanDH - XpanDH Project Medication (e)Prescription and (e)Dispensation v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication: XpanDH**

## Resource Profile: Medication: XpanDH 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Medication-ep-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:MedicationEpXpandh |

 
This profile defines how to represent MedicationRequest in FHIR for the purpose of the XpanDH project eP/eD POC. 

 
This profile constrains the Medication resource for the purpose of the eP/eD proof of concept. 

**Usages:**

* Refer to this Profile: [Medication: XpanDH](StructureDefinition-Medication-ep-eu-xpandh.md), [MedicationDispense: XpanDH](StructureDefinition-MedicationDispense-eu-xpandh.md) and [MedicationRequest: XpanDH](StructureDefinition-MedicationRequest-eu-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.mpd|current/StructureDefinition/Medication-ep-eu-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Medication-ep-eu-xpandh.csv), [Excel](StructureDefinition-Medication-ep-eu-xpandh.xlsx), [Schematron](StructureDefinition-Medication-ep-eu-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Medication-ep-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Medication-ep-eu-xpandh",
  "version" : "0.1.0",
  "name" : "MedicationEpXpandh",
  "title" : "Medication: XpanDH",
  "status" : "draft",
  "date" : "2025-10-10T16:31:37+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent MedicationRequest in FHIR for the purpose of the XpanDH project eP/eD POC.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Medication resource for the purpose of the eP/eD proof of concept.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.contained",
        "path" : "Medication.contained",
        "type" : [
          {
            "code" : "MedicationKnowledge"
          }
        ]
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.extension:MedicationDefinitionR5",
        "path" : "Medication.extension",
        "sliceName" : "MedicationDefinitionR5",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Medication.definition"
            ]
          }
        ]
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "short" : "Any kind of product code (including ATC)",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIActiveIngredient"
        }
      },
      {
        "id" : "Medication.form",
        "path" : "Medication.form",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSIDoseForm"
        }
      },
      {
        "id" : "Medication.ingredient.item[x]",
        "path" : "Medication.ingredient.item[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.ingredient.item[x]:itemCodeableConcept",
        "path" : "Medication.ingredient.item[x]",
        "sliceName" : "itemCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/ValueSet/eHDSISubstance"
        }
      },
      {
        "id" : "Medication.ingredient.item[x]:itemReference",
        "path" : "Medication.ingredient.item[x]",
        "sliceName" : "itemReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Medication-ep-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Medication.ingredient.isActive",
        "path" : "Medication.ingredient.isActive",
        "short" : "Usually true"
      },
      {
        "id" : "Medication.ingredient.strength",
        "path" : "Medication.ingredient.strength",
        "short" : "A kind of strength",
        "definition" : "A kind of strength.\n  Definitional resources should be used for specifying the different types of strengths: presentation; concentration;.."
      }
    ]
  }
}

```
