# MedicationDispense: XpanDH - XpanDH Project Medication (e)Prescription and (e)Dispensation v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationDispense: XpanDH**

## Resource Profile: MedicationDispense: XpanDH 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/MedicationDispense-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:MedicationDispenseXpandh |

 
This profile defines how to represent the supply and the associated administration instructions in HL7 FHIR for the purpose of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.mpd|current/StructureDefinition/MedicationDispense-eu-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationDispense-eu-xpandh.csv), [Excel](StructureDefinition-MedicationDispense-eu-xpandh.xlsx), [Schematron](StructureDefinition-MedicationDispense-eu-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationDispense-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/MedicationDispense-eu-xpandh",
  "version" : "0.1.0",
  "name" : "MedicationDispenseXpandh",
  "title" : "MedicationDispense: XpanDH",
  "status" : "draft",
  "date" : "2025-10-10T16:31:37+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent the supply and the associated administration instructions in HL7 FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense"
      },
      {
        "id" : "MedicationDispense.identifier",
        "path" : "MedicationDispense.identifier",
        "short" : "Identifier for this dispensation"
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "path" : "MedicationDispense.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationReference",
        "path" : "MedicationDispense.medication[x]",
        "sliceName" : "medicationReference",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Medication-ep-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.performer",
        "path" : "MedicationDispense.performer",
        "short" : "Who performed the dispensation."
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "path" : "MedicationDispense.authorizingPrescription",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/MedicationRequest-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.quantity",
        "path" : "MedicationDispense.quantity",
        "short" : "Amount dispensed."
      },
      {
        "id" : "MedicationDispense.substitution",
        "path" : "MedicationDispense.substitution",
        "short" : "Details about substitution"
      }
    ]
  }
}

```
