# eHN Medicinal Product to this guide Map - XpanDH Project Medication (e)Prescription and (e)Dispensation v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Medicinal Product to this guide Map**

## ConceptMap: eHN Medicinal Product to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh-mpd/ConceptMap/medProd2FHIR-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:MedProd2Fhir |

 
eHN Medicinal Product Model to this guide Map 

 
It shows how the Medicinal Product data set defined by the EU eHN guidelines is mapped into this guide 

Mapping from [A - Prescription](StructureDefinition-Prescription.md) to http://hl7.eu/fhir/ig/xpandh-mpd//StructureDefinition/Medication-eu-xpandh

**Group 1**Mapping from [A - Prescription](StructureDefinition-Prescription.md) to `http://hl7.eu/fhir/ig/xpandh-mpd//StructureDefinition/Medication-eu-xpandh`

* **Source Code**: MedicinalProduct.name (A.1.4.1 Name of the medicinal product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.code.text
  * **Comment**: to be checked
* **Source Code**: MedicinalProduct.mpid (A.1.4.2 Identifier of the medicinal product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.code.coding
  * **Comment**: How it is implemented now in the IPS. TBD
* **Source Code**: MedicinalProduct.phpid (A.1.4.2.1 Identifier(s) of the pharmaceutical product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.code.coding
  * **Comment**: How it is implemented now in the IPS. TBD
* **Source Code**: MedicinalProduct.pcid (A.1.4.2.2 Identifier(s) of the packaged medicinal product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.code.coding
  * **Comment**: How it is implemented now in the IPS. TBD
* **Source Code**: MedicinalProduct.marketingAuthHolder (A.1.4.3 Marketing authorisation holder)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.manufacturer
  * **Comment**: 
* **Source Code**: MedicinalProduct.activeSubstance (A.1.4.4 Active substance(s))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.ingredient
  * **Comment**: where isActitve = 'true'
* **Source Code**: MedicinalProduct.strength (A.1.4.4.1 Strength of the active substance(s))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.ingredient.strength
  * **Comment**: only one kind of strength is provided. Clarify how to provide ingredient and strength as text
* **Source Code**: MedicinalProduct.classification (A.1.4.5 Product classification )
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.extension(definition).ValueReference
  * **Comment**: MedicationKnowledge.medicineClassification.classification. Type to be defined
* **Source Code**: MedicinalProduct.classification (A.1.4.5 Product classification )
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.code.coding
  * **Comment**: How it is implemented now in the IPS
* **Source Code**: MedicinalProduct.doseForm (A.1.4.6 Pharmaceutical dose form(s))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.form
  * **Comment**: 
* **Source Code**: MedicinalProduct.unitOfPresentation (A.1.4.7 Unit of presentation(s))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.ingredient.strength.denominator.code
  * **Comment**: if it is the presentation strength
* **Source Code**: MedicinalProduct.packageType (A.1.4.8 Package type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.contained.packaging.type
  * **Comment**: if contained
* **Source Code**: MedicinalProduct.PackageSize (A.1.4.9 Pack size)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.contained.packaging.quantity
  * **Comment**: if contained
* **Source Code**: MedicinalProduct.packageType (A.1.4.8 Package type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.extension(definition).ValueReference
  * **Comment**: MedicationKnowledge.packaging.type
* **Source Code**: MedicinalProduct.PackageSize (A.1.4.9 Pack size)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Medication.extension(definition).ValueReference
  * **Comment**: MedicationKnowledge.packaging.quantity



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "medProd2FHIR-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh-mpd/ConceptMap/medProd2FHIR-eu-xpandh",
  "version" : "0.1.0",
  "name" : "MedProd2Fhir",
  "title" : "eHN Medicinal Product to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:31:37+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "eHN Medicinal Product Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Medicinal Product data set defined by the EU eHN guidelines is mapped into this guide",
  "sourceUri" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Prescription",
  "targetUri" : "http://hl7.eu/fhir/ig/xpandh-mpd//StructureDefinition/Medication-eu-xpandh",
  "group" : [
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Prescription",
      "target" : "http://hl7.eu/fhir/ig/xpandh-mpd//StructureDefinition/Medication-eu-xpandh",
      "element" : [
        {
          "code" : "MedicinalProduct.name",
          "display" : "A.1.4.1 Name of the medicinal product",
          "target" : [
            {
              "code" : "Medication.code.text",
              "equivalence" : "relatedto",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.mpid",
          "display" : "A.1.4.2 Identifier of the medicinal product",
          "target" : [
            {
              "code" : "Medication.code.coding",
              "equivalence" : "relatedto",
              "comment" : "How it is implemented now in the IPS. TBD"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.phpid",
          "display" : "A.1.4.2.1 Identifier(s) of the pharmaceutical product",
          "target" : [
            {
              "code" : "Medication.code.coding",
              "equivalence" : "relatedto",
              "comment" : "How it is implemented now in the IPS. TBD"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.pcid",
          "display" : "A.1.4.2.2 Identifier(s) of the packaged medicinal product",
          "target" : [
            {
              "code" : "Medication.code.coding",
              "equivalence" : "relatedto",
              "comment" : "How it is implemented now in the IPS. TBD"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.marketingAuthHolder",
          "display" : "A.1.4.3 Marketing authorisation holder",
          "target" : [
            {
              "code" : "Medication.manufacturer",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.activeSubstance",
          "display" : "A.1.4.4 Active substance(s)",
          "target" : [
            {
              "code" : "Medication.ingredient",
              "equivalence" : "equivalent",
              "comment" : "where isActitve = 'true'"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.strength",
          "display" : "A.1.4.4.1 Strength of the active substance(s)",
          "target" : [
            {
              "code" : "Medication.ingredient.strength",
              "equivalence" : "relatedto",
              "comment" : "only one kind of strength is provided.\nClarify how to provide ingredient and strength as text"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.classification",
          "display" : "A.1.4.5 Product classification ",
          "target" : [
            {
              "code" : "Medication.extension(definition).ValueReference",
              "equivalence" : "relatedto",
              "comment" : "MedicationKnowledge.medicineClassification.classification.\nType to be defined"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.classification",
          "display" : "A.1.4.5 Product classification ",
          "target" : [
            {
              "code" : "Medication.code.coding",
              "equivalence" : "equivalent",
              "comment" : "How it is implemented now in the IPS"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.doseForm",
          "display" : "A.1.4.6 Pharmaceutical dose form(s)",
          "target" : [
            {
              "code" : "Medication.form",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.unitOfPresentation",
          "display" : "A.1.4.7 Unit of presentation(s)",
          "target" : [
            {
              "code" : "Medication.ingredient.strength.denominator.code",
              "equivalence" : "equivalent",
              "comment" : "if it is the presentation strength"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.packageType",
          "display" : "A.1.4.8 Package type",
          "target" : [
            {
              "code" : "Medication.contained.packaging.type",
              "equivalence" : "relatedto",
              "comment" : "if contained"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.PackageSize",
          "display" : "A.1.4.9 Pack size",
          "target" : [
            {
              "code" : "Medication.contained.packaging.quantity",
              "equivalence" : "relatedto",
              "comment" : "if contained"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.packageType",
          "display" : "A.1.4.8 Package type",
          "target" : [
            {
              "code" : "Medication.extension(definition).ValueReference",
              "equivalence" : "relatedto",
              "comment" : "MedicationKnowledge.packaging.type"
            }
          ]
        },
        {
          "code" : "MedicinalProduct.PackageSize",
          "display" : "A.1.4.9 Pack size",
          "target" : [
            {
              "code" : "Medication.extension(definition).ValueReference",
              "equivalence" : "relatedto",
              "comment" : "MedicationKnowledge.packaging.quantity"
            }
          ]
        }
      ]
    }
  ]
}

```
