# eHN Subject to this guide Map - XpanDH Project Medication (e)Prescription and (e)Dispensation v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Subject to this guide Map**

## ConceptMap: eHN Subject to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh-mpd/ConceptMap/eP2FHIR-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:eP2Fhir |

 
eHN ePrescription Model to this guide Map 

 
It shows how the ePrescription data set defined by the EU eHN guidelines is mapped into this guide 

Mapping from [A - Prescription](StructureDefinition-Prescription.md) to [MedicationRequest: XpanDH](StructureDefinition-MedicationRequest-eu-xpandh.md)

**Group 1**Mapping from [A - Prescription](StructureDefinition-Prescription.md) to [MedicationRequest: XpanDH](StructureDefinition-MedicationRequest-eu-xpandh.md)

* **Source Code**: Prescription.patient (A.1.1 Patient administrative data)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.subject
  * **Comment**: 
* **Source Code**: Prescription.authentication (A.1.2 Authentication of the prescription)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest
  * **Comment**: 
* **Source Code**: Prescription.authentication.identifier (A.1.2.1 Identifier of the Prescription)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.identifier
  * **Comment**: if a prescription includes only one prescribed item
* **Source Code**: Prescription.authentication.identifier (A.1.2.1 Identifier of the Prescription)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.groupIdentifier
  * **Comment**: if a prescription includes more then one prescribed item
* **Source Code**: Prescription.authentication.date (A.1.2.2 Issue date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.authoredOn
  * **Comment**: 
* **Source Code**: Prescription.prescriber (A.1.3 Identification of the prescribing health professional)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: 
* **Source Code**: Prescription.prescriber.familyName (A.1.3.1 Familyname)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Details in the referred Practictioner resource
* **Source Code**: Prescription.prescriber.givenName (A.1.3.2 Given name)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Details in the referred Practictioner resource
* **Source Code**: Prescription.prescriber.qualification (A.1.3.3 Professional qualifications)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Details in the referred Practictioner resource
* **Source Code**: Prescription.prescriber.contact (A.1.3.4 Details for direct contact)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Details in the referred Practictioner resource
* **Source Code**: Prescription.prescriber.workAddress (A.1.3.5 Work address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Details in the referred Practictioner resource
* **Source Code**: Prescription.prescriber.signature (A.1.3.6 Signature)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Not implemented in the current eP / eD service
* **Source Code**: Prescription.prescriber.identifier (A.1.3.7 Health care provider identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.requester
  * **Comment**: Details in the referred Practictioner resource
* **Source Code**: Prescription.product (A1.4 Identification of the prescribed product)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.medicationReference
  * **Comment**: 
* **Source Code**: Prescription.details (A.1.5 Prescription information)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest
  * **Comment**: 
* **Source Code**: Prescription.details.quantity (A.1.5.2 Quantity of prescribed product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.dispenseRequest.quantity
  * **Comment**: 
* **Source Code**: Prescription.details.doseRegimen (A.1.5.3 Dose regimen)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.dosageInstruction
  * **Comment**: 
* **Source Code**: Prescription.details.doseRegimen.numOfIntakes (A.1.5.3.1 Number of units per intake)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.dosageInstruction.doseAndRate.doseQuantity
  * **Comment**: 
* **Source Code**: Prescription.details.doseRegimen.frequencyOfIntakes (A.1.5.3.2 Frequency of intakes)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.dosageInstruction.timing
  * **Comment**: A combination of frequency, period and periodUnit. '3 times per day', 3 would be the frequency and '1 day' would be the period/periodUnit.
* **Source Code**: Prescription.details.route (A.1.5.4 Route of administration)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.dosageInstruction.route
  * **Comment**: 
* **Source Code**: Prescription.details.duration (A.1.5.5 Duration of treatment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.dosageInstruction.timing.repeat.duration
  * **Comment**: 
* **Source Code**: Prescription.details.startDate (A.1.5.6 Starting date of therapy )
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.dosageInstruction.timing.duration
  * **Comment**: 
* **Source Code**: Prescription.details.directionsOfUse (A.1.5.7 Directions for use)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.dosageInstruction
  * **Comment**: 
* **Source Code**: Prescription.details.expiryDate (A.1.5.8 Prescription expiry date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.dispenseRequest.validityPeriod
  * **Comment**: 
* **Source Code**: Prescription.details.repeats (A.1.5.9 Repeats)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest
  * **Comment**: TO BE DISCUSSED
* **Source Code**: Prescription.details.reason (A.1.5.10 Reason for prescription)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationRequest.reasonReference
  * **Comment**: 
* **Source Code**: Prescription.details.reason (A.1.5.10 Reason for prescription)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.reasonCode
  * **Comment**: 
* **Source Code**: Prescription.details.substitution (A.1.5.11 Substitution)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.substitution.allowedCodeableConcept
  * **Comment**: 

-------

**Group 2**Mapping from [A - Prescription](StructureDefinition-Prescription.md) to `http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Practictioner-eu-xpandh`

* **Source Code**: Prescription.prescriber.familyName (A.1.3.1 Familyname)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.name.given
  * **Comment**: 
* **Source Code**: Prescription.prescriber.givenName (A.1.3.2 Given name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.name.family
  * **Comment**: 
* **Source Code**: Prescription.prescriber.qualification (A.1.3.3 Professional qualifications)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.qualification
  * **Comment**: 
* **Source Code**: Prescription.prescriber.contact (A.1.3.4 Details for direct contact)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.telecom
  * **Comment**: 
* **Source Code**: Prescription.prescriber.workAddress (A.1.3.5 Work address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.address
  * **Comment**: where use = 'work'
* **Source Code**: Prescription.prescriber.identifier (A.1.3.7 Health care provider identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Practictioner.identifier
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "eP2FHIR-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh-mpd/ConceptMap/eP2FHIR-eu-xpandh",
  "version" : "0.1.0",
  "name" : "eP2Fhir",
  "title" : "eHN Subject to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:31:37+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "eHN ePrescription Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "It shows how the ePrescription data set defined by the EU eHN guidelines is mapped into this guide",
  "sourceUri" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Prescription",
  "targetUri" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/MedicationRequest-eu-xpandh",
  "group" : [
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Prescription",
      "target" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/MedicationRequest-eu-xpandh",
      "element" : [
        {
          "code" : "Prescription.patient",
          "display" : "A.1.1 Patient administrative data",
          "target" : [
            {
              "code" : "MedicationRequest.subject",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.authentication",
          "display" : "A.1.2 Authentication of the prescription",
          "target" : [
            {
              "code" : "MedicationRequest",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Prescription.authentication.identifier",
          "display" : "A.1.2.1 Identifier of the Prescription",
          "target" : [
            {
              "code" : "MedicationRequest.identifier",
              "equivalence" : "equivalent",
              "comment" : "if a prescription includes only one prescribed item"
            }
          ]
        },
        {
          "code" : "Prescription.authentication.identifier",
          "display" : "A.1.2.1 Identifier of the Prescription",
          "target" : [
            {
              "code" : "MedicationRequest.groupIdentifier",
              "equivalence" : "equivalent",
              "comment" : "if a prescription includes more then one prescribed item"
            }
          ]
        },
        {
          "code" : "Prescription.authentication.date",
          "display" : "A.1.2.2 Issue date",
          "target" : [
            {
              "code" : "MedicationRequest.authoredOn",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber",
          "display" : "A.1.3 Identification of the prescribing health professional",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.familyName",
          "display" : "A.1.3.1 Familyname",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Details in the referred Practictioner resource"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.givenName",
          "display" : "A.1.3.2 Given name",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Details in the referred Practictioner resource"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.qualification",
          "display" : "A.1.3.3 Professional qualifications",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Details in the referred Practictioner resource"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.contact",
          "display" : "A.1.3.4 Details for direct contact",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Details in the referred Practictioner resource"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.workAddress",
          "display" : "A.1.3.5 Work address",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Details in the referred Practictioner resource"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.signature",
          "display" : "A.1.3.6 Signature",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Not implemented in the current eP / eD service"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.identifier",
          "display" : "A.1.3.7  Health care provider identifier",
          "target" : [
            {
              "code" : "MedicationRequest.requester",
              "equivalence" : "relatedto",
              "comment" : "Details in the referred Practictioner resource"
            }
          ]
        },
        {
          "code" : "Prescription.product",
          "display" : "A1.4 Identification of the prescribed product",
          "target" : [
            {
              "code" : "MedicationRequest.medicationReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details",
          "display" : "A.1.5 Prescription information",
          "target" : [
            {
              "code" : "MedicationRequest",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Prescription.details.quantity",
          "display" : "A.1.5.2 Quantity of prescribed product",
          "target" : [
            {
              "code" : "MedicationRequest.dispenseRequest.quantity",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Prescription.details.doseRegimen",
          "display" : "A.1.5.3 Dose regimen",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details.doseRegimen.numOfIntakes",
          "display" : "A.1.5.3.1 Number of units per intake",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction.doseAndRate.doseQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details.doseRegimen.frequencyOfIntakes",
          "display" : "A.1.5.3.2 Frequency of intakes",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction.timing",
              "equivalence" : "relatedto",
              "comment" : "A combination of frequency, period and periodUnit.\n'3 times per day', 3 would be the frequency and '1 day' would be the period/periodUnit."
            }
          ]
        },
        {
          "code" : "Prescription.details.route",
          "display" : "A.1.5.4 Route of administration",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction.route",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details.duration",
          "display" : "A.1.5.5 Duration of treatment",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details.startDate",
          "display" : "A.1.5.6 Starting date of therapy ",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction.timing.duration",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Prescription.details.directionsOfUse",
          "display" : "A.1.5.7 Directions for use",
          "target" : [
            {
              "code" : "MedicationRequest.dosageInstruction",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Prescription.details.expiryDate",
          "display" : "A.1.5.8 Prescription expiry date",
          "target" : [
            {
              "code" : "MedicationRequest.dispenseRequest.validityPeriod",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details.repeats",
          "display" : "A.1.5.9 Repeats",
          "target" : [
            {
              "code" : "MedicationRequest",
              "equivalence" : "relatedto",
              "comment" : "TO BE DISCUSSED"
            }
          ]
        },
        {
          "code" : "Prescription.details.reason",
          "display" : "A.1.5.10 Reason for prescription",
          "target" : [
            {
              "code" : "MedicationRequest.reasonReference",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Prescription.details.reason",
          "display" : "A.1.5.10 Reason for prescription",
          "target" : [
            {
              "code" : "MedicationRequest.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.details.substitution",
          "display" : "A.1.5.11 Substitution",
          "target" : [
            {
              "code" : "MedicationRequest.substitution.allowedCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Prescription",
      "target" : "http://hl7.eu/fhir/ig/xpandh-mpd/StructureDefinition/Practictioner-eu-xpandh",
      "element" : [
        {
          "code" : "Prescription.prescriber.familyName",
          "display" : "A.1.3.1 Familyname",
          "target" : [
            {
              "code" : "Practictioner.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.givenName",
          "display" : "A.1.3.2 Given name",
          "target" : [
            {
              "code" : "Practictioner.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.qualification",
          "display" : "A.1.3.3 Professional qualifications",
          "target" : [
            {
              "code" : "Practictioner.qualification",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.contact",
          "display" : "A.1.3.4 Details for direct contact",
          "target" : [
            {
              "code" : "Practictioner.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.workAddress",
          "display" : "A.1.3.5 Work address",
          "target" : [
            {
              "code" : "Practictioner.address",
              "equivalence" : "equivalent",
              "comment" : "where use = 'work'"
            }
          ]
        },
        {
          "code" : "Prescription.prescriber.identifier",
          "display" : "A.1.3.7  Health care provider identifier",
          "target" : [
            {
              "code" : "Practictioner.identifier",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
