# hl7.eu.fhir.xpandh.hdr#0.1.0: XpanDH Hospital Discharge Report

## Pages

* [Home](index.md)
* [Downloads](downloads.md)
* [Examples](examples.md)
* [Artifacts Summary](artifacts.md)
* [Hospital Discharge Report](hospital-discharge-report.md)

## Resources

### CodeSystems

* [Xpandh Assessment Category](CodeSystem-assessment-category-xpandh-cs.md)
* [Present on Admission (POA) Indicator](CodeSystem-poa-indicator-xpandh-cs.md)
* [WHO Disability Assessment Schedule 2.0](CodeSystem-whodas-20-cs.md)

### ValueSets

* [TNM M Category](ValueSet-TNM-M-category-vs.md)
* [Clinical M](ValueSet-TNM-M-clinical-category-vs.md)
* [Pathological M](ValueSet-TNM-M-pathologycal-category-vs.md)
* [TNM N Category](ValueSet-TNM-N-category-vs.md)
* [Clinical N](ValueSet-TNM-N-clinical-category-vs.md)
* [Pathological N](ValueSet-TNM-N-pathological-category-vs.md)
* [Primary tumor T](ValueSet-TNM-T-category-vs.md)
* [Clinical T](ValueSet-TNM-T-clinical-category-vs.md)
* [Pathological T](ValueSet-TNM-T-pathological-category-vs.md)
* [Encounter Voluntary Status Value Set](ValueSet-admission-voluntary-status-vs.md)
* [Allergy Intolerance Substances - Xpandh](ValueSet-allergy-intolerance-substances-xpandh-vs.md)
* [Allergy Intolerance - Xpandh](ValueSet-allergy-intolerance-xpandh-vs.md)
* [Anthropometric Observation Value Set](ValueSet-anthropometric-observation-vs.md)
* [Xpandh Assessment Observation Category](ValueSet-assessment-observation-category-vs.md)
* [BMI Observation Unit Value Set](ValueSet-bmi-observation-unit-vs.md)
* [BMI Observation Value Set](ValueSet-bmi-observation-vs.md)
* [Body Height Observation Value Set](ValueSet-body-height-observation-vs.md)
* [Body Weight Observation Value Set](ValueSet-body-weight-observation-vs.md)
* [Body Weight Observation Value Set](ValueSet-body-weight-units-vs.md)
* [Cancer Stage Grading: Snomed CT](ValueSet-cancer-stage-grading-vs.md)
* [Cancer Stage Group: SNOMED CT](ValueSet-cancer-stageGroup-vs.md)
* [Circumference Observation Value Set](ValueSet-circumference-observation-vs.md)
* [In-patient Encounter Type Value Set](ValueSet-encounter-status-vs-eu-hdr.md)
* [Exposure of transmissible agents - Xpandh](ValueSet-exposure-agent-xpandh-vs.md)
* [Xpandh Functional Assessment Scales](ValueSet-functional-assessment-scales-vs.md)
* [Admission Urgency Value Set](ValueSet-hdr-admission-urgency-xpandh-vs.md)
* [Mandatory Condition Value Set](ValueSet-hdr-condition-mandatory-xpandh-vs.md)
* [Condition Value Set](ValueSet-hdr-condition-xpandh-vs.md)
* [In-patient Encounter Type Value Set](ValueSet-hdr-encounter-type-xpandh-vs.md)
* [Encounter Class Value Set](ValueSet-hdr-encounterClass-xpandh-vs.md)
* [Condition Present on Admission (POA) Value Set](ValueSet-hdr-poa-indicator-xpandh-vs.md)
* [Treatment Class Value Set](ValueSet-hdr-treated-xpandh-vs.md)
* [Xpandh Immunization Target Disease or Agent](ValueSet-immunization-target-vs.md)
* [Observation Codes for Distant Metastases Category](ValueSet-mcode-observation-codes-distant-metastases-vs.md)
* [Observation Codes for Primary Tumor Category](ValueSet-mcode-observation-codes-primary-tumor-vs.md)
* [Observation Codes for Regional Node Category](ValueSet-mcode-observation-codes-regional-nodes-vs.md)
* [Medical Devices - SNOMED CT + Absent/Unknown - IPS](ValueSet-medical-devices-snomed-absent-unknown-xpandh-vs.md)
* [Medical Devices (SNOMED CT) - Xpandh](ValueSet-medical-devices-xpandh-vs.md)
* [Medications - SNOMED CT + Absent/Unknown (IPS)](ValueSet-medication-snomed-absent-unknown-uv-ips.md)
* [Procedure codes: Snomed CT](ValueSet-procedure-snomed-xpandh-vs.md)
* [Procedures - SNOMED CT + Absent/Unknown - IPS](ValueSet-procedures-snomed-absent-unknown-xpandh-vs.md)
* [Skinfold Thickness Units Value Set](ValueSet-skinfold-thickness-units-vs.md)
* [Skinfold Thickness Value Set](ValueSet-skinfold-thickness-vs.md)
* [Social history observation codes: Snomed CT](ValueSet-socail-history-observations-xpandh-vs.md)
* [Vital Signs Observation Value Set](ValueSet-vital-signs-observation-vs.md)
* [Xpandh WHODAS Codes Valueset](ValueSet-whodas-code-vs.md)
* [Xpandh WHODAS Domain Valueset](ValueSet-whodas-domain-vs.md)
* [Xpandh WHODAS Result Valueset](ValueSet-whodas-result-vs.md)

### Logicals

* [A.2.4 - Admission evaluation (eHN)](StructureDefinition-HDRAdmissionEvaluation.md)
* [A.2.1 - Advance Directives (eHN)](StructureDefinition-HDRAdvanceDirectives.md)
* [A.2.2 - Alerts (eHN)](StructureDefinition-HDRAlerts.md)
* [A.2.8 - Discharge details (eHN)](StructureDefinition-HDRDischargeDetails.md)
* [A.2.3 - Encounter (eHN)](StructureDefinition-HDREncounter.md)
* [A.2.7 - Hospital stay (eHN)](StructureDefinition-HDRHospitalStay.md)
* [A.2.6 - Patient history (eHN)](StructureDefinition-HDRPatientHistory.md)
* [A.2.9 - Care plan and other recommendations after discharge (eHN)](StructureDefinition-HDRRecommendations.md)
* [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)
* [Hospital Discharge Report (SK)](StructureDefinition-HospitalDischargeReportSK.md)

### Resource Profiles

* [Bundle: EU Hospital Discharge Report](StructureDefinition-Bundle-hdr-xpandh.md)
* [CareTeam](StructureDefinition-CareTeam-eu-xpandh.md)
* [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)
* [Flag](StructureDefinition-Flag-eu-xpandh.md)
* [MedicationDispense Xpandh](StructureDefinition-MedicationDispense-hdr-eu-xpandh.md)
* [MedicationRequest](StructureDefinition-MedicationRequest-eu-xpandh.md)
* [MedicationStatement](StructureDefinition-MedicationStatement-eu-xpandh.md)
* [Observation Results: pathology](StructureDefinition-Observation-results-pathology-eu-xpandh.md)
* [Observation Results: radiology](StructureDefinition-Observation-results-radiology-eu-xpandh.md)
* [Observation Results](StructureDefinition-Observation-results-xpandh.md)
* [Patient: HDR](StructureDefinition-Patient-eu-xpandh.md)
* [Practitioner](StructureDefinition-Practitioner-eu-xpandh.md)
* [PractitionerRole](StructureDefinition-PractitionerRole-eu-xpandh.md)
* [Procedure (Xpandh)](StructureDefinition-Procedure-xpandh.md)
* [Xpandh Alergy Intolerance Profile](StructureDefinition-allergy-intolerance-xpandh.md)
* [Xpandh Assessment Observation Profile](StructureDefinition-assessment-observation-xpandh.md)
* [Xpandh Blood Pressure Profile](StructureDefinition-blood-pressure-xpandh.md)
* [Xpandh BMI Profile](StructureDefinition-bmi-xpandh.md)
* [Xpandh Body Height Profile](StructureDefinition-body-height-xpandh.md)
* [Xpandh Body Temperature Profile](StructureDefinition-body-temperature-xpandh.md)
* [Xpandh Body Weight Profile](StructureDefinition-body-weight-xpandh.md)
* [Observation: Cancer Stage Group](StructureDefinition-cancer-stage-group-hdr-xpandh.md)
* [Xpandh Circumference Measurement Profile](StructureDefinition-circumference-measurement-xpandh.md)
* [Xpandh Clinical Impression Profile](StructureDefinition-clinical-impression-hdr-xpandh.md)
* [Condition Xpandh Hospital Dischage Encounter](StructureDefinition-condition-encounter-hdr-xpandh.md)
* [Condition Xpandh Profile](StructureDefinition-condition-hdr-xpandh.md)
* [Xpandh Condition Problems Profile](StructureDefinition-condition-problems-hdr-xpandh.md)
* [Coverage: Encounter Payer](StructureDefinition-coverage-hdr-eu-xpandh.md)
* [Device (Xpandh)](StructureDefinition-device-xpandh.md)
* [Xpandh Functional Status Observation Profile](StructureDefinition-functional-status-assessment-xpandh.md)
* [Xpandh Heart Rate Profile](StructureDefinition-heart-rate-xpandh.md)
* [Xpandh Immunization Profile](StructureDefinition-immunization-xpandh.md)
* [Xpandh Infectious Contact Profile](StructureDefinition-infectious-contact-xpandh.md)
* [Inpatient Encounter Xpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md)
* [Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md)
* [Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md)
* [Medication (Xpandh)](StructureDefinition-medication-xpandh.md)
* [Vital Signs Observation](StructureDefinition-observation-vital-signs-xpandh.md)
* [Xpandh Organization Profile](StructureDefinition-organization-expandh.md)
* [Xpandh Oxygen Saturation Profile](StructureDefinition-oxygen-saturation-xpandh.md)
* [Xpandh Pediatric Head Occipital Frontal Circumference Profile](StructureDefinition-pediatric-head-occ-front-circumfer-percent-xpandh.md)
* [Xpandh Respiratory Rate Profile](StructureDefinition-respiratory-rate-xpandh.md)
* [ServiceRequest: Encounter Request](StructureDefinition-serviceRequest-hdr-eu-xpandh.md)
* [Xpandh Skinfold Thickness Profile](StructureDefinition-skinfold-thickness-xpandh.md)
* [Xpandh social history Profile](StructureDefinition-social-history-xpandh.md)
* [Xpandh travel history Profile](StructureDefinition-travel-history-xpandh.md)
* [Xpandh WHO Disability Assessment Schedule (WHODAS 2.0) Profile](StructureDefinition-whodas-assessment-xpandh.md)

### Extensions

* [Encounter Voluntary Status](StructureDefinition-encounter-voluntary-status.md)

### ConceptMaps

* [eHN HDR header metadata to this guide Map](ConceptMap-ConceptMap-HeaderMeta2FHIR-eu-xpandh.md)
* [eHN Recipient to this guide Map](ConceptMap-ConceptMap-HeaderParticipants2FHIR-eu-xpandh.md)
* [eHN Recipient to this guide Map](ConceptMap-ConceptMap-hdrEncounter2FHIR-eu-xpandh.md)
* [eHN Recipient to this guide Map](ConceptMap-ConceptMap-hdrHeader2FHIR-eu-xpandh.md)

### ImplementationGuides

* [XpanDH Hospital Discharge Report](index.md)

### Examples

* [SK-Hospital-Encounter (Encounter)](Encounter-SK-Hospital-Encounter.md)
* [example-it-1-1 (Immunization)](Immunization-example-it-1-1.md)
* [example-it-1-2 (Immunization)](Immunization-example-it-1-2.md)
* [MUDr. Pes Filipes, praktický lékař (Organization)](Organization-SK-Organization-GP.md)
* [Nemocnica - oddělení chirurgie (Organization)](Organization-SK-Organization-Hospital-Department-1.md)
* [Mestská Nemocnica Kubín (Organization)](Organization-SK-Organization-Hospital.md)
* [AZIENDA USL TOSCANA CENTRO (Organization)](Organization-org-example-it.md)
* [Mracena (Patient)](Patient-Mracena.md)
* [example-it-1 (Patient)](Patient-example-it-1.md)
* [SK-Practitioner-1 (Practitioner)](Practitioner-SK-Practitioner-1.md)
* [SK-Practitioner-2 (Practitioner)](Practitioner-SK-Practitioner-2.md)
