# Xpandh WHODAS Result Valueset - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh WHODAS Result Valueset**

## ValueSet: Xpandh WHODAS Result Valueset 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/whodas-result-vs | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:WhodasResultVS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Used to specify WHODAS Disability Assessment Schedule 2.0 functional assessment result codes. 

 **References** 

* [Xpandh WHO Disability Assessment Schedule (WHODAS 2.0) Profile](StructureDefinition-whodas-assessment-xpandh.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "whodas-result-vs",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/whodas-result-vs",
  "version" : "0.1.0",
  "name" : "WhodasResultVS",
  "title" : "Xpandh WHODAS Result Valueset",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Used to specify WHODAS Disability Assessment Schedule 2.0 functional assessment result codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "compose" : {
    "include" : [
      {
        "system" : "https://id.who.int/whodas",
        "concept" : [
          {
            "code" : "0",
            "display" : "None"
          },
          {
            "code" : "1",
            "display" : "Mild"
          },
          {
            "code" : "2",
            "display" : "Moderate"
          },
          {
            "code" : "3",
            "display" : "Severe"
          },
          {
            "code" : "4",
            "display" : "Extreme"
          }
        ]
      }
    ]
  }
}

```
