# Encounter Voluntary Status - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Voluntary Status**

## Extension: Encounter Voluntary Status 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/encounter-voluntary-status | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:EncounterVoluntaryStatus |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

This extension provides information about voluntary or involuntary nature of the encounter.

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/encounter-voluntary-status)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-encounter-voluntary-status.csv), [Excel](StructureDefinition-encounter-voluntary-status.xlsx), [Schematron](StructureDefinition-encounter-voluntary-status.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "encounter-voluntary-status",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/encounter-voluntary-status",
  "version" : "0.1.0",
  "name" : "EncounterVoluntaryStatus",
  "title" : "Encounter Voluntary Status",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This extension provides information about voluntary or involuntary nature of the encounter.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Encounter"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Encounter Voluntary Status",
        "definition" : "This extension provides information about voluntary or involuntary nature of the encounter."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/encounter-voluntary-status"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/admission-voluntary-status-vs"
        }
      }
    ]
  }
}

```
