# A - Hospital Discharge Report (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A - Hospital Discharge Report (eHN)**

## Logical Model: A - Hospital Discharge Report (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HospitalDischargeReportEHN |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report Maturity Level: 0 Draft 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HospitalDischargeReport)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HospitalDischargeReport.csv), [Excel](StructureDefinition-HospitalDischargeReport.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HospitalDischargeReport",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
  "version" : "0.1.0",
  "name" : "HospitalDischargeReportEHN",
  "title" : "A - Hospital Discharge Report (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Hospital Discharge Report model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HospitalDischargeReport",
        "path" : "HospitalDischargeReport",
        "short" : "A - Hospital Discharge Report (eHN)",
        "definition" : "Hospital Discharge Report\nMaturity Level: 0 Draft",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header",
        "path" : "HospitalDischargeReport.header",
        "short" : "A.1 - Hospital Discharge Report header data element",
        "definition" : "Hospital Discharge Report header data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification",
        "path" : "HospitalDischargeReport.header.subjectIdentification",
        "short" : "A.1.1 - Identification of the patient/subject",
        "definition" : "Identification of the patient/subject",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.given",
        "path" : "HospitalDischargeReport.header.subjectIdentification.given",
        "short" : "A.1.1.1 - Given name",
        "definition" : "The given name/first name of the patient (also known as forename or first name). This field can contain more than one element.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.family",
        "path" : "HospitalDischargeReport.header.subjectIdentification.family",
        "short" : "A.1.1.2 - Family name/surname",
        "definition" : "The family name/surname/last name of the patient. This field can contain more than one element or multiple fields could be present.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.birthDate",
        "path" : "HospitalDischargeReport.header.subjectIdentification.birthDate",
        "short" : "A.1.1.3 - Date of birth",
        "definition" : "Complete date, following the ISO 8601.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.identifier",
        "path" : "HospitalDischargeReport.header.subjectIdentification.identifier",
        "short" : "A.1.1.4 - National healthcare patient ID",
        "definition" : "An identifier of the patient that is unique within a defined scope. Example: National ID (birth number) for a Czech patient. Multiple identifiers could be provided",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.nationality",
        "path" : "HospitalDischargeReport.header.subjectIdentification.nationality",
        "short" : "A.1.1.5 - Nationality",
        "definition" : "Nationality of the patient.",
        "comment" : "ISO 3166",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.gender",
        "path" : "HospitalDischargeReport.header.subjectIdentification.gender",
        "short" : "A.1.1.6 - Gender",
        "definition" : "This field must contain a recognised valid value for \"administrative gender\". If different, \"physiological gender\" should be communicated elsewhere in the relevant clinical information section.",
        "comment" : "HL7 Administrative Gender",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectIdentification.countryOfAffiliation",
        "path" : "HospitalDischargeReport.header.subjectIdentification.countryOfAffiliation",
        "short" : "A.1.1.7 - Country of affiliation",
        "definition" : "Name of country of affiliation",
        "comment" : "ISO 3166",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact",
        "path" : "HospitalDischargeReport.header.subjectContact",
        "short" : "A.1.2 - Patient/subject related contact information",
        "definition" : "Patient/subject related contact information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.personalContact",
        "path" : "HospitalDischargeReport.header.subjectContact.personalContact",
        "short" : "A.1.2.1 - Patient address",
        "definition" : "Patient address",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.personalContact.address",
        "path" : "HospitalDischargeReport.header.subjectContact.personalContact.address",
        "short" : "A.1.2.1.1 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "comment" : "ISO 3166",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.personalContact.telecom",
        "path" : "HospitalDischargeReport.header.subjectContact.personalContact.telecom",
        "short" : "A.1.2.1.2 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP",
        "short" : "A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
        "definition" : "Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP.identifier",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP.identifier",
        "short" : "A.1.2.2.1 - Identifier of the HP",
        "definition" : "An identifier of the health professional that is unique within a defined scope. Example: National health professional ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP.name",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP.name",
        "short" : "A.1.2.2.2 - Name of the HP",
        "definition" : "Name of the health professional that has been treating or taking responsibility for the patient.[the structure of the name will be the same as for the patient (given name, family name / surname)]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP.role",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP.role",
        "short" : "A.1.2.2.3 - Role of the HP",
        "definition" : "Health professional role. Multiple roles could be provided.",
        "comment" : "ISCO",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP.organization",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP.organization",
        "short" : "A.1.2.2.4 - HP Organisation",
        "definition" : "Health professional organisation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP.address",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP.address",
        "short" : "A.1.2.2.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "comment" : "ISO 3166",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.preferredHP.telecom",
        "path" : "HospitalDischargeReport.header.subjectContact.preferredHP.telecom",
        "short" : "A.1.2.2.6 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson",
        "short" : "A.1.2.3 - Contact person/ legal guardian (multiple contacts could be provided)",
        "definition" : "Contact person/ legal guardian (multiple contacts could be provided)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.role",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.role",
        "short" : "A.1.2.3.1 - Role of that person",
        "definition" : "Role of the contact person: legal guardian, next of kin, other person to contact.",
        "comment" : "HL7 RoleClass",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.relationship",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.relationship",
        "short" : "A.1.2.3.2 - Relationship level",
        "definition" : "Relationship type with the patient (e.g. father, wife, daughter)",
        "comment" : "HL7 RoleCodeSNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.given",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.given",
        "short" : "A.1.2.3.4 - Given name",
        "definition" : "Given name of the contact person/guardian . This field can contain more than one element.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.family",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.family",
        "short" : "A.1.2.3.5 - Family name/surname",
        "definition" : "Family name of the contact person. This field can contain more than one element [the structure of the name will be the same as for the patient (given name, family name / surname)]..",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.address",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.address",
        "short" : "A.1.2.3.6 - Address",
        "definition" : "Mailing, home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "comment" : "ISO 3166",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.telecom",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.telecom",
        "short" : "A.1.2.3.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.subjectContact.contactPerson.organization",
        "path" : "HospitalDischargeReport.header.subjectContact.contactPerson.organization",
        "short" : "A.1.2.3.8 - Contact person organisation",
        "definition" : "Contact person organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.payer",
        "path" : "HospitalDischargeReport.header.payer",
        "short" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. ",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.payer.insuranceCode",
        "path" : "HospitalDischargeReport.header.payer.insuranceCode",
        "short" : "A.1.3.1 - Health insurance code",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.payer.insuranceName",
        "path" : "HospitalDischargeReport.header.payer.insuranceName",
        "short" : "A.1.3.2 - Health insurance name",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.payer.insuranceNumber",
        "path" : "HospitalDischargeReport.header.payer.insuranceNumber",
        "short" : "A.1.3.3 - Health insurance number",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient",
        "path" : "HospitalDischargeReport.header.informationRecipient",
        "short" : "A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable",
        "definition" : "Information recipient - (intended recipient or recipients of the report), if applicable",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.identifier",
        "path" : "HospitalDischargeReport.header.informationRecipient.identifier",
        "short" : "A.1.4.1 - Recipient identifier",
        "definition" : "The health professional or patient identifier. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier could be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.name",
        "path" : "HospitalDischargeReport.header.informationRecipient.name",
        "short" : "A.1.4.2 - Recipient name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.organizationID",
        "path" : "HospitalDischargeReport.header.informationRecipient.organizationID",
        "short" : "A.1.4.3 - Recipient organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.organization",
        "path" : "HospitalDischargeReport.header.informationRecipient.organization",
        "short" : "A.1.4.4 - Recipient organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.address",
        "path" : "HospitalDischargeReport.header.informationRecipient.address",
        "short" : "A.1.4.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.country",
        "path" : "HospitalDischargeReport.header.informationRecipient.country",
        "short" : "A.1.4.6 - Country",
        "definition" : "Country of the intended recipient as part of the address.",
        "comment" : "ISO 3166",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.informationRecipient.telecom",
        "path" : "HospitalDischargeReport.header.informationRecipient.telecom",
        "short" : "A.1.4.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated to a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.author",
        "path" : "HospitalDischargeReport.header.author",
        "short" : "A.1.5 - Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.",
        "definition" : "Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.author.identifier",
        "path" : "HospitalDischargeReport.header.author.identifier",
        "short" : "A.1.5.1 - Author identifier",
        "definition" : "The health professional identifier that will allow addressing recipients within a national or international data exchange infrastructure, such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.author.name",
        "path" : "HospitalDischargeReport.header.author.name",
        "short" : "A.1.5.2 - Author name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.author.organizationID",
        "path" : "HospitalDischargeReport.header.author.organizationID",
        "short" : "A.1.5.3 - Author organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.author.organization",
        "path" : "HospitalDischargeReport.header.author.organization",
        "short" : "A.1.5.4 - Author organisation",
        "definition" : "The healthcare provider organisation information.  ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.author.dateTime",
        "path" : "HospitalDischargeReport.header.author.dateTime",
        "short" : "A.1.5.5 - Date Time",
        "definition" : "Date and time of the last modification of the document by its Author.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.attester",
        "path" : "HospitalDischargeReport.header.attester",
        "short" : "A.1.6 - Attester (multiple attesters could be provided)",
        "definition" : "Attester (multiple attesters could be provided)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.attester.identifier",
        "path" : "HospitalDischargeReport.header.attester.identifier",
        "short" : "A.1.6.1 - Attester identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.attester.name",
        "path" : "HospitalDischargeReport.header.attester.name",
        "short" : "A.1.6.2 - Attester name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.attester.organizationID",
        "path" : "HospitalDischargeReport.header.attester.organizationID",
        "short" : "A.1.6.3 - Attester organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.attester.organization",
        "path" : "HospitalDischargeReport.header.attester.organization",
        "short" : "A.1.6.4 - Attester organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.attester.dateTime",
        "path" : "HospitalDischargeReport.header.attester.dateTime",
        "short" : "A.1.6.5 - Approval date and time",
        "definition" : "Date and time of the approval of the document by Attester.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.legalAuthenticator",
        "path" : "HospitalDischargeReport.header.legalAuthenticator",
        "short" : "A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document)",
        "definition" : "Legal authenticator (The person taking responsibility for the medical content of the document)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.legalAuthenticator.identifier",
        "path" : "HospitalDischargeReport.header.legalAuthenticator.identifier",
        "short" : "A.1.7.1 - Legal authenticator identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. Multiple identifiers could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.legalAuthenticator.name",
        "path" : "HospitalDischargeReport.header.legalAuthenticator.name",
        "short" : "A.1.7.2 - Legal authenticator name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.legalAuthenticator.organizationID",
        "path" : "HospitalDischargeReport.header.legalAuthenticator.organizationID",
        "short" : "A.1.7.3 - Legal authenticator organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.legalAuthenticator.organization",
        "path" : "HospitalDischargeReport.header.legalAuthenticator.organization",
        "short" : "A.1.7.4 - Legal authenticator organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.legalAuthenticator.dateTime",
        "path" : "HospitalDischargeReport.header.legalAuthenticator.dateTime",
        "short" : "A.1.7.5 - Authentication date and time",
        "definition" : "Date and time when the document was authorised.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata",
        "path" : "HospitalDischargeReport.header.documentMetadata",
        "short" : "A.1.8 - Document metadata",
        "definition" : "Document metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.identifier",
        "path" : "HospitalDischargeReport.header.documentMetadata.identifier",
        "short" : "A.1.8.1 - Document ID",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.type",
        "path" : "HospitalDischargeReport.header.documentMetadata.type",
        "short" : "A.1.8.2 - Document type",
        "definition" : "Identifies the type of document at hand, e.g. Hospital discharge report.",
        "comment" : "LOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.status",
        "path" : "HospitalDischargeReport.header.documentMetadata.status",
        "short" : "A.1.8.3 - Document status",
        "definition" : "The status of the Hospital discharge report. E.g., preliminary, final.",
        "comment" : "hl7:CompositionStatus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.dateTime",
        "path" : "HospitalDischargeReport.header.documentMetadata.dateTime",
        "short" : "A.1.8.4 - Report date and time",
        "definition" : "Date and time of the Hospital discharge  report creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.title",
        "path" : "HospitalDischargeReport.header.documentMetadata.title",
        "short" : "A.1.8.5 - Document title",
        "definition" : "Document title, fix value \"Hospital discharge report\". ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.custodian",
        "path" : "HospitalDischargeReport.header.documentMetadata.custodian",
        "short" : "A.1.8.6 - Report custodian",
        "definition" : "Organisation that is in charge of maintaining the report [this element will include organisation ID, name, address etc., as other elements describing organisations].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.confidentiality",
        "path" : "HospitalDischargeReport.header.documentMetadata.confidentiality",
        "short" : "A.1.8.7 - Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "comment" : "hl7:Confidentiality",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.language",
        "path" : "HospitalDischargeReport.header.documentMetadata.language",
        "short" : "A.1.8.8 - Language",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "comment" : "ISO 639",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.header.documentMetadata.version",
        "path" : "HospitalDischargeReport.header.documentMetadata.version",
        "short" : "A.1.8.9 - Version",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body",
        "path" : "HospitalDischargeReport.body",
        "short" : "A.2 - Hospital Discharge Report body data element",
        "definition" : "Hospital Discharge Report body data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.presentedForm",
        "path" : "HospitalDischargeReport.body.presentedForm",
        "short" : "A.2.0 - Hospital Discharge Report in its narrative form",
        "definition" : "Hospital Discharge Report in its narrative form",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.advanceDirectives",
        "path" : "HospitalDischargeReport.body.advanceDirectives",
        "short" : "A.2.1 - Advance directives",
        "definition" : "Advance directives",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdvanceDirectives"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.alerts",
        "path" : "HospitalDischargeReport.body.alerts",
        "short" : "A.2.2 - Alerts",
        "definition" : "Alerts",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAlerts"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.encounter",
        "path" : "HospitalDischargeReport.body.encounter",
        "short" : "A.2.3 - Encounter [Mandatory]",
        "definition" : "A.2.3-Encounter [Mandatory]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDREncounter"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.admissionEvaluation",
        "path" : "HospitalDischargeReport.body.admissionEvaluation",
        "short" : "A.2.4 - Admission evaluation - Admission status should be reported exceptionally only if it is relevant to ensure continuity of care.",
        "definition" : "Admission evaluation - Admission status should be reported exceptionally only if it is relevant to ensure continuity of care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdmissionEvaluation"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.patientHistory",
        "path" : "HospitalDischargeReport.body.patientHistory",
        "short" : "A.2.6 - Patient history",
        "definition" : "Patient history (might include information about provenance of the information)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRPatientHistory"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.hospitalStay",
        "path" : "HospitalDischargeReport.body.hospitalStay",
        "short" : "A.2.7 - Course of hospitalisation (Hospital stay)",
        "definition" : "Course of hospitalisation (Hospital stay)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRHospitalStay"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.dischargeDetails",
        "path" : "HospitalDischargeReport.body.dischargeDetails",
        "short" : "A.2.8 - Discharge details",
        "definition" : "Discharge details (structured information should be provided, however if not available, at least a summary note should be present).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRDischargeDetails"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReport.body.recommendations",
        "path" : "HospitalDischargeReport.body.recommendations",
        "short" : "A.2.9 - Care plan and other recommendations after discharge.",
        "definition" : "Care plan and other recommendations after discharge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRRecommendations"
          }
        ]
      }
    ]
  }
}

```
