# A.2.6 - Patient history (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.6 - Patient history (eHN)**

## Logical Model: A.2.6 - Patient history (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRPatientHistory | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNPatientHistory |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Patient history - A.2.6 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRPatientHistory)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRPatientHistory.csv), [Excel](StructureDefinition-HDRPatientHistory.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRPatientHistory",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRPatientHistory",
  "version" : "0.1.0",
  "name" : "HdrEHNPatientHistory",
  "title" : "A.2.6 - Patient history (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Patient history - A.2.6 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRPatientHistory",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRPatientHistory",
        "path" : "HDRPatientHistory",
        "short" : "A.2.6 - Patient history (eHN)",
        "definition" : "Hospital Discharge Report - Patient history - A.2.6 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRPatientHistory.medicalHistory",
        "path" : "HDRPatientHistory.medicalHistory",
        "short" : "A.2.6.1 - Medical history",
        "definition" : "Medical history",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions",
        "short" : "A.2.6.1.1 - History of problems",
        "definition" : "A list of conditions of a patient that the patient suffered in the past or still suffers. Unlike diagnostic summary, medical history is not only a list of problems, but could contain broader description of the condition and its progress, details about treatment including medication and patient response to treatment. Past problem section (unlike the same section of the patient summary) should include only conditions that are important for continuity of care. This section, if provided, complements the diagnostic summary section of the discharge report. ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.conditionSpecification",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.conditionSpecification",
        "short" : "A.2.6.1.1.1 - Problem description",
        "definition" : "Problem specification",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.conditionDetails",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.conditionDetails",
        "short" : "A.2.6.1.1.2 - Problem details",
        "definition" : "Problem details include code that identifies problem, specification of the body structure, laterality, and other aspects of the problem.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed\nIPS Absent and Unknown Data\nICD-O-3",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.onsetDate",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.onsetDate",
        "short" : "A.2.6.1.1.3 - Onset date",
        "definition" : "Onset date of the problem/condition",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.endDate",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.endDate",
        "short" : "A.2.6.1.1.4 - End date",
        "definition" : "The date or estimated date that the condition resolved or went into remission.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.clinicalStatus",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.clinicalStatus",
        "short" : "A.2.6.1.1.5 - Clinical status",
        "definition" : "Status of the condition/problem (active, resolved, inactive, ...)",
        "comment" : "hl7:condition-clinical",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.resolution",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.resolution",
        "short" : "A.2.6.1.1.6 - Resolution circumstances",
        "definition" : "Describes the reason for which the status of the problem changed from current to inactive (e.g. surgical procedure, medical treatment, etc.). This field includes \"free text\" if the resolution circumstances are not already included in other fields such as surgical procedure, medical device, etc., e.g. hepatic cystectomy (this will be the resolution circumstances for the problem \"hepatic cyst\" and will be included in surgical procedures).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.severity",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.severity",
        "short" : "A.2.6.1.1.7 - Severity",
        "definition" : "A subjective assessment of the severity of the condition as evaluated by the clinician.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfConditions.stage",
        "path" : "HDRPatientHistory.medicalHistory.historyOfConditions.stage",
        "short" : "A.2.6.1.1.8 - Stage",
        "definition" : "Stage/grade, usually assessed formally using a specific staging/grading system.",
        "comment" : "e.g. TNM\nICD-O-3 ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.medicalDevices",
        "path" : "HDRPatientHistory.medicalHistory.medicalDevices",
        "short" : "A.2.6.1.2 - Devices and Implants",
        "definition" : "Devices and Implants",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.medicalDevices.description",
        "path" : "HDRPatientHistory.medicalHistory.medicalDevices.description",
        "short" : "A.2.6.1.2.1 - Device and implant description",
        "definition" : "Describes the patient's implanted and external medical devices and equipment upon which their health status depends. Includes devices such as cardiac pacemakers, implantable fibrillator, prosthesis, ferromagnetic bone implants, etc. of which the HP needs to be aware.",
        "comment" : "SNOMED CT\nEMDN\nIPS Absent and Unknown Data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.medicalDevices.identifier",
        "path" : "HDRPatientHistory.medicalHistory.medicalDevices.identifier",
        "short" : "A.2.6.1.2.2 - Device ID",
        "definition" : "Normalised identifier of the device instance such as UDI according to REGULATION (EU) 2017/745",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.medicalDevices.implantDate",
        "path" : "HDRPatientHistory.medicalHistory.medicalDevices.implantDate",
        "short" : "A.2.6.1.2.3 - Implant date",
        "definition" : "The date and time the device was implanted or when its use began.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.medicalDevices.endDate",
        "path" : "HDRPatientHistory.medicalHistory.medicalDevices.endDate",
        "short" : "A.2.6.1.2.4 - End date",
        "definition" : "Date and time when the device was explanted from the patient or the external device was no longer in use; likewise when the device is planned to be explanted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.medicalDevices.reason",
        "path" : "HDRPatientHistory.medicalHistory.medicalDevices.reason",
        "short" : "A.2.6.1.2.5 - Reason",
        "definition" : "The medical reason for use of the medical device.",
        "comment" : "ICD-10\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures",
        "short" : "A.2.6.1.3 - History of procedures",
        "definition" : "Historical procedures performed on or for a patient, relevant for the current encounter.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.procedureCode",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.procedureCode",
        "short" : "A.2.6.1.3.1 - Procedure code",
        "definition" : "Procedure code",
        "comment" : "SNOMED CT\nLOINC, NPU (for laboratory procedures)\nIPS Absent and Unknown Data",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.description",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.description",
        "short" : "A.2.6.1.3.2 - Procedure description",
        "definition" : "Narrative description of the procedure",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.bodySite",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.bodySite",
        "short" : "A.2.6.1.3.3 - Body site",
        "definition" : "Procedure target body site and laterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.date",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.date",
        "short" : "A.2.6.1.3.4 - Procedure date",
        "definition" : "Date and time when procedure was performed",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.reason",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.reason",
        "short" : "A.2.6.1.3.5 - Procedure reason",
        "definition" : "The coded reason why the procedure was performed. This may be a coded entity or may simply be present as text.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.outcome",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.outcome",
        "short" : "A.2.6.1.3.6 - Outcome",
        "definition" : "The outcome of the procedure - did it resolve the reasons for the procedure being performed? Applicable mainly on surgical procedures.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.historyOfProcedures.focalDevice",
        "path" : "HDRPatientHistory.medicalHistory.historyOfProcedures.focalDevice",
        "short" : "A.2.6.1.3.7 - Focal device",
        "definition" : "A reference to the device or devices that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableReference"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination",
        "path" : "HDRPatientHistory.medicalHistory.vaccination",
        "short" : "A.2.6.1.4 - Vaccination",
        "definition" : "Vaccination history of the patient.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.diseaseOrAgent",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.diseaseOrAgent",
        "short" : "A.2.6.1.4.1 - Disease or agent targeted",
        "definition" : "Disease or agent that the vaccination provides protection against",
        "comment" : "ICD-10*\nSNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.vaccine",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.vaccine",
        "short" : "A.2.6.1.4.2 - Vaccine/prophylaxis",
        "definition" : "Generic description of the vaccine/prophylaxis or its component(s)",
        "comment" : "SNOMED CT\nATC (IDMP/ EMA SPOR SMS)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.productName",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.productName",
        "short" : "A.2.6.1.4.4 - Vaccine medicinal product",
        "definition" : "Medicinal product name ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.manufacturerOrMAH",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.manufacturerOrMAH",
        "short" : "A.2.6.1.4.5 - Marketing Authorisation Holder ",
        "definition" : "Marketing Authorisation Holder or manufacturer (Identifier and name)",
        "comment" : "EMA's Organisations Management Service (EMA SPOR OMS)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.orderNumber",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.orderNumber",
        "short" : "A.2.6.1.4.6 - Number in a series of vaccinations / doses",
        "definition" : "Order in the vaccination course.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.vaccinationDate",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.vaccinationDate",
        "short" : "A.2.6.1.4.7 - Date of vaccination",
        "definition" : "The date and time when the vaccination was administered",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.vaccination.nextVaccinationDate",
        "path" : "HDRPatientHistory.medicalHistory.vaccination.nextVaccinationDate",
        "short" : "A.2.6.1.4.8 - Next vaccination date",
        "definition" : "The date when the vaccination is planned to be given/repeated (e.g. next dose)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory",
        "short" : "A.2.6.1.5 - Epidemiological history",
        "definition" : "Travel history and infectious contacts",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts",
        "short" : "A.2.6.1.5.1 - Infectious contacts",
        "definition" : "Infectious contacts of the patient",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.period",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.period",
        "short" : "A.2.6.1.5.1.1 - Time period",
        "definition" : "A date and duration or date time interval of contact. Partial dates are allowed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent",
        "short" : "A.2.6.1.5.1.2 - Infectious agent",
        "definition" : "Information about a suspected infectious agent or agents the person was exposed to.",
        "comment" : "ICD-10* (chapter 1)\nSNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity",
        "short" : "A.2.6.1.5.1.3 - Proximity",
        "definition" : "Proximity to the source/carrier of the infectious agent during exposure. Proximity could be expressed by text, code (direct, indirect) or value specifying distance from the InfectiousAgentCarrier.",
        "comment" : "SNOMED CT\nUCUM (measurement units)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.country",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.country",
        "short" : "A.2.6.1.5.1.4 - Country",
        "definition" : "Country in which the person was potentially exposed to an infectious agent.",
        "comment" : "ISO 3166",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.note",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.note",
        "short" : "A.2.6.1.5.1.5 - Additional information",
        "definition" : "A textual note with additional information about infectious contact.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory",
        "short" : "A.2.6.1.5.2 - Travel history",
        "definition" : "Travel history reported by the patient. Multiple records could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.period",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.period",
        "short" : "A.2.6.1.5.2.1 - Time period",
        "definition" : "Start and end date or end date and duration of stay in a country. Partial dates are allowed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.country",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.country",
        "short" : "A.2.6.1.5.2.2 - Country visited",
        "definition" : "A country visited by the patient.",
        "comment" : "ISO 3166",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.comment",
        "path" : "HDRPatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.comment",
        "short" : "A.2.6.1.5.2.3 - Comment",
        "definition" : "Relevant notes on the travel stay.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.familyHistory",
        "path" : "HDRPatientHistory.familyHistory",
        "short" : "A.2.6.2 - Family history",
        "definition" : "Information about serious illnesses in close blood relatives with known or suspected genetic potential or with possible impact on patient care.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.familyHistory.relationship",
        "path" : "HDRPatientHistory.familyHistory.relationship",
        "short" : "A.2.6.2.1 - Patient relationship",
        "definition" : "The family relation between the related person and the patient.",
        "comment" : "hl7:v3-RoleCode",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.familyHistory.birthDate",
        "path" : "HDRPatientHistory.familyHistory.birthDate",
        "short" : "A.2.6.2.2 - Date of birth",
        "definition" : "Full or partial date of birth",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.familyHistory.deathDateOrAge",
        "path" : "HDRPatientHistory.familyHistory.deathDateOrAge",
        "short" : "A.2.6.2.3 - Age or date of death",
        "definition" : "Age or date of the death of the family member.",
        "comment" : "Age or date of death",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.familyHistory.conditions",
        "path" : "HDRPatientHistory.familyHistory.conditions",
        "short" : "A.2.6.2.5 - Condition",
        "definition" : "Medical problems this person suffers or suffered.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.familyHistory.causeOfDeath",
        "path" : "HDRPatientHistory.familyHistory.causeOfDeath",
        "short" : "A.2.6.2.6 - Cause of death",
        "definition" : "Information about disease or condition that was the main cause of death.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants",
        "path" : "HDRPatientHistory.socialDeterminants",
        "short" : "A.2.6.3 - Social determinants of health",
        "definition" : "Information about social determinants of health. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.participationInSociety",
        "path" : "HDRPatientHistory.socialDeterminants.participationInSociety",
        "short" : "A.2.6.3.1 - Participation in society",
        "definition" : "Participation in society details.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.participationInSociety.workSituation",
        "path" : "HDRPatientHistory.socialDeterminants.participationInSociety.workSituation",
        "short" : "A.2.6.3.1.1 - Work situation",
        "definition" : "Work Situation describes the extent to which and in what way the patient participates in the workforce. Work is meant in the broadest sense of the word: activities that contribute to the person themselves, their environment or society. This includes both paid and unpaid work.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.participationInSociety.hobby",
        "path" : "HDRPatientHistory.socialDeterminants.participationInSociety.hobby",
        "short" : "A.2.6.3.1.2 - Hobby",
        "definition" : "An activity the patient enjoys doing in their free time.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.participationInSociety.socailNetwork",
        "path" : "HDRPatientHistory.socialDeterminants.participationInSociety.socailNetwork",
        "short" : "A.2.6.3.1.3 - Social network",
        "definition" : "A description of the patient’s social network, such as family, neighbours and friends.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.education",
        "path" : "HDRPatientHistory.socialDeterminants.education",
        "short" : "A.2.6.3.2 - Education",
        "definition" : "Education",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.education.level",
        "path" : "HDRPatientHistory.socialDeterminants.education.level",
        "short" : "A.2.6.3.2.1 - Education level",
        "definition" : "Indication of the highest level of education achieved.",
        "comment" : "hl7:v3.EducationLevel",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.education.comment",
        "path" : "HDRPatientHistory.socialDeterminants.education.comment",
        "short" : "A.2.6.3.2.2 - Comment",
        "definition" : "If deemed relevant, a specification of the degree program can be provided by means of an explanation (e.g.: patient is in medical school).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.livingSituation",
        "path" : "HDRPatientHistory.socialDeterminants.livingSituation",
        "short" : "A.2.6.3.3 - Living situation",
        "definition" : "Household type and other related living situation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.livingSituation.houseType",
        "path" : "HDRPatientHistory.socialDeterminants.livingSituation.houseType",
        "short" : "A.2.6.3.3.1 - House type",
        "definition" : "Type of home the patient lives in.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.livingSituation.homeAdaption",
        "path" : "HDRPatientHistory.socialDeterminants.livingSituation.homeAdaption",
        "short" : "A.2.6.3.3.2 - Home adaption",
        "definition" : "Adaptions present in the home that have been made in the context of the illness or disability to make the functioning of the patient safer and more comfortable and to enable independent living. Multiple data elements could be provided.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.livingSituation.livingConditions",
        "path" : "HDRPatientHistory.socialDeterminants.livingSituation.livingConditions",
        "short" : "A.2.6.3.3.3 - Living conditions",
        "definition" : "Conditions that affect the accessibility of the home or the stay in the home. Multiple data elements could be provided.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation",
        "short" : "A.2.6.3.4 - Family situation",
        "definition" : "Family situation details.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.comment",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.comment",
        "short" : "A.2.6.3.4.1 - Comment",
        "definition" : "A comment on the family situation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.familyComposition",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.familyComposition",
        "short" : "A.2.6.3.4.2 - Family composition",
        "definition" : "The family composition describes the patient’s home situation and the form of cohabitation.  ",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.maritalStatus",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.maritalStatus",
        "short" : "A.2.6.3.4.3 - Marital status",
        "definition" : "A person’s marital status according to the terms and definition in the national civil code.",
        "comment" : "hl7: v3-MaritalStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.numberOfChildren",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.numberOfChildren",
        "short" : "A.2.6.3.4.4 - Number of children",
        "definition" : "The number of children the patient has. Children in the context of this information model include step children, foster children, biological and adopted children.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.numberOfChildrenAtHome",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.numberOfChildrenAtHome",
        "short" : "A.2.6.3.4.5 - Number of children at home",
        "definition" : "The number of children living at home with the patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.childDetails",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.childDetails",
        "short" : "A.2.6.3.4.6 - Child details",
        "definition" : "Child age, co-living status and comment. Multiple child details could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.socialDeterminants.familySituation.careResponsibility",
        "path" : "HDRPatientHistory.socialDeterminants.familySituation.careResponsibility",
        "short" : "A.2.6.3.4.7 - Care responsibility",
        "definition" : "The activities the patient carries out to care for a dependent family member.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances",
        "path" : "HDRPatientHistory.useOfSubstances",
        "short" : "A.2.6.4 - Use of substances",
        "definition" : "Use of substances",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.alcohol",
        "path" : "HDRPatientHistory.useOfSubstances.alcohol",
        "short" : "A.2.6.4.1 - Alcohol use",
        "definition" : "Alcohol consumption by the patient. Multiple records on alcohol use could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.alcohol.currentStatus",
        "path" : "HDRPatientHistory.useOfSubstances.alcohol.currentStatus",
        "short" : "A.2.6.4.1.1 - Status",
        "definition" : "The status of the patient’s alcohol use.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.alcohol.periodAndQuantity",
        "path" : "HDRPatientHistory.useOfSubstances.alcohol.periodAndQuantity",
        "short" : "A.2.6.4.1.2 - Period and quantity",
        "definition" : "Period of use and amount (The extent of the patient’s alcohol use in units of alcohol per time period.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.alcohol.comment",
        "path" : "HDRPatientHistory.useOfSubstances.alcohol.comment",
        "short" : "A.2.6.4.1.3 - Comment",
        "definition" : "Textual comment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.tobacco",
        "path" : "HDRPatientHistory.useOfSubstances.tobacco",
        "short" : "A.2.6.4.2 - Tobacco use",
        "definition" : "Represent smoking or tobacco habits. Multiple records on tobacco use could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.tobacco.currentStatus",
        "path" : "HDRPatientHistory.useOfSubstances.tobacco.currentStatus",
        "short" : "A.2.6.4.2.1 - Status",
        "definition" : "The status of the patient’s tobacco use.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.tobacco.periodAndQuantity",
        "path" : "HDRPatientHistory.useOfSubstances.tobacco.periodAndQuantity",
        "short" : "A.2.6.4.2.2 - Period and quantity",
        "definition" : "Period of use and amount (The extent of the patient’s tobacco use in units of alcohol per time period.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.tobacco.comment",
        "path" : "HDRPatientHistory.useOfSubstances.tobacco.comment",
        "short" : "A.2.6.4.2.3 - Comment",
        "definition" : "Textual comment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.drugConsumption",
        "path" : "HDRPatientHistory.useOfSubstances.drugConsumption",
        "short" : "A.2.6.4.3 - Drug consumption",
        "definition" : "Consumption of drugs and other substances (in terms of abuse).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.drugConsumption.currentStatus",
        "path" : "HDRPatientHistory.useOfSubstances.drugConsumption.currentStatus",
        "short" : "A.2.6.4.3.1 - Status",
        "definition" : "The status of the patient’s drug use.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.drugConsumption.periodAndQuantity",
        "path" : "HDRPatientHistory.useOfSubstances.drugConsumption.periodAndQuantity",
        "short" : "A.2.6.4.3.2 - Period and quantity",
        "definition" : "Period of use and amount.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.drugConsumption.drugType",
        "path" : "HDRPatientHistory.useOfSubstances.drugConsumption.drugType",
        "short" : "A.2.6.4.3.3 - Drug or medication type",
        "definition" : "Type of the drug consumption",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.drugConsumption.route",
        "path" : "HDRPatientHistory.useOfSubstances.drugConsumption.route",
        "short" : "A.2.6.4.3.4 - Route of administration",
        "definition" : "Route or routes of administration ",
        "comment" : "EDQM Standard Terms",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRPatientHistory.useOfSubstances.drugConsumption.comment",
        "path" : "HDRPatientHistory.useOfSubstances.drugConsumption.comment",
        "short" : "A.2.6.4.3.5 - Comment",
        "definition" : "Textual comment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
