# WHO Disability Assessment Schedule 2.0 - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **WHO Disability Assessment Schedule 2.0**

## CodeSystem: WHO Disability Assessment Schedule 2.0 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/CodeSystem/whodas-20-cs | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:WHODAS20CS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
WHODAS 2.0 provides a common metric of the impact of any health condition in terms of functioning. HODAS 2.0 produces domain-specific scores for six different functioning domains – cognition, mobility, self-care, getting along, life activities (household and work) and participation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "whodas-20-cs",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/CodeSystem/whodas-20-cs",
  "version" : "0.1.0",
  "name" : "WHODAS20CS",
  "title" : "WHO Disability Assessment Schedule 2.0",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "WHODAS 2.0 provides a common metric of the impact of any health condition in terms of functioning. HODAS 2.0 produces domain-specific scores for six different functioning domains – cognition, mobility,\nself-care, getting along, life activities (household and work) and participation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 47,
  "concept" : [
    {
      "code" : "0",
      "display" : "None",
      "definition" : "No difficulty"
    },
    {
      "code" : "1",
      "display" : "Mild",
      "definition" : "Mild difficulty"
    },
    {
      "code" : "2",
      "display" : "Moderate",
      "definition" : "Moderate difficulty"
    },
    {
      "code" : "3",
      "display" : "Severe",
      "definition" : "Severe difficulty"
    },
    {
      "code" : "4",
      "display" : "Extreme",
      "definition" : "Extreme difficulty or cannot do"
    },
    {
      "code" : "D1",
      "display" : "Cognition",
      "definition" : "Domain 1 of WHODAS 2.0 asks questions about communication and thinking activities. Specific areas\nthat are assessed include concentrating, remembering, problem solving, learning and communicating.",
      "concept" : [
        {
          "code" : "D1.1",
          "display" : "Concentrating on doing something for ten minutes?",
          "definition" : "This question is intended to determine the respondent’s rating of difficulty with concentration for a short period, defined here as 10 minutes. Generally, respondents understand this item. However, if clarification is requested, encourage the respondent to think about their concentration in usual circumstances, rather than when they are preoccupied by a problem or are in an unusually distracting environment. If necessary, prompt the respondent to think about their concentration while they were doing something such as work tasks, reading, writing, drawing, playing a musical instrument, assembling a piece of equipment, and so on."
        },
        {
          "code" : "D1.2",
          "display" : "Remembering to do important things?",
          "definition" : "This is a question about remembering matters of day-to-day importance. It does not refer to remembering irrelevant content or detailed information from the past. Ask respondents how well they remember to do things that are important to them or to their family. If a respondent normally uses some form of memory aid – for example, note-taking, electronic reminder systems or verbal cueing from personal assistants – then rate their performance with this aid taken into consideration."
        },
        {
          "code" : "D1.3",
          "display" : "Analysing and finding solutions to problems in day-to-day life?",
          "definition" : "This item refers to a complex activity involving many mental functions. If respondents are unsure of what the item means, ask them to think about a problem they encountered in the past 30 days. Once a problem is identified, respondents should be asked to consider how well they:\n• identified that a problem existed\n• broke it down into manageable parts\n• developed a list of possible solutions\n• determined the pros and cons of each solution\n• determined the best solution given all considerations\n• executed and evaluated the chosen solution\n• selected an alternate solution if the first choice was not successful."
        },
        {
          "code" : "D1.4",
          "display" : "Learning a new task, for example, learning how to get to a new place?",
          "definition" : "In this question, learning a new route is offered as an example. If respondents ask for clarification or appear to be thinking only about learning how to get to a new place, encourage them to think of other situations in the past month where learning something new was required, such as:\n• a task at work (e.g. a new procedure or assignment)\n• school (e.g. a new lesson)\n• home (e.g. learning a new home-repair task)\n• leisure (e.g. learning a new game or craft).\nAsk respondents, when rating themselves, to consider how easily they acquired new information, how much assistance or repetition they needed in order to learn and how well they retained what they learned."
        },
        {
          "code" : "D1.5",
          "display" : "Generally understanding what people say?",
          "definition" : "Ask respondents to consider their usual mode of communication (e.g. spoken language, sign language, use of an assistive device such as a hearing aid, etc.) and rate the overall degree of difficulty they have in understanding the messages of others.Respondents should consider all situations they have encountered in the past 30 days, such as:\n• when others spoke quickly\n• when there was background noise\n• when there were distractions.\nDifficulties due to different mother tongues should be excluded when rating this question."
        },
        {
          "code" : "D1.6",
          "display" : "Starting and maintaining a conversation?",
          "definition" : "Rate both starting and maintaining a conversation. If respondents state that they have more\ntrouble starting than maintaining a conversation (or vice versa), ask them to average the amount\nof difficulty experienced with both activities to determine the final difficulty rating.\nConversation includes use of whatever is the usual mode of communication (spoken, written,\nsign language, gestural). If respondents normally use assistive devices for communication,\nensure that the difficulty rating provided takes into account conversation while using those\ndevices.\nAsk respondents to consider any and all other factors related to a health condition and relevant\nto them in starting and maintaining a conversation. Examples might include hearing loss,\nlanguage problems (e.g. as after a stroke), stuttering and anxiety"
        }
      ]
    },
    {
      "code" : "D2",
      "display" : "Mobility",
      "definition" : "Activities discussed in Domain 2 of WHODAS 2.0 include standing, moving around inside the home, getting out of the home and walking a long distance.",
      "concept" : [
        {
          "code" : "D2.1",
          "display" : "Standing for long periods such as 30 minutes?"
        },
        {
          "code" : "D2.2",
          "display" : "Standing up from sitting down?",
          "definition" : "This question refers to standing up from sitting in a chair, on a bench or a toilet. It does not refer to standing up from sitting on the floor."
        },
        {
          "code" : "D2.3",
          "display" : "Moving around inside your home?",
          "definition" : "This item refers to moving from room to room, and moving within rooms, using assistive devices\nor personal help that is usually in place. If a respondent lives in a house with multiple floors, this\nquestion also includes getting from one floor to another, as needed."
        },
        {
          "code" : "D2.4",
          "display" : "Getting out of your home?",
          "definition" : "This question seeks information about:\n• physical (mobility) aspects of getting out of the home\n• emotional or mental aspects of leaving the home (e.g. depression, anxiety, etc.)\nFor this question, “home” means the respondent’s current dwelling, which might be a house,\napartment, or nursing home."
        },
        {
          "code" : "D2.5",
          "display" : "Walking a long distance such as a kilometre?",
          "definition" : "Convert distances into imperial measure where necessary (e.g. older people may be more\nfamiliar with miles than with kilometres)."
        }
      ]
    },
    {
      "code" : "D3",
      "display" : "Self care",
      "definition" : "Domain 3 asks about bathing, dressing, eating and staying alone.",
      "concept" : [
        {
          "code" : "D3.1",
          "display" : "Washing your whole body?",
          "definition" : "This question refers to respondents washing their entire body in whatever manner is usual for\ntheir culture.\nIf respondents report that they have not washed their bodies in the past 30 days, ask whether\nthis is due to a health condition (as defined by WHODAS 2.0). If respondents report that it is due\nto a health condition, then code the item “5” for “Extreme or cannot do”. If respondents report\nthat the lack of washing is not due to a health condition, then code the item “N/A” for “Not\napplicable”."
        },
        {
          "code" : "D3.2",
          "display" : "Getting dressed?",
          "definition" : "This question includes all aspects of dressing the upper and lower body. Ask respondents to\nconsider activities such as gathering clothing from storage areas (i.e. closet, dressers) and\nsecuring buttons, tying knots, etc., when making the rating."
        },
        {
          "code" : "D3.3",
          "display" : "Eating?",
          "definition" : "This item refers to:\n• feeding oneself: that is, cutting food, and getting food or drink from a plate or glass to the\nmouth\n• swallowing both food and drink\n• mental or emotional factors that may contribute to difficulty in eating, such as anorexia,\nbulimia, or depression.\nThis item does not refer to meal preparation.\nIf a respondent uses non-oral feeding (e.g. tube feedings), this question refers to any difficulties\nexperienced in self-administering the non-oral feeding; for example, setting up and cleaning a\nfeeding pump."
        },
        {
          "code" : "D3.4",
          "display" : "Staying by yourself for a few days?",
          "definition" : "The intent of this question is to determine any difficulty respondents have in staying alone for an\nextended period and remaining safe. If respondents did not experience this situation in the past\n30 days, “N/A” is the correct rating.\nIf respondents give a rating of “None” for this question, probe the response to determine whether\nrespondents stayed by themselves without difficulty (in which case “1” is correct) or whether they\ndid not stay by themselves at all (in which case “N/A” is correct)."
        }
      ]
    },
    {
      "code" : "D4",
      "display" : "Getting along",
      "definition" : "Domain 4 assesses getting along with other people, and difficulties that might be encountered with this\ndue to a health condition. In this context, “people” may be those with whom the respondent is intimate\nor knows well (e.g. spouse or partner, family members or close friends), or those whom the respondent\ndoes not know at all (e.g. strangers).",
      "concept" : [
        {
          "code" : "D4.1",
          "display" : "Dealing with people you do not know?",
          "definition" : "This item refers to interactions with strangers in any situation, such as:\n• shop-keepers\n• service personnel\n• people from whom one is asking directions.\nWhen making the rating, ask respondents to consider both approaching such individuals, and\ninteracting successfully with them to obtain a desired outcome."
        },
        {
          "code" : "D4.2",
          "display" : "Maintaining a friendship?",
          "definition" : "This item includes:\n• staying in touch\n• interacting with friends in customary ways\n• initiating activities with friends\n• participating in activities when invited.\nRespondents will sometimes report that they have not engaged in friendship-maintenance\nactivities in the past 30 days. In this case, ask whether this situation is due to a health condition\n(as defined by WHODAS 2.0). If respondents report that it is due to a health condition, then code\nthe item “5” for “Extreme or cannot do”. If respondents report that it is not due to a health\ncondition, then code the item “N/A”."
        },
        {
          "code" : "D4.3",
          "display" : "Getting along with people who are close to you?",
          "definition" : "Ask respondents to consider any relationships that they define as close. These may be within or\noutside the family"
        },
        {
          "code" : "D4.4",
          "display" : "Making new friends?",
          "definition" : "This item includes:\n• seeking opportunities to meet new people\n• following up on invitations to get together\n• social and communication actions to make contact and to develop a friendship.\nOn occasion, participants will report that they have not engaged in friendship-making activities in\nthe past 30 days. In this case, interviewers should ask whether this is due to a health condition\n(as defined by the WHODAS 2.0). If respondents report that it is due to a health condition, then\ncode the item “5” for “Extreme or cannot do”. If respondents report that it is not due to a health\ncondition, then code the item “N/A”."
        },
        {
          "code" : "D4.5",
          "display" : "Sexual activities?",
          "definition" : "Ask respondents to think about what they consider to be sexual activities when answering this\nquestion. If asked for clarification, explain that this question refers to:\n• sexual intercourse\n• hugging\n• kissing\n• fondling\n• other intimate or sexual acts."
        }
      ]
    },
    {
      "code" : "D5",
      "display" : "Life activities",
      "definition" : "This domain includes questions about difficulty in day-to-day activities. These activities are those that\npeople do on most days; they include household, work and school activities.",
      "concept" : [
        {
          "code" : "D5.1",
          "display" : "Taking care of your household responsibilities?",
          "definition" : "This global question is intended to elicit respondents’ appraisal of any difficulty they encounter in\nmaintaining the household and in caring for family members or other people they are close to.\nAsk respondents to consider all types of household or family needs, including:\n• physical needs\n• emotional needs\n• financial needs\n• psychological needs.\nIn some cultures, males may indicate that they do not have household responsibilities. In this\nsituation, clarify that household responsibilities include:\n• managing finances\n• car and home repairs\n• caring for the outside area of the home\n• picking up children from school\n• helping with homework\n• disciplining children.\nAdd any other examples that elucidate household responsibilities held by males in the culture,\nas necessary.\nHere, “household” is defined broadly. In the case of participants who do not have a stable\ndwelling place, there are still activities surrounding the upkeep and maintenance of their\nbelongings. This question refers to those activities."
        },
        {
          "code" : "D5.2",
          "display" : "Doing most important household tasks well?"
        },
        {
          "code" : "D5.3",
          "display" : "Getting all the household work done that you needed to do?",
          "definition" : "Ask respondents to provide ratings based on their own appraisal of how well household tasks\nare completed and whether needed household work gets done. If necessary, remind\nrespondents that they are to report only difficulties due to the health condition, not those that\nmay be experienced for other reasons such as not having enough time (unless this reason is\nsomehow linked to a health condition)."
        },
        {
          "code" : "D5.4",
          "display" : "Getting your household work done as quickly as needed?",
          "definition" : "This question refers to the timely meeting of expectations and needs of those respondents\nwhom one lives with (or is close to), in relation to household tasks and responsibilities."
        },
        {
          "code" : "D5.5",
          "display" : "Your day-to-day work/school?",
          "definition" : "This global question is intended to elicit respondents’ appraisal of difficulties encountered in day-to-day work or school activities. This includes issues such as attending on time, responding to\nsupervision, supervising others, planning and organizing, meeting expectations in the workplace\nand any other relevant activities."
        },
        {
          "code" : "D5.6",
          "display" : "Doing your most important work/school tasks well?",
          "definition" : "Doing work or school tasks “well” refers to completing them as expected by a supervisor or\nteacher, by respondents’ own standards or as specified in the performance criteria for a job or\nschool."
        },
        {
          "code" : "D5.7",
          "display" : "Getting all the work done that you need to do?"
        },
        {
          "code" : "D5.8",
          "display" : "Getting your work done as quickly as needed?"
        }
      ]
    },
    {
      "code" : "D6",
      "display" : "Participation",
      "definition" : "Domain 6 represents a shift from the line of questioning used in the first five domains. In this domain,\nrespondents are asked to consider how other people and the world around them make it difficult for them\nto take part in society. Here, they are reporting not on their activity limitations but rather on the restrictions they experience from people, laws and other features of the world in which they find themselves.\nThe underlined phrases in the introduction must be emphasized to help respondents shift their mindset\nand understand what is being asked. Respondents need to understand that the focus of these questions\nis on problems encountered because of the society in which they live rather than because of their own\ndifficulties. This domain also includes questions about the impact of the health condition.\nThe introduction to this domain specifically reminds respondents that the focus of this interview is on the\npast 30 days. However, this particular domain does not readily lend itself to such a limited time frame;\ntherefore, it is important to ask respondents to attempt to remain focused on the 30-day reference period.",
      "concept" : [
        {
          "code" : "D6.1",
          "display" : "How much of a problem did you have joining in community activities (for example, festivities, religious or other activities) in the same way anyone else can?",
          "definition" : "If necessary, clarify this question using other examples of community activities, such as\nattending town meetings, fairs, leisure or sporting activities in the town, neighbourhood or\ncommunity. The relevant issue being asked in this question is whether respondents can\nparticipate in these activities or whether there are inhibitors to them doing so.\nIf respondents appear confused by the phrase “in the same way anyone else can”, ask them to\nuse their judgement to:\n• assess the extent to which average people in their community can join community activities;\nand\n• consider their personal level of difficulty in joining community activities in relation to the\nassessment."
        },
        {
          "code" : "D6.2",
          "display" : "How much of a problem did you have because of barriers or hindrances in the world around\nyou?",
          "definition" : "The intent of this question is to determine how much has stood in the way of respondents being\nable to realize aspirations and plans as other people can. The concept here is what\nrespondents face in terms of external interference created by the world or other people. Barriers\ncould be:\n• physical – for example, the lack of ramps to get into church; and\n• social – for example, laws that discriminate against people with disabilities and negative\nattitudes of other people that create barriers."
        },
        {
          "code" : "D6.3",
          "display" : "How much of a problem did you have living with dignity because of the attitudes and actions of\nothers?",
          "definition" : "Ask respondents to consider problems they have had in living with dignity or pride in who they\nare, what they are doing and how they live their lives."
        },
        {
          "code" : "D6.4",
          "display" : "How much time did you spend on your health condition, or its consequences?",
          "definition" : "This question seeks to capture an overall rating or snapshot of the portion of the past 30 days\nspent by respondents in dealing with any aspect of their health condition. This may include time\nspent in activities such as:\n• visiting a treatment centre;\n• managing financial matters related to their health condition, such as payment of bills,\nreimbursement of insurance or benefits; and\n• obtaining information about the health condition or in educating others about it."
        },
        {
          "code" : "D6.5",
          "display" : "How much have you been emotionally affected by your health condition?",
          "definition" : "This question refers to the degree to which respondents have felt an emotional impact due to\ntheir health condition. Emotions may include anger, sorrow, regret, thankfulness, appreciation, or\nany other positive or negative emotions."
        },
        {
          "code" : "D6.6",
          "display" : "How much has your health been a drain on the financial resources of you or your family?",
          "definition" : "Family is broadly defined to include relatives; however, it also includes those to whom\nrespondents are not related but consider to be like family, including those who may be sharing in\nthe financial aspects of the health condition. The focus of this question is on the depletion of\npersonal savings or current income to meet the needs created by a health condition. If\nrespondents have experienced a significant financial drain but their family has not, or vice versa,\nthey should respond to the question based on the drain experienced by either party."
        },
        {
          "code" : "D6.7",
          "display" : "How much of a problem did your family have because of your health problems?",
          "definition" : "The focus here is on problems created by the interaction of a respondent’s health condition with\nthe world in which the person lives. The question seeks information on problems that are borne\nby the family; these might include financial, emotional, physical problems, etc. The term “family”\nis defined above in D6.6."
        },
        {
          "code" : "D6.8",
          "display" : "How much of a problem did you have in doing things by yourself for relaxation or pleasure?",
          "definition" : "Ask respondents to consider leisure interests that they currently pursue and those they would\nlike to pursue but cannot due to the health condition and restrictions imposed by society.\nExamples might include a respondent who:\n• would like to read novels but is restricted from doing so because the local library does not\ncarry large-print books; and\n• enjoys watching movies but cannot do so because few are produced with subtitles for the\ndeaf.\nProvide an overall rating of problems encountered."
        }
      ]
    }
  ]
}

```
