# Xpandh Assessment Category - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh Assessment Category**

## CodeSystem: Xpandh Assessment Category 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/CodeSystem/assessment-category-xpandh-cs | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:AssessmentCategoryXpanDHCS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Category codes used in Xpandh Profiles such as the Xpandh Assessment Observation Profile. The are typically used when there is a need for categorization for searching and finding resources or workflow hints. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AssessmentObservationCategoryVS](ValueSet-assessment-observation-category-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "assessment-category-xpandh-cs",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/CodeSystem/assessment-category-xpandh-cs",
  "version" : "0.1.0",
  "name" : "AssessmentCategoryXpanDHCS",
  "title" : "Xpandh Assessment Category",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Category codes used in Xpandh Profiles such as the Xpandh Assessment Observation Profile. The are typically used when there is a need for categorization for searching and finding resources or workflow hints.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "sdoh",
      "display" : "SDOH",
      "definition" : "Social Determinants of Health category"
    },
    {
      "code" : "functional-status",
      "display" : "Functional Status",
      "definition" : "Functional Status category"
    },
    {
      "code" : "disability-status",
      "display" : "Disability Status",
      "definition" : "Disability Status category"
    },
    {
      "code" : "cognitive-status",
      "display" : "Cognitive Status",
      "definition" : "Cognitive Status category"
    }
  ]
}

```
