# Artifacts Summary - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### eHN HDR Guidelines 

Logical models representing the eHN HDR Guidelines

| | |
| :--- | :--- |
| [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) | Hospital Discharge Report Maturity Level: 0 Draft |
| [A.2.1 - Advance Directives (eHN)](StructureDefinition-HDRAdvanceDirectives.md) | Hospital Discharge Report - Advance Directives - A.2.1 eHN Maturity Level: 0 Draft |
| [A.2.2 - Alerts (eHN)](StructureDefinition-HDRAlerts.md) | Hospital Discharge Report - Alerts - A.2.2 eHN Maturity Level: 0 Draft |
| [A.2.3 - Encounter (eHN)](StructureDefinition-HDREncounter.md) | Hospital Discharge Report - Encounter - A.2.3 eHN Maturity Level: 0 Draft |
| [A.2.4 - Admission evaluation (eHN)](StructureDefinition-HDRAdmissionEvaluation.md) | Hospital Discharge Report - Admission evaluation - A.2.4 eHN Maturity Level: 0 Draft |
| [A.2.6 - Patient history (eHN)](StructureDefinition-HDRPatientHistory.md) | Hospital Discharge Report - Patient history - A.2.6 eHN Maturity Level: 0 Draft |
| [A.2.7 - Hospital stay (eHN)](StructureDefinition-HDRHospitalStay.md) | Hospital Discharge Report - Hospital stay - A.2.7 eHN Maturity Level: 0 Draft |
| [A.2.8 - Discharge details (eHN)](StructureDefinition-HDRDischargeDetails.md) | Hospital Discharge Report - Discharge details - A.2.8 eHN Maturity Level: 0 Draft |
| [A.2.9 - Care plan and other recommendations after discharge (eHN)](StructureDefinition-HDRRecommendations.md) | Hospital Discharge Report - Care plan and other recommendations after discharge - A.2.9 eHN Maturity Level: 0 Draft |

### Slovakia HDR 

Logical models representing the Slovakia Data set

| | |
| :--- | :--- |
| [Hospital Discharge Report (SK)](StructureDefinition-HospitalDischargeReportSK.md) | Hospital Discharge Report SK Maturity Level: 0 Draft |

### Logical Model mappings 

Concept Maps describing how the eHN Guidelines are supposed to be implemented by using this guide

| | |
| :--- | :--- |
| [Encounter to this guide](ConceptMap-ConceptMap-hdrEncounter2FHIR-eu-xpandh.md) | Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Bundle: EU Hospital Discharge Report](StructureDefinition-Bundle-hdr-xpandh.md) | Clinical document used to represent a Hospital Discharge Report for the scope of the XpanDH project. |
| [CareTeam](StructureDefinition-CareTeam-eu-xpandh.md) | This profile constrains the CareTeam resource for the purpose of the XpanDH project. |
| [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md) | Clinical document used to represent a Hospital Discharge Report (HDR) for the scope of the XpanDH project. |
| [Condition Xpandh Hospital Dischage Encounter](StructureDefinition-condition-encounter-hdr-xpandh.md) | This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge encounter resource. Encounter conditions implements Diagnostic summary part of the eHN data model adding two additional categories: First category distingueshes conditions present at admission and acquired during hospital stay (POA, HAC, NA - Not applicable or unknown) while second category is used to indicate impact of the condition to the treatement during hospital stay (treated, untreated). |
| [Condition Xpandh Profile](StructureDefinition-condition-hdr-xpandh.md) | This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge report. |
| [Coverage: Encounter Payer](StructureDefinition-coverage-hdr-eu-xpandh.md) | Coverage used to represent the payer for this Encounter for the scope of the XpanDH project. |
| [Device (Xpandh)](StructureDefinition-device-xpandh.md) | This profile represents the constraints applied to the Device resource by the Xpandh FHIR Implementation Guide, based on FHIR R4. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. |
| [Flag](StructureDefinition-Flag-eu-xpandh.md) | This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of the XpanDH project. |
| [Inpatient Encounter Xpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md) | This profile defines how to represent Inpatient Encounter in FHIR for the purpose of the XpanDH Hospital Discharge Report. |
| [Medication (Xpandh)](StructureDefinition-medication-xpandh.md) | This profile represents the constraints applied to the Medication resource by the Xpandh project FHIR Implementation Guide, based on FHIR R4. |
| [MedicationDispense Xpandh](StructureDefinition-MedicationDispense-hdr-eu-xpandh.md) | This profile constrains the MedicationDispense FHIR profile for the purpose of the XpanDH project. |
| [MedicationRequest](StructureDefinition-MedicationRequest-eu-xpandh.md) | This profile constrains the MedicationRequest IPS FHIR profile for the purpose of the XpanDH project. |
| [MedicationStatement](StructureDefinition-MedicationStatement-eu-xpandh.md) | This profile constrains the MedicationStatement IPS FHIR profile for the purpose of the XpanDH project. |
| [Observation Results](StructureDefinition-Observation-results-xpandh.md) | This profile constrains the Observation resource to represent various types of results and associated observations in a HDR. This is the base profile from which the other results profiles are derived. |
| [Observation Results: pathology](StructureDefinition-Observation-results-pathology-eu-xpandh.md) | This profile constrains the Observation resource to represent results produced by pathology studies for the XpanDH project. |
| [Observation Results: radiology](StructureDefinition-Observation-results-radiology-eu-xpandh.md) | This profile constrains the Observation resource to represent results produced by pathology studies for the XpanDH project. |
| [Observation: Cancer Stage Group](StructureDefinition-cancer-stage-group-hdr-xpandh.md) | The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen. |
| [Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md) | Category describing the extent of a tumor metastasis in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy. |
| [Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md) | Category of the primary tumor, based on its size and extent, based on evidence such as physical examination, imaging, and/or biopsy. |
| [Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md) | Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy. |
| [Patient: HDR](StructureDefinition-Patient-eu-xpandh.md) | This profile defines how to represent Patient in FHIR for the purpose of the XpanDH project. |
| [Practitioner](StructureDefinition-Practitioner-eu-xpandh.md) | This profile defines how to represent Practitioners in FHIR for the purpose of the XpanDH project. |
| [PractitionerRole](StructureDefinition-PractitionerRole-eu-xpandh.md) | This profile defines how to represent Practitioners (with thier roles) in FHIR for the purpose of the XpanDH project. |
| [Procedure (Xpandh)](StructureDefinition-Procedure-xpandh.md) | This profile represents the constraints applied to the Procedure resource by the Xpandh project. This profile is based on International patient Summary (IPS) procedure profile. |
| [ServiceRequest: Encounter Request](StructureDefinition-serviceRequest-hdr-eu-xpandh.md) | ServiceRequest used to represent a the request that triggered this HDR for the scope of the XpanDH project. Thsi is also used to link the HDR witht the payer |
| [Vital Signs Observation](StructureDefinition-observation-vital-signs-xpandh.md) | This profile constrains the Observation resource to represent various types of vital signs observations. This is the base profile from which the other specific vital sign profiles are derived. |
| [Xpandh Alergy Intolerance Profile](StructureDefinition-allergy-intolerance-xpandh.md) | This profile represents the constraints applied to the AllergyIntolerance resource by the Xpandh Hospital Discharge Report FHIR Implementation Guide.It documents the relevant allergies or intolerances (conditions) for a patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy. |
| [Xpandh Assessment Observation Profile](StructureDefinition-assessment-observation-xpandh.md) | This profile promotes interoperability and adoption through common implementation by setting minimum expectations for the Observation resource to record, search, and retrieve observations representing a practitioner's clinical observation or assertion about a patient's health status. These observations may or may not be associated with a formal survey, screening, or assessment tool. For example, a social history status such as education or food insecurity or an assessment of the patient's cognitive, functional, or disability status. This profile identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource when using this profile. It provides the floor for standards development for specific use cases. |
| [Xpandh BMI Profile](StructureDefinition-bmi-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch Body Mass Index (BMI) observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Blood Pressure Profile](StructureDefinition-blood-pressure-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch diastolic and systolic blood pressure observations with standard SNOMED CT codes and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Body Height Profile](StructureDefinition-body-height-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Body Temperature Profile](StructureDefinition-body-temperature-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Body Weight Profile](StructureDefinition-body-weight-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Circumference Measurement Profile](StructureDefinition-circumference-measurement-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Clinical Impression Profile](StructureDefinition-clinical-impression-hdr-xpandh.md) | This profile represents the constraints applied to the ClinicalImpression resource by the Xpandh FHIR Implementation Guide. |
| [Xpandh Condition Problems Profile](StructureDefinition-condition-problems-hdr-xpandh.md) | Xpandh Condition Problems Profile is based upon the core FHIR Condition Resource and meets the Xpandh project requirements. |
| [Xpandh Functional Status Observation Profile](StructureDefinition-functional-status-assessment-xpandh.md) | This profile promotes interoperability and adoption through common implementation by setting minimum expectations for the Functional Status Observation resource to record, search, and retrieve observations representing a practitioner's assertion about a patient's functional status. These observations may or may not be associated with a formal survey, screening, or assessment tool. For example, an assessment of the patient's cognitive, functional, or disability status. This profile identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource when using this profile. It provides the floor for standards development for specific use cases. |
| [Xpandh Heart Rate Profile](StructureDefinition-heart-rate-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Immunization Profile](StructureDefinition-immunization-xpandh.md) | This profile sets minimum expectations for the Immunization resource to record, search, and fetch immunization details. It is based on the Immunization profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Immunization resource when using this profile. |
| [Xpandh Infectious Contact Profile](StructureDefinition-infectious-contact-xpandh.md) | Infectious Contact profile represents potential patient exposure to an agent (exposure source). |
| [Xpandh Organization Profile](StructureDefinition-organization-expandh.md) | This profile sets minimum expectations for the Organization resource to searching for and fetching an Organization associated with a patient or provider to promote interoperability and adoption through common implementation. It identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource when using this profile. |
| [Xpandh Oxygen Saturation Profile](StructureDefinition-oxygen-saturation-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Pediatric Head Occipital Frontal Circumference Profile](StructureDefinition-pediatric-head-occ-front-circumfer-percent-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Respiratory Rate Profile](StructureDefinition-respiratory-rate-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh Skinfold Thickness Profile](StructureDefinition-skinfold-thickness-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh WHO Disability Assessment Schedule (WHODAS 2.0) Profile](StructureDefinition-whodas-assessment-xpandh.md) | This profile is an Xpandh implementation of World Health Organization Disability Assessment Schedule (WHODAS 2.0) resource to record, search, and retrieve observations representing a practitioner's assertion about a patient's functional status. This profile identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource when using this profile. It provides the floor for standards development for specific use cases. |
| [Xpandh social history Profile](StructureDefinition-social-history-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch social history. It is based on the ObservationResultsXpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |
| [Xpandh travel history Profile](StructureDefinition-travel-history-xpandh.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history. It is based on the ObservationResultsXpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Encounter Voluntary Status](StructureDefinition-encounter-voluntary-status.md) | This extension provides information about voluntary or involuntary nature of the encounter. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Admission Urgency Value Set](ValueSet-hdr-admission-urgency-xpandh-vs.md) | Hospital Discharge Report Admission Urgency value set includes selected codes from HL7 v3-ActPriority code system. |
| [Allergy Intolerance - Xpandh](ValueSet-allergy-intolerance-xpandh-vs.md) | Xpandh allergy intolerance codes value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 373873005 |Pharmaceutical / biologic product (product)|; all descendants of 105590001 |Substance (substance)|; all descendants of 418038007 |Propensity to adverse reactions to substance (finding)| plus codes for absent and unknown allergies. |
| [Allergy Intolerance Substances - Xpandh](ValueSet-allergy-intolerance-substances-xpandh-vs.md) | Xpandh allergy intolerance codes value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 373873005 |Pharmaceutical / biologic product (product)|; all descendants of 105590001 |Substance (substance)|; all descendants of 418038007 |Propensity to adverse reactions to substance (finding)|. |
| [Anthropometric Observation Value Set](ValueSet-anthropometric-observation-vs.md) | Anthropometric observation codes from the XpanDH anthropometric observations. |
| [BMI Observation Unit Value Set](ValueSet-bmi-observation-unit-vs.md) | Body mass index observation units for the XpanDH BMI observations. |
| [BMI Observation Value Set](ValueSet-bmi-observation-vs.md) | Body mass index observation codes from the XpanDH BMI observation. |
| [Body Height Observation Value Set](ValueSet-body-height-observation-vs.md) | Body height observation codes from the XpanDH body height observations. |
| [Body Weight Observation Value Set](ValueSet-body-weight-observation-vs.md) | Body weight observation codes from the XpanDH body weight observations. |
| [Body Weight Observation Value Set](ValueSet-body-weight-units-vs.md) | Body weight observation codes from the XpanDH body weight observations. |
| [Cancer Stage Grading: Snomed CT](ValueSet-cancer-stage-grading-vs.md) | Identifying codes based on the timing of classification for stage group observations. |
| [Cancer Stage Group: SNOMED CT](ValueSet-cancer-stageGroup-vs.md) | Identifying codes based on the timing of classification for stage group observations. |
| [Circumference Observation Value Set](ValueSet-circumference-observation-vs.md) | Circumference observation codes from the XpanDH Circumference observations. |
| [Clinical M](ValueSet-TNM-M-clinical-category-vs.md) | Distant metastazis (M) clinical category |
| [Clinical N](ValueSet-TNM-N-clinical-category-vs.md) | Regional lymph nodes (N) clinical category |
| [Clinical T](ValueSet-TNM-T-clinical-category-vs.md) | Primary tumor (T) clinical category |
| [Condition Present on Admission (POA) Value Set](ValueSet-hdr-poa-indicator-xpandh-vs.md) | Hospital Discharge Report Condition Present on Admission value set includes codes from Present on Admission code system. |
| [Condition Value Set](ValueSet-hdr-condition-xpandh-vs.md) | Hospital Discharge Report Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes). |
| [Encounter Class Value Set](ValueSet-hdr-encounterClass-xpandh-vs.md) | Hospital Discharge Report Encounter Class specifies a general class of inpatient encounter as being accute, nonaccute, emergency, short stay … |
| [Encounter Voluntary Status Value Set](ValueSet-admission-voluntary-status-vs.md) | Value set of voluntary nature of the encounter. |
| [Exposure of transmissible agents - Xpandh](ValueSet-exposure-agent-xpandh-vs.md) | Xpandh exposure agent value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 40733004 "Infectious disease (disorder)" and ICD-10 all descendants of chapter I: "Certain infectious and parasitic diseases" |
| [In-patient Encounter Type Value Set](ValueSet-encounter-status-vs-eu-hdr.md) | Hospital Discharge Report Encounter Type allows to classify encounter using general type of care provision regimen during the inpatient encounter. Value set includes concepts from the SNOMED CT descendants of 225351009 (Care provision regime) but needs to be further dicsussed |
| [In-patient Encounter Type Value Set](ValueSet-hdr-encounter-type-xpandh-vs.md) | Hospital Discharge Report Encounter Type allows to classify encounter using general type of care provision regimen during the inpatient encounter. Value set includes concepts from the SNOMED CT descendants of 225351009 (Care provision regime) but needs to be further dicsussed |
| [Mandatory Condition Value Set](ValueSet-hdr-condition-mandatory-xpandh-vs.md) | Hospital Discharge Report Mandatory Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes) and IPS Absent and Unknown Data. |
| [Medical Devices (SNOMED CT) - Xpandh](ValueSet-medical-devices-xpandh-vs.md) | This value set includes codes from SNOMED Clinical Terms®: all descendants of 49062001 |Device (physical object)|. |
| [Medical Devices - SNOMED CT + Absent/Unknown - IPS](ValueSet-medical-devices-snomed-absent-unknown-xpandh-vs.md) | This value set includes codes from SNOMED Clinical Terms (SNOMED CT®) that are included in: all descendants of 49062001 |Device (physical object)|, plus IPS codes for absent/unknown devices. |
| [Medications - SNOMED CT + Absent/Unknown (IPS)](ValueSet-medication-snomed-absent-unknown-uv-ips.md) | This value set includes the codes from SNOMED CT that are included in: descendants of 373873005 |Pharmaceutical / biologic product (product)|, excluding the descendants of 787859002 |Vaccine product (medicinal product)|, plus IPS codes for absent/unknown medications. |
| [Observation Codes for Distant Metastases Category](ValueSet-mcode-observation-codes-distant-metastases-vs.md) | Identifying codes based on the timing of classification for distant metastases (M) staging observations. |
| [Observation Codes for Primary Tumor Category](ValueSet-mcode-observation-codes-primary-tumor-vs.md) | Identifying codes based on the timing of classification for primary tumor (T) staging observations. |
| [Observation Codes for Regional Node Category](ValueSet-mcode-observation-codes-regional-nodes-vs.md) | Identifying codes based on the timing of classification for regional node (N) staging observations. |
| [Pathological M](ValueSet-TNM-M-pathologycal-category-vs.md) | Distant metastazis (M) pathological category |
| [Pathological N](ValueSet-TNM-N-pathological-category-vs.md) | Regional lymph nodes (N) pathological category |
| [Pathological T](ValueSet-TNM-T-pathological-category-vs.md) | Primary tumor (T) pathological category |
| [Primary tumor T](ValueSet-TNM-T-category-vs.md) | Primary tumor (T) category |
| [Procedure codes: Snomed CT](ValueSet-procedure-snomed-xpandh-vs.md) | This value set includes codes from SNOMED Clinical Terms®: descendants of 71388002 |Procedure (procedure)|, excluding [all subtypes of 14734007 |Administrative procedure (procedure)|, all subtypes of 59524001 |Blood bank procedure (procedure)|, all subtypes of 389067005 |Community health procedure (procedure)|, all subtypes of 442006003 |Determination of information related to transfusion (procedure)|, all subtypes of 225288009 |Environmental care procedure (procedure)|, all subtypes of 308335008 |Patient encounter procedure (procedure)|, all subtypes of 710135002 |Promotion (procedure)|, all subtypes of 389084004 |Staff related procedure (procedure)|]. |
| [Procedures - SNOMED CT + Absent/Unknown - IPS](ValueSet-procedures-snomed-absent-unknown-xpandh-vs.md) | This value set includes codes from SNOMED Clinical Terms®: descendants of 71388002 |Procedure (procedure)|, excluding [all subtypes of 14734007 |Administrative procedure (procedure)|, all subtypes of 59524001 |Blood bank procedure (procedure)|, all subtypes of 389067005 |Community health procedure (procedure)|, all subtypes of 442006003 |Determination of information related to transfusion (procedure)|, all subtypes of 225288009 |Environmental care procedure (procedure)|, all subtypes of 308335008 |Patient encounter procedure (procedure)|, all subtypes of 710135002 |Promotion (procedure)|, all subtypes of 389084004 |Staff related procedure (procedure)|], plus IPS codes for absent/unknown procedures. |
| [Skinfold Thickness Units Value Set](ValueSet-skinfold-thickness-units-vs.md) | Skinfold Thickness observation units for the XpanDH Skinfold Thickness observations. |
| [Skinfold Thickness Value Set](ValueSet-skinfold-thickness-vs.md) | Skinfold Thickness observation codes from the XpanDH Skinfold Thickness observations. |
| [Social history observation codes: Snomed CT](ValueSet-socail-history-observations-xpandh-vs.md) | This value set includes selected codes from SNOMED Clinical Terms® |
| [TNM M Category](ValueSet-TNM-M-category-vs.md) | Distant metastazis (M) category |
| [TNM N Category](ValueSet-TNM-N-category-vs.md) | Regional lymph nodes (N) category |
| [Treatment Class Value Set](ValueSet-hdr-treated-xpandh-vs.md) | Value set for category of treatement of the conditoin during encounter. |
| [Vital Signs Observation Value Set](ValueSet-vital-signs-observation-vs.md) | The vital sign obsevrvation codes from the XpanDH Vital Signs. |
| [Xpandh Assessment Observation Category](ValueSet-assessment-observation-category-vs.md) | Used to classify the context of a survey, screening or assessment for assessment observations and may be used to assist with indexing and searching for appropriate instances. |
| [Xpandh Functional Assessment Scales](ValueSet-functional-assessment-scales-vs.md) | Used to specify type of functional assessment scale. May be used to assist with indexing and searching for appropriate instances. |
| [Xpandh Immunization Target Disease or Agent](ValueSet-immunization-target-vs.md) | Vaccine preventable disease being targeted. Value set includes selected codes from recommended EU code systems for disease or agent that the vaccination provides protection against (WHO-ICD-10, SNOMED CT). All WHO-ICD-10 and SNOMED CT codes from disease hierarchy are included. |
| [Xpandh WHODAS Codes Valueset](ValueSet-whodas-code-vs.md) | Used to specify WHODAS Disability Assessment Schedule 2.0 assessment codes. |
| [Xpandh WHODAS Domain Valueset](ValueSet-whodas-domain-vs.md) | Used to specify WHODAS Disability Assessment Schedule 2.0 assessment domains. |
| [Xpandh WHODAS Result Valueset](ValueSet-whodas-result-vs.md) | Used to specify WHODAS Disability Assessment Schedule 2.0 functional assessment result codes. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Present on Admission (POA) Indicator](CodeSystem-poa-indicator-xpandh-cs.md) | Present on Admission (POA) indicators |
| [WHO Disability Assessment Schedule 2.0](CodeSystem-whodas-20-cs.md) | WHODAS 2.0 provides a common metric of the impact of any health condition in terms of functioning. HODAS 2.0 produces domain-specific scores for six different functioning domains – cognition, mobility, self-care, getting along, life activities (household and work) and participation. |
| [Xpandh Assessment Category](CodeSystem-assessment-category-xpandh-cs.md) | Category codes used in Xpandh Profiles such as the Xpandh Assessment Observation Profile. The are typically used when there is a need for categorization for searching and finding resources or workflow hints. |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [eHN HDR header metadata to this guide Map](ConceptMap-ConceptMap-HeaderMeta2FHIR-eu-xpandh.md) | eHN eHN HDR header metadata Model to this guide mapping |
| [eHN Recipient to this guide Map](ConceptMap-ConceptMap-HeaderParticipants2FHIR-eu-xpandh.md) | eHN HDR Encounter Model to this guide mapping |
| [eHN Recipient to this guide Map](ConceptMap-ConceptMap-hdrHeader2FHIR-eu-xpandh.md) | eHN HDR Encounter Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Mracena](Patient-Mracena.md) | Example of Slovak patient |
| [SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md) | Slovak hospital - example of a health provider organization |
| [SK-Organization-GP](Organization-SK-Organization-GP.md) | Slovak general practitioner example |
| [SK-Organization-Hospital](Organization-SK-Organization-Hospital.md) | Slovak hospital - example of a health provider organization |
| [SK-Organization-Hospital-Department-1](Organization-SK-Organization-Hospital-Department-1.md) | Example of Slovak hospital department |
| [SK-Practitioner-1](Practitioner-SK-Practitioner-1.md) | Zdravotnický pracovník id(NRZP)=123456789 |
| [SK-Practitioner-2](Practitioner-SK-Practitioner-2.md) | SK Practitioner id=987654321 |
| [example-it-1](Patient-example-it-1.md) |  |
| [example-it-1-1](Immunization-example-it-1-1.md) |  |
| [example-it-1-2](Immunization-example-it-1-2.md) |  |
| [org-example-it](Organization-org-example-it.md) |  |

