# Vital Signs Observation Value Set - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vital Signs Observation Value Set**

## ValueSet: Vital Signs Observation Value Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/vital-signs-observation-vs | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:AllVitalSignsObservationVS |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | | |

 
The vital sign obsevrvation codes from the XpanDH Vital Signs. 

 **References** 

* [Vital Signs Observation](StructureDefinition-observation-vital-signs-xpandh.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT International edition 01-Feb 2025
* [valueset Anthropometric Observation Value Set v0.1.0 (ValueSet)](ValueSet-anthropometric-observation-vs.md)
* [valueset BMI Observation Value Set v0.1.0 (ValueSet)](ValueSet-bmi-observation-vs.md)
* [valueset Body Height Observation Value Set v0.1.0 (ValueSet)](ValueSet-body-height-observation-vs.md)
* [valueset Body Weight Observation Value Set v0.1.0 (ValueSet)](ValueSet-body-weight-observation-vs.md)
* [valueset Circumference Observation Value Set v0.1.0 (ValueSet)](ValueSet-circumference-observation-vs.md)
* [valueset Skinfold Thickness Value Set v0.1.0 (ValueSet)](ValueSet-skinfold-thickness-vs.md)

This value set expansion contains 24 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vital-signs-observation-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/vital-signs-observation-vs",
  "version" : "0.1.0",
  "name" : "AllVitalSignsObservationVS",
  "title" : "Vital Signs Observation Value Set",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "The vital sign obsevrvation codes from the XpanDH Vital Signs.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/anthropometric-observation-vs"
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "364075005",
            "display" : "Heart rate (observable entity)"
          },
          {
            "code" : "86290005",
            "display" : "Respiratory rate (observable entity)"
          },
          {
            "code" : "75367002",
            "display" : "Blood pressure (observable entity)"
          },
          {
            "code" : "386725007",
            "display" : "Body temperature (observable entity)"
          },
          {
            "code" : "103228002",
            "display" : "Hemoglobin saturation with oxygen (observable entity)"
          }
        ]
      }
    ]
  }
}

```
