# Xpandh Functional Assessment Scales - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh Functional Assessment Scales**

## ValueSet: Xpandh Functional Assessment Scales 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/functional-assessment-scales-vs | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:FunctionalAssessmentScalesVS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Used to specify type of functional assessment scale. May be used to assist with indexing and searching for appropriate instances. 

 **References** 

* [Xpandh Functional Status Observation Profile](StructureDefinition-functional-status-assessment-xpandh.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 3 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "functional-assessment-scales-vs",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/functional-assessment-scales-vs",
  "version" : "0.1.0",
  "name" : "FunctionalAssessmentScalesVS",
  "title" : "Xpandh Functional Assessment Scales",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Used to specify type of functional assessment scale. May be used to assist with indexing and searching for appropriate instances.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "719091001",
            "display" : "World Health Organization Disability Assessment Schedule 2.0 (assessment scale)"
          },
          {
            "code" : "273302005",
            "display" : "Barthel index (assessment scale)"
          },
          {
            "code" : "443364002",
            "display" : "Modified Barthel index of activities of daily living (assessment scale)"
          }
        ]
      }
    ]
  }
}

```
