# Xpandh travel history Profile - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh travel history Profile**

## Resource Profile: Xpandh travel history Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/travel-history-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:TravelHistoryXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history. It is based on the ObservationResultsXpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. 

**Usages:**

* Refer to this Profile: [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/travel-history-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-travel-history-xpandh.csv), [Excel](StructureDefinition-travel-history-xpandh.xlsx), [Schematron](StructureDefinition-travel-history-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "travel-history-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/travel-history-xpandh",
  "version" : "0.1.0",
  "name" : "TravelHistoryXpandh",
  "title" : "Xpandh travel history Profile",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history. It is based on the ObservationResultsXpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Observation-results-xpandh",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Skinfold Thickness Profile"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "420008001"
            }
          ]
        }
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "Date or period of visit in a country",
        "definition" : "The date or period of visit in a country."
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Country visited",
        "definition" : "The country visited.",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/iso3166-1-2"
        }
      }
    ]
  }
}

```
