# Xpandh Immunization Profile - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh Immunization Profile**

## Resource Profile: Xpandh Immunization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/immunization-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:ImmunizationXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile sets minimum expectations for the Immunization resource to record, search, and fetch immunization details. It is based on the Immunization profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Immunization resource when using this profile. 

**Usages:**

* Refer to this Profile: [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/immunization-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-immunization-xpandh.csv), [Excel](StructureDefinition-immunization-xpandh.xlsx), [Schematron](StructureDefinition-immunization-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "immunization-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/immunization-xpandh",
  "version" : "0.1.0",
  "name" : "ImmunizationXpandh",
  "title" : "Xpandh Immunization Profile",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Immunization resource to record, search, and fetch immunization details. It is based on the Immunization profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Immunization resource when using this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization",
        "short" : "Immunization Profile"
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "short" : "Vaccine that was administered or was to be administered.Several kinds of vaccine product coding could be provided.\r\n\r\n     The IPS assumes that either the type of the vaccine for particular disease or diseases (e.g. MMR vaccine) against which the patient has been immunised is provided; or the known absent / unknown code.\r\n\r\n     Other coded information can be provided as well as: the IDMP Pharmaceutical Product Identifiers (PhPID), Medicinal Product Identifier (MPID), Packaged Medicinal Product Identifier (PCID), when available, or equivalent coded concepts; the WHO ATC codes; or any other kind of code that that identifies, classifies or cluster the administered product.",
        "definition" : "Vaccine that was administered or was to be administered. Several kinds of vaccine product coding could be provided.\r\nThe IPS assumes that either the type of the vaccine for particular disease or diseases (e.g. MMR vaccine) against which the patient has been immunized is provided; or the known absent / unknown.\r\n\r\nOther coded information can be provided as well as:\r\n\r\n- The IDMP Pharmaceutical Product Identifier (PhPID), Level 1, [Substance(s)]. Example: Amoxicillin and Clavulanate Potassium; or any other equivalent coded concept.\r\n- The IDMP Pharmaceutical Product Identifier (PhPID), Level 2 [Substance(s) + Strength + reference strength]. Example: Amoxicillin 875 mg and Clavulanate Potassium 125 mg; or any other equivalent coded concept.\r\n- The IDMP Pharmaceutical Product Identifier (PhPID), Level 3 [Substance(s) + administrable dose form]. Example: Amoxicillin and Clavulanate Potassium, Oral Tablet; or any other equivalent coded concept.\r\n- The IDMP Pharmaceutical Product Identifier (PhPID), Level 4 [Substance(s) + strength + reference strength + administrable dose form]. Example: Amoxicillin 875 mg and clavulanate potassium 125 mg, oral tablet; or any other equivalent coded concept.\r\n- The IDMP Medicinal Product Identifier (MPID) or any equivalent Medicinal Product Identifier. IDMP MPID uniquely identifies a Medicinal Product, reflecting (but not replacing) any other authorization numbers allocated by a regulator. MPID implies one (set of) PhPID. The MPID shall use a common segment pattern related to a Medicinal Product, which, when each segment is valued shall define a specific MPID concept.\r\n- The IDMP Packaged Medicinal Product Identifier (PCID) or any equivalent Packaged Medicinal Product Identifier. Uniquely identifies a Medicinal Product based on its packaging. This implies one MPID can be associated with more than one PCID, if the same Medicinal Product has more than one type of package.\r\n- Any other kind of code that that identifies, classifies or clusters the administered product (e.g. the medicinal product or the product class).\r\n\r\nThe value sets used for the PhPID, MPID and PCID identifiers are provisional and include only few equivalent concepts used for exemplification purposes, they will be updated with real IDMP identifiers when they will become available.",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-whoatc-uv-ips"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to a vaccines value set from the WHO ATC code system for use in specific jurisdictional or other contexts where use of the ATC terminology is preferred."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "For when WHO ATC code system is preferred"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "The type of vaccine for particular disease or diseases against which the patient has been immunised, or a code for absent/unknown immunization.",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-uv-ips"
        }
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.patient.reference",
        "path" : "Immunization.patient.reference",
        "min" : 1
      },
      {
        "id" : "Immunization.occurrence[x].extension:data-absent-reason",
        "path" : "Immunization.occurrence[x].extension",
        "sliceName" : "data-absent-reason",
        "short" : "occurrence[x] absence reason",
        "definition" : "Provides a reason why the occurrence is missing.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/data-absent-reason"]
          }
        ]
      },
      {
        "id" : "Immunization.site",
        "path" : "Immunization.site",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SNOMEDCTBodyStructures"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Immunization.route",
        "path" : "Immunization.route",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ImmunizationRoute"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/medicine-route-of-administration"
        }
      },
      {
        "id" : "Immunization.performer.actor",
        "path" : "Immunization.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.protocolApplied.targetDisease",
        "path" : "Immunization.protocolApplied.targetDisease",
        "short" : "Vaccine preventable disease being targeted",
        "definition" : "The particular disease against which the patient has been immunized.\r\n\r\nAdditional conformance bindings provided for use for this element in specific (jurisdictional or other) contexts include (these bindings are represented in the StructureDefinition as instances of the [elementdefinition-additionalBinding](http://hl7.org/fhir/tools/StructureDefinition/additional-binding) extension):\r\n- [targetDiseases-uv-ips](./ValueSet-target-diseases-uv-ips.html)",
        "binding" : {
          "strength" : "preferred",
          "description" : "The particular disease or diseases against which the patient has been immunized.",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/immunization-target-vs"
        }
      }
    ]
  }
}

```
