# Condition Xpandh Profile - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Xpandh Profile**

## Resource Profile: Condition Xpandh Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-hdr-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:ConditionHdrXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge report. 

**Usages:**

* Derived from this Profile: [Condition Xpandh Hospital Dischage Encounter](StructureDefinition-condition-encounter-hdr-xpandh.md) and [Xpandh Condition Problems Profile](StructureDefinition-condition-problems-hdr-xpandh.md)
* Refer to this Profile: [CareTeam](StructureDefinition-CareTeam-eu-xpandh.md), [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md), [MedicationStatement](StructureDefinition-MedicationStatement-eu-xpandh.md), [Observation: Cancer Stage Group](StructureDefinition-cancer-stage-group-hdr-xpandh.md)...Show 4 more,[Xpandh Clinical Impression Profile](StructureDefinition-clinical-impression-hdr-xpandh.md),[Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md),[Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/condition-hdr-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-condition-hdr-xpandh.csv), [Excel](StructureDefinition-condition-hdr-xpandh.xlsx), [Schematron](StructureDefinition-condition-hdr-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "condition-hdr-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-hdr-xpandh",
  "version" : "0.1.0",
  "name" : "ConditionHdrXpandh",
  "title" : "Condition Xpandh Profile",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge report.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.text",
        "path" : "Condition.text",
        "definition" : "Human readable specification of the problem. This is a general notes/comments entry for description of the problem, its diagnosis and prognosis.",
        "min" : 1
      },
      {
        "id" : "Condition.identifier",
        "path" : "Condition.identifier",
        "definition" : "Globally unique identifier of this problem which remain constant as the resource is updated and propagates from server to server."
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "definition" : "The problem status describes the condition of the problem:\n\r\n1.\tActive problems are problems of which the patient experiences symptoms or for which evidence exists.\n\r\n2.\tIf condition is abated, then clinicalStatus must be either inactive, resolved, or remission. \n\r\n3.\tProblems with the status 'Inactive' refer to problems that don't affect the patient anymore or that of which there is no evidence of existence anymore.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-clinical"
        }
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "definition" : "The verification status to support the clinical status of the condition.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-ver-status"
        }
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "definition" : "The type of problem; see the concept description."
      },
      {
        "id" : "Condition.severity",
        "path" : "Condition.severity",
        "definition" : "A subjective assessment of the severity of the condition as evaluated by the clinician."
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "definition" : "The problem code specifies the problem. Depending on the setting, different code systems can be used. The ProblemCodelist provides an overview of the possible code systems.",
        "binding" : {
          "strength" : "required",
          "description" : "Valueset to describe the actual problem experienced by the patient",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-condition-xpandh-vs"
        }
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "definition" : "Anatomical location which is the focus of the problem."
      },
      {
        "id" : "Condition.bodySite.extension:laterality",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "laterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-laterality-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.onset[x]:onsetDateTime",
        "path" : "Condition.onset[x]",
        "sliceName" : "onsetDateTime",
        "definition" : "Onset of the symptom, complaint, functional limitation, complication or date of diagnosis. A ‘vague’ date, such as only the year or the month and the year, is permitted.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.abatement[x]",
        "path" : "Condition.abatement[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.abatement[x]:abatementDateTime",
        "path" : "Condition.abatement[x]",
        "sliceName" : "abatementDateTime",
        "definition" : "The date or estimated date that the condition resolved or went into remission. A ‘vague’ date, such as only the year or the month and the year, is permitted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.recordedDate",
        "path" : "Condition.recordedDate",
        "definition" : "Date (and time) when this problem was recorded into information system.",
        "mustSupport" : true
      },
      {
        "id" : "Condition.recorder",
        "path" : "Condition.recorder",
        "definition" : "A healthcare professional who authored information about the problem."
      },
      {
        "id" : "Condition.stage.summary",
        "path" : "Condition.stage.summary",
        "short" : "Most recent Stage Group",
        "definition" : "As for mCODE, in IDEA4RC staging information MUST be captured in an Observation that conforms to the CancerStageGroup profile. For convenience, the stage group MAY appear in this element, copied from the CancerStageGroup, but Data Senders and Receivers MAY ignore it.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/cancer-stage-grading-vs"
        }
      },
      {
        "id" : "Condition.stage.assessment",
        "path" : "Condition.stage.assessment",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/cancer-stage-group-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Condition.stage.type",
        "path" : "Condition.stage.type",
        "short" : "Staging system used.",
        "definition" : "As for mCODE, in IDEA4RC staging information MUST be captured in an Observation that conforms to the CancerStageGroup profile. For convenience, the staging system MAY appear in this element, but Data Senders and Receivers MAY ignore it."
      },
      {
        "id" : "Condition.note",
        "path" : "Condition.note",
        "definition" : "Comment by the one who determined or updated the Problem."
      }
    ]
  }
}

```
