# Observation: Cancer Stage Group - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation: Cancer Stage Group**

## Resource Profile: Observation: Cancer Stage Group 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/cancer-stage-group-hdr-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:CancerStageGroupHdrXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen. 

**Usages:**

* Refer to this Profile: [Condition Xpandh Profile](StructureDefinition-condition-hdr-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/cancer-stage-group-hdr-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cancer-stage-group-hdr-xpandh.csv), [Excel](StructureDefinition-cancer-stage-group-hdr-xpandh.xlsx), [Schematron](StructureDefinition-cancer-stage-group-hdr-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cancer-stage-group-hdr-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/cancer-stage-group-hdr-xpandh",
  "version" : "0.1.0",
  "name" : "CancerStageGroupHdrXpandh",
  "title" : "Observation: Cancer Stage Group",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "The status of the result"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "What was observed",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/cancer-stageGroup-vs"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Observation.focus",
        "path" : "Observation.focus",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "Clinically relevant time for observation"
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Actual result.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/cancer-stageGroup-vs"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "short" : "ADD BINDING"
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile",
        "max" : "0"
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile",
        "max" : "0"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.resolve().code"
            }
          ],
          "description" : "Slicing based on referenced resource code attribute.",
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ]
      },
      {
        "id" : "Observation.hasMember:tnmPrimaryTumorCategory",
        "path" : "Observation.hasMember",
        "sliceName" : "tnmPrimaryTumorCategory",
        "short" : "TNM Primary Tumor Category",
        "definition" : "Category of the primary tumor, based on its size and extent, and based on evidence such as physical examination, imaging, and/or biopsy.",
        "comment" : "When using this element, the Observation must validate against the specified profile.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/mcode-tnm-primary-tumor-category"
            ]
          }
        ]
      },
      {
        "id" : "Observation.hasMember:tnmRegionalNodesCategory",
        "path" : "Observation.hasMember",
        "sliceName" : "tnmRegionalNodesCategory",
        "short" : "TNM  Regional Nodes Category",
        "definition" : "Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy.",
        "comment" : "When using this element, the Observation must validate against the specified profile.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/mcode-tnm-regional-nodes-category"
            ]
          }
        ]
      },
      {
        "id" : "Observation.hasMember:tnmDistantMetastasesCategory",
        "path" : "Observation.hasMember",
        "sliceName" : "tnmDistantMetastasesCategory",
        "short" : "TNM  Distant Metastases Category",
        "definition" : "Category describing the presence or absence of metastases in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy.",
        "comment" : "When using this element, the Observation must validate against the specified profile.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/mcode-tnm-distant-metastases-category"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile",
        "max" : "0"
      }
    ]
  }
}

```
