# A.2.7 - Hospital stay (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.7 - Hospital stay (eHN)**

## Logical Model: A.2.7 - Hospital stay (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRHospitalStay | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNHospitalStay |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Hospital stay - A.2.7 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRHospitalStay)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRHospitalStay.csv), [Excel](StructureDefinition-HDRHospitalStay.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRHospitalStay",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRHospitalStay",
  "version" : "0.1.0",
  "name" : "HdrEHNHospitalStay",
  "title" : "A.2.7 - Hospital stay (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Hospital stay - A.2.7 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRHospitalStay",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRHospitalStay",
        "path" : "HDRHospitalStay",
        "short" : "A.2.7 - Hospital stay (eHN)",
        "definition" : "Hospital Discharge Report - Hospital stay - A.2.7 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary",
        "path" : "HDRHospitalStay.diagnosticSummary",
        "short" : "A.2.7.1 - Diagnostic summary",
        "definition" : "All problems/diagnoses that affect care during the inpatient case or are important to be recorded to ensure continuity of care. The diagnostic summary differentiates, in accordance with the international recommendation, between problems treated during hospital stay and other (untreated) problems. Treated problems are problems that were the subject of diagnostics, therapy, nursing, or (continuous) monitoring during the hospitalisation. Furthermore problems could be divided into three categories: problems present on admission (POA), conditions acquired during hospital stay (HAC) and problems that cannot be classified as being of any of the two (N/A). The diagnostic summary contains all conditions as they were recognised at the end of hospitalisation, after all examinations. This section contains concise, well specified, codeable, summary of problems. Problems are ordered by importance (main problems first) during hospital stay. Description of the problem might be completed with additional details in the medical history section and/or in the Synthesis section.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.problemDescription",
        "path" : "HDRHospitalStay.diagnosticSummary.problemDescription",
        "short" : "A.2.7.1.1 - Problem description",
        "definition" : "Problem specification in narrative form",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.problemDetails",
        "path" : "HDRHospitalStay.diagnosticSummary.problemDetails",
        "short" : "A.2.7.1.2 - Problem details",
        "definition" : "Problem details include code that identifies problem, specification of the body structure, laterality, and other aspects of the problem.",
        "comment" : "ICD-10*\nSNOMED CT\nICD-O-3\nOrphacode if rare disease is diagnosed IPS Absent and Unknown Data",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.onsetDate",
        "path" : "HDRHospitalStay.diagnosticSummary.onsetDate",
        "short" : "A.2.7.1.3 - Onset date",
        "definition" : "Onset date of a problem/condition",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.endDate",
        "path" : "HDRHospitalStay.diagnosticSummary.endDate",
        "short" : "A.2.7.1.4 - End date",
        "definition" : "The date or estimated date that the condition resolved or went into remission.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.category",
        "path" : "HDRHospitalStay.diagnosticSummary.category",
        "short" : "A.2.7.1.5 - Category",
        "definition" : "Category of the problem allows flagging for conditions acquired during hospital stay.",
        "comment" : "- Present on admission [POA])\n- Hospital acquired condition [HAC]\n- Not applicable or unknown",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.treatmentClass",
        "path" : "HDRHospitalStay.diagnosticSummary.treatmentClass",
        "short" : "A.2.7.1.6 - Treatment class",
        "definition" : "Class of the problem (treated, other) in relation to the hospital encounter. Treated problems were treated or affected provisioning of care (diagnostics, therapy, nursing, monitoring) during the hospital encounter. At least one problem should be marked as Treated. Other problems are recorded only if they are important for continuity of care (after discharge).",
        "comment" : "Treated, Other",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.clinicalStatus",
        "path" : "HDRHospitalStay.diagnosticSummary.clinicalStatus",
        "short" : "A.2.7.1.7 - Clinical status",
        "definition" : "Status of the condition/problem (active, resolved, inactive, ...)",
        "comment" : "hl7:condition-clinical",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.resolution",
        "path" : "HDRHospitalStay.diagnosticSummary.resolution",
        "short" : "A.2.7.1.8 - Resolution circumstances",
        "definition" : "Describes the reason for which the status of the problem changed from current to inactive (e.g. surgical procedure, medical treatment, etc.). This field includes \"free text\" if the resolution circumstances are not already included in other fields such as surgical procedure, medical device, etc., e.g. hepatic cystectomy (this will be the resolution circumstances for the problem \"hepatic cyst\" and will be included in surgical procedures).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.severity",
        "path" : "HDRHospitalStay.diagnosticSummary.severity",
        "short" : "A.2.7.1.9 - Severity",
        "definition" : "A subjective assessment of the severity of the condition as evaluated by the clinician.",
        "comment" : "hl7:condition-severity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.diagnosticSummary.stage",
        "path" : "HDRHospitalStay.diagnosticSummary.stage",
        "short" : "A.2.7.1.10 - Stage",
        "definition" : "Stage/grade usually assessed formally using a specific staging/grading system. Multiple assessment systems could be used.",
        "comment" : "e.g. TNM\nICD-O-3",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures",
        "path" : "HDRHospitalStay.significantProcedures",
        "short" : "A.2.7.2 - Significant procedures",
        "definition" : "Significant surgical and non-surgical procedures performed during hospitalisation which are significant for continuity of care, e.g. surgeries and other \"instrumental\" interventions (endoscopic, intravascular), chemotherapy, radiotherapy, purification methods (dialysis, hemoperfusion), circulation support methods (counterpulsation, etc.), administration of blood derivatives or others.\nThis section does not include purely diagnostic procedures (MRI, CT, etc.). If no significant performance has been performed, this fact must be explicitly stated using the IPS Absent and Unknown Data.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.procedureCode",
        "path" : "HDRHospitalStay.significantProcedures.procedureCode",
        "short" : "A.2.7.2.1 - Procedure code",
        "definition" : "Procedure code",
        "comment" : "SNOMED CT\nIPS Absent and Unknown Data",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.description",
        "path" : "HDRHospitalStay.significantProcedures.description",
        "short" : "A.2.7.2.2 - Procedure description",
        "definition" : "Narrative description of the procedure",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.bodySite",
        "path" : "HDRHospitalStay.significantProcedures.bodySite",
        "short" : "A.2.7.2.3 - Body site",
        "definition" : "Procedure target body site and laterality",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.date",
        "path" : "HDRHospitalStay.significantProcedures.date",
        "short" : "A.2.7.2.4 - Procedure date",
        "definition" : "Date and time when procedure was performed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.reason",
        "path" : "HDRHospitalStay.significantProcedures.reason",
        "short" : "A.2.7.2.5 - Procedure reason",
        "definition" : "The coded reason why the procedure was performed. This may be a coded entity or may simply be present as text.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.outcome",
        "path" : "HDRHospitalStay.significantProcedures.outcome",
        "short" : "A.2.7.2.6 - Outcome",
        "definition" : "The outcome of the procedure - did it resolve the reasons for the procedure being performed?",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.complication",
        "path" : "HDRHospitalStay.significantProcedures.complication",
        "short" : "A.2.7.2.7 - Complication",
        "definition" : "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the procedure description, which will typically describe the procedure itself rather than any 'post procedure' issues.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantProcedures.focalDevice",
        "path" : "HDRHospitalStay.significantProcedures.focalDevice",
        "short" : "A.2.7.2.8 - Focal device",
        "definition" : "A reference to the device or devices that is/are implanted, removed, or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableReference"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.medicalDevices",
        "path" : "HDRHospitalStay.medicalDevices",
        "short" : "A.2.7.3 - Medical devices and implants",
        "definition" : "Implants and used medical devices that affected or may affect the provision of health services (diagnosis and treatment). Also medical devices explanted, or its use was stopped during hospitalisation. If the section is blank, the reason must be explicitly stated using the IPS Absent and Unknown Data coding system",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.medicalDevices.description",
        "path" : "HDRHospitalStay.medicalDevices.description",
        "short" : "A.2.7.3.1 - Device and implant description",
        "definition" : "Describes the patient's implanted and external medical devices and equipment upon which their health status depends. Includes devices such as cardiac pacemakers, implantable fibrillator, prosthesis, ferromagnetic bone implants, etc. of which the HP needs to be aware.",
        "comment" : "SNOMED CT\nEMDN\nIPS Absent and Unknown Data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.medicalDevices.identifier",
        "path" : "HDRHospitalStay.medicalDevices.identifier",
        "short" : "A.2.7.3.2 - Device ID",
        "definition" : "Normalised identifier of the device instance such as UDI according to REGULATION (EU) 2017/745",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.medicalDevices.implantDate",
        "path" : "HDRHospitalStay.medicalDevices.implantDate",
        "short" : "A.2.7.3.3 - Implant date",
        "definition" : "The date and time the device was implanted or when its use began.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.medicalDevices.endDate",
        "path" : "HDRHospitalStay.medicalDevices.endDate",
        "short" : "A.2.7.3.4 - End date",
        "definition" : "Date and time when the device was explanted from the patient or the external device was no longer in use; likewise when the device is planned to be explanted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.medicalDevices.reason",
        "path" : "HDRHospitalStay.medicalDevices.reason",
        "short" : "A.2.7.3.5 - Reason",
        "definition" : "The medical reason for use of the medical device.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy",
        "path" : "HDRHospitalStay.pharmacotherapy",
        "short" : "A.2.7.5 - Pharmacotherapy",
        "definition" : "Selected drug treatment during hospitalisation. Medicinal products that were administered during hospitalisation and whose administration has already been discontinued before discharge. Only products which are important for continuity of care (antibiotics other than completely routine, corticosteroids in high doses, etc.) will be listed. Products which administration will continue after discharge will be also recorder in the Medication summary section.Medicinal products, the administration of which was started during hospitalisation, but is also recommended after discharge, will be listed in the summary table in the recommendation section.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.reason",
        "path" : "HDRHospitalStay.pharmacotherapy.reason",
        "short" : "A.2.7.5.1 - Medication reason",
        "definition" : "The reason why the medication is or was prescribed or used. It provides a link to the Past or current health conditions or problems that the patient has had or has.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.productCode",
        "path" : "HDRHospitalStay.pharmacotherapy.productCode",
        "short" : "A.2.7.5.2 - Code",
        "definition" : "Product code",
        "comment" : "IDMP",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.intendedUse",
        "path" : "HDRHospitalStay.pharmacotherapy.intendedUse",
        "short" : "A.2.7.5.3 - Intended use",
        "definition" : "Indication intended use as: prevention or treatment Example: prophylaxis, treatment, diagnostic, anaesthesia.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.productName",
        "path" : "HDRHospitalStay.pharmacotherapy.productName",
        "short" : "A.2.7.5.4 - Brand name",
        "definition" : "Brand name if biological medicinal product or when justified by the health professional (ref. Commission Directive 2012/52/EU)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.activeIngredient",
        "path" : "HDRHospitalStay.pharmacotherapy.activeIngredient",
        "short" : "A.2.7.5.5 - Active ingredient list",
        "definition" : "Substance that alone or in combination with one or more other ingredients produces the intended activity of a medicinal product. Example: \\\"paracetamol\\\" ",
        "comment" : "ATC\n(IDMP / EMA SPOR SMS)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.strength",
        "path" : "HDRHospitalStay.pharmacotherapy.strength",
        "short" : "A.2.7.5.6 - Strength",
        "definition" : "The content of the active ingredient expressed quantifiably per dosage unit, per unit of volume or per unit of weight, according to the pharmaceutical dose form. Example: 500 mg per tablet",
        "comment" : "UCUM\nEDQM Standard terms",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.doseForm",
        "path" : "HDRHospitalStay.pharmacotherapy.doseForm",
        "short" : "A.2.7.5.7 - Pharmaceutical dose form",
        "definition" : "The form in which a pharmaceutical product is presented in the medicinal product package (e.g. tablet, syrup)",
        "comment" : "EDQM Standard Terms",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.dosageRegimen",
        "path" : "HDRHospitalStay.pharmacotherapy.dosageRegimen",
        "short" : "A.2.7.5.8 - Dosage Regimen",
        "definition" : "Number of units per intake and frequency of intake over a specified duration of time. Example: 1 tablet every 24h, for 10 days",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.route",
        "path" : "HDRHospitalStay.pharmacotherapy.route",
        "short" : "A.2.7.5.9 - Route of administration",
        "definition" : "Path by which the pharmaceutical product is taken into or makes contact with the body. ",
        "comment" : "EDQM Standard Terms",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.pharmacotherapy.period",
        "path" : "HDRHospitalStay.pharmacotherapy.period",
        "short" : "A.2.7.5.10 - Period of treatment",
        "definition" : "The time interval when the patient was, or was not, given the medication.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults",
        "path" : "HDRHospitalStay.significantResults",
        "short" : "A.2.7.6 - Significant Observation Results",
        "definition" : "Results of significant functional, diagnostic, and imaging examinations to ensure continuity of care, performed during hospitalisation. Results of examinations ordered but not yet delivered should be presented separately from results already delivered.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults.date",
        "path" : "HDRHospitalStay.significantResults.date",
        "short" : "A.2.7.6.1 - Date",
        "definition" : "Date and time of the observation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults.status",
        "path" : "HDRHospitalStay.significantResults.status",
        "short" : "A.2.7.6.2 - Observation status",
        "definition" : "Status of the observation (e.g. registered, preliminary, final)",
        "comment" : "hl7:observation-status",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults.description",
        "path" : "HDRHospitalStay.significantResults.description",
        "short" : "A.2.7.6.3 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults.details",
        "path" : "HDRHospitalStay.significantResults.details",
        "short" : "A.2.7.6.4 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "comment" : "LOINC\nNPU\nSNOMED CT",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults.result",
        "path" : "HDRHospitalStay.significantResults.result",
        "short" : "A.2.7.6.5 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "comment" : "SNOMED CT\nUCUM (measurement units)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.significantResults.reporter",
        "path" : "HDRHospitalStay.significantResults.reporter",
        "short" : "A.2.7.6.7 - Reporter",
        "definition" : "With certain observation results, e.g. there may also be an interpreter or a person responsible for validation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.synthesis",
        "path" : "HDRHospitalStay.synthesis",
        "short" : "A.2.7.7 - Synthesis",
        "definition" : "This section provides clinical synthesis (e.g. description of reasons and course of hospital stay) clustered by managed conditions, Clinical synthesis may include clinical reasoning (differential diagnostics, explanation of clinical context) in clinically complex conditions.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.synthesis.description",
        "path" : "HDRHospitalStay.synthesis.description",
        "short" : "A.2.7.7.1 - Problem synthesis",
        "definition" : "Summary description of the reason and course of hospitalisation for a specific problem.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRHospitalStay.synthesis.reasoning",
        "path" : "HDRHospitalStay.synthesis.reasoning",
        "short" : "A.2.7.7.2 - Clinical reasoning",
        "definition" : "The clinical summary can be concluded with a clinical consideration (diff. diagnosis, explanation of context, etc.) for clinically complex conditions.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
