# A.2.8 - Discharge details (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.8 - Discharge details (eHN)**

## Logical Model: A.2.8 - Discharge details (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRDischargeDetails | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNDischargeDetails |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Discharge details - A.2.8 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRDischargeDetails)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRDischargeDetails.csv), [Excel](StructureDefinition-HDRDischargeDetails.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRDischargeDetails",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRDischargeDetails",
  "version" : "0.1.0",
  "name" : "HdrEHNDischargeDetails",
  "title" : "A.2.8 - Discharge details (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Discharge details - A.2.8 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRDischargeDetails",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRDischargeDetails",
        "path" : "HDRDischargeDetails",
        "short" : "A.2.8 - Discharge details (eHN)",
        "definition" : "Hospital Discharge Report - Discharge details - A.2.8 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails",
        "path" : "HDRDischargeDetails.dischargeDetails",
        "short" : "A.2.8 - Discharge details (structured information should be provided, however if not available, at least a summary note should be present).",
        "definition" : "Discharge details (structured information should be provided, however if not available, at least a summary note should be present).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings",
        "short" : "A.2.8.1 - Objective findings",
        "definition" : "Objective findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.date",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.date",
        "short" : "A.2.8.1.1 - Date",
        "definition" : "Date and time of the examination at or before discharge",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations",
        "short" : "A.2.8.1.3 - Anthropometric observations",
        "definition" : "Observation of Body weight and height of the patient, BMI, circumference of head, waist, hip, limbs and skin fold thickness.Result of the observation includes text, numeric and coded results of the measurement including measurement units. Multiple observations could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations.description",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations.description",
        "short" : "A.2.8.1.3.1 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations.details",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations.details",
        "short" : "A.2.8.1.3.2 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "comment" : "SNOMED CT\nLOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations.result",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.anthropometricObservations.result",
        "short" : "A.2.8.1.3.3 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "comment" : "UCUM (measurement units)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns",
        "short" : "A.2.8.1.4 - Vital signs",
        "definition" : "Observation of Vital signs:\n• Recommended: systolic and diastolic blood pressure including site of measurement, pulse rate, respiratory rate\n• Optional: 02 saturation, temperature, pain (scale), ...\t",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns.description",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns.description",
        "short" : "A.2.8.1.4.1 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns.details",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns.details",
        "short" : "A.2.8.1.4.2 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "comment" : "SNOMED CT\nLOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns.result",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.vitalSigns.result",
        "short" : "A.2.8.1.4.3 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "comment" : "UCUM (measurement units)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.physicalExamination",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.physicalExamination",
        "short" : "A.2.8.1.5 - Physical examination",
        "definition" : "Physical examination (at discharge) is the process of evaluating objective anatomical findings. Physical examination can be performed through observation, palpation, percussion, and auscultation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.physicalExamination.description",
        "path" : "HDRDischargeDetails.dischargeDetails.objectiveFindings.physicalExamination.description",
        "short" : "A.2.8.1.5.1 - Observation Note",
        "definition" : "A narrative description of the observation. It should be structured by the organ system (e.g. head, neck, body, arms, ...)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.functionalStatus",
        "path" : "HDRDischargeDetails.dischargeDetails.functionalStatus",
        "short" : "A.2.8.2 - Functional status",
        "definition" : "Functional status can be assessed in several different ways, usually with a focus on the person’s abilities to perform basic activities of daily living (ADL), which include basic self-care such as bathing, feeding, and toileting and instrumental activities of daily living (IADL), which includes activities such as cooking, shopping, and managing one’s own affairs.\nFor details see: https://paciowg.github.io/functional-status-ig/",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.functionalStatus.description",
        "path" : "HDRDischargeDetails.dischargeDetails.functionalStatus.description",
        "short" : "A.2.8.2.1 - Description",
        "definition" : "Need for the patient to be continuously assessed by third parties; functional status may influence decisions about how to plan and administer treatments",
        "comment" : "e.g. ICF",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.functionalStatus.onsetDate",
        "path" : "HDRDischargeDetails.dischargeDetails.functionalStatus.onsetDate",
        "short" : "A.2.8.2.2 - Onset Date",
        "definition" : "Onset date of a condition",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.functionalStatus.assessmetType",
        "path" : "HDRDischargeDetails.dischargeDetails.functionalStatus.assessmetType",
        "short" : "A.2.8.2.3 - Functional assessment description ",
        "definition" : "Description of the functional assessment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.functionalStatus.assessmentDate",
        "path" : "HDRDischargeDetails.dischargeDetails.functionalStatus.assessmentDate",
        "short" : "A.2.8.2.4 - Functional assessment date",
        "definition" : "Date of the functional assessment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.functionalStatus.assessmentResult",
        "path" : "HDRDischargeDetails.dischargeDetails.functionalStatus.assessmentResult",
        "short" : "A.2.8.2.5 - Functional assessment result",
        "definition" : "Functional assessment result value",
        "comment" : "e.g. ICF",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRDischargeDetails.dischargeDetails.dischargeNote",
        "path" : "HDRDischargeDetails.dischargeDetails.dischargeNote",
        "short" : "A.2.8.3 - Discharge note",
        "definition" : "Discharge summary note",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
