# Encounter to this guide - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter to this guide**

## ConceptMap: Encounter to this guide (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-hdrEncounter2FHIR-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEncounter2FHIR |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
eHN HDR Encounter Model to this guide mapping 

 
Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide 

Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-HDREncounter.md) to http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Encounter-hdr-xpandh

**Group 1**Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-HDREncounter.md) to `http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Encounter-hdr-xpandh`

* **Source Code**: HDREncounter.type (A.2.3.1 - Encounter type [Mandatory])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Encounter.class
  * **Comment**: 
* **Source Code**: HDREncounter.note (A.2.3.2 - Encounter note [Optional])
  * **Relationship**: (not mapped)
* **Source Code**: HDREncounter.admission (A.2.3.3 - Admission [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.ofType(Organization)
  * **Comment**: 
* **Source Code**: HDREncounter.admission.urgency (A.2.3.3.1 - Admission urgency [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.priority
  * **Comment**: to be checked
* **Source Code**: HDREncounter.admission.date (A.2.3.3.2 - Admission date [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.period.start
  * **Comment**: to be checked
* **Source Code**: HDREncounter.admission.admitter (- Admitting professional Id [])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual
  * **Comment**: where participant.type is 'ADM'
* **Source Code**: HDREncounter.admission.admitter.identifier (A.2.3.3.3 - Admitting professional Id [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.identifier
  * **Comment**: where participant.type is 'ADM'
* **Source Code**: HDREncounter.admission.admitter.name (A.2.3.3.4 - Admitting professional name [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.name
  * **Comment**: where participant.type is 'ADM' and individual of type Practictioner
* **Source Code**: HDREncounter.admission.admitter.name (A.2.3.3.4 - Admitting professional name [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.practitioner.name
  * **Comment**: where participant.type is 'ADM' and individual of type PractictionerRole
* **Source Code**: HDREncounter.admission.source (A.2.3.3.5 - Admit Source [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.hospitalization.admitSource
  * **Comment**: 
* **Source Code**: HDREncounter.admission.referringHP (- Referring professional Id [])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual
  * **Comment**: where participant.type is 'REF'
* **Source Code**: HDREncounter.admission.referringHP.identifier (A.2.3.3.6 - Referring professional Id [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.identifier
  * **Comment**: where participant.type is 'REF'
* **Source Code**: HDREncounter.admission.referringHP.name (A.2.3.3.7 - Referring professional name [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.name
  * **Comment**: where participant.type is 'REF' and individual of type Practictioner
* **Source Code**: HDREncounter.admission.referringHP.organization (A.2.3.3.8 - Referring organization [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.practitioner.name
  * **Comment**: where participant.type is 'REF' and individual of type PractictionerRole
* **Source Code**: HDREncounter.reason (A.2.3.4 - Admission reason [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.
  * **Comment**: 
* **Source Code**: HDREncounter.reason.code (A.2.3.4.1 - Admission reason [Required])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Encounter.reasonCode
  * **Comment**: if just a code
* **Source Code**: HDREncounter.reason.comment (A.2.3.4.2 - Admission reason comment [Optional])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.reasonCode.text
  * **Comment**: to be checked
* **Source Code**: HDREncounter.reason.legalStatus (A.2.3.4.3 - Admission legal status [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.
  * **Comment**: to be checked
* **Source Code**: HDREncounter.discharge (A.2.3.5 - Discharge [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.
  * **Comment**: 
* **Source Code**: HDREncounter.discharge.dateTime (A.2.3.5.1 - Discharge date [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.period.end
  * **Comment**: 
* **Source Code**: HDREncounter.discharge.destinationType (A.2.3.5.2 - Discharge destination type [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.hospitalization.dischargeDisposition
  * **Comment**: 
* **Source Code**: HDREncounter.discharge.destinationLocation (A.2.3.5.3 - Destination location [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.destination
  * **Comment**: of type Location
* **Source Code**: HDREncounter.location (A.2.3.6 - Location - All locations/departments where the patient stayed within the hospital. [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location
  * **Comment**: 
* **Source Code**: HDREncounter.location.period (A.2.3.6.1 - Period [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.location.period
  * **Comment**: 
* **Source Code**: HDREncounter.location.organization (- Organization Id [])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location.location.managingOrganization
  * **Comment**: 
* **Source Code**: HDREncounter.location.organization.identifier (A.2.3.6.2 - Organization Id [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.location.location.managingOrganization.identifier
  * **Comment**: 
* **Source Code**: HDREncounter.location.organization.name (A.2.3.6.3 - Organization Part Name [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.location.location.managingOrganization.name
  * **Comment**: 
* **Source Code**: HDREncounter.location.organization.details (A.2.3.6.4 - Organization Part Details [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location.location.managingOrganization
  * **Comment**: to be checked



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ConceptMap-hdrEncounter2FHIR-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-hdrEncounter2FHIR-eu-xpandh",
  "version" : "0.1.0",
  "name" : "HdrEncounter2FHIR",
  "title" : "eHN Recipient to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "eHN HDR Encounter Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide",
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "sourceUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDREncounter",
  "targetUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Encounter-hdr-xpandh",
  "group" : [
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDREncounter",
      "target" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Encounter-hdr-xpandh",
      "element" : [
        {
          "code" : "HDREncounter.type",
          "display" : "A.2.3.1 - Encounter type [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.class",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HDREncounter.note",
          "display" : "A.2.3.2 - Encounter note [Optional]",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission",
          "display" : "A.2.3.3 - Admission [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.ofType(Organization)",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.urgency",
          "display" : "A.2.3.3.1 - Admission urgency [Required]",
          "target" : [
            {
              "code" : "Encounter.priority",
              "equivalence" : "relatedto",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.date",
          "display" : "A.2.3.3.2 - Admission date [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.period.start",
              "equivalence" : "equivalent",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.admitter",
          "display" : "- Admitting professional Id []",
          "target" : [
            {
              "code" : "Encounter.participant.individual",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'ADM'"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.admitter.identifier",
          "display" : "A.2.3.3.3 - Admitting professional Id [Required]",
          "target" : [
            {
              "code" : "Encounter.participant.individual.identifier",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'ADM'"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.admitter.name",
          "display" : "A.2.3.3.4 - Admitting professional name [Required]",
          "target" : [
            {
              "code" : "Encounter.participant.individual.name",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'ADM' and individual of type Practictioner"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.admitter.name",
          "display" : "A.2.3.3.4 - Admitting professional name [Required]",
          "target" : [
            {
              "code" : "Encounter.participant.individual.practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'ADM' and individual of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.source",
          "display" : "A.2.3.3.5 - Admit Source [Required]",
          "target" : [
            {
              "code" : "Encounter.hospitalization.admitSource",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.referringHP",
          "display" : "- Referring professional Id []",
          "target" : [
            {
              "code" : "Encounter.participant.individual",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'REF'"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.referringHP.identifier",
          "display" : "A.2.3.3.6 - Referring professional Id [Required]",
          "target" : [
            {
              "code" : "Encounter.participant.individual.identifier",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'REF'"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.referringHP.name",
          "display" : "A.2.3.3.7 - Referring professional name [Required]",
          "target" : [
            {
              "code" : "Encounter.participant.individual.name",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'REF' and individual of type Practictioner"
            }
          ]
        },
        {
          "code" : "HDREncounter.admission.referringHP.organization",
          "display" : "A.2.3.3.8 - Referring organization [Required]",
          "target" : [
            {
              "code" : "Encounter.participant.individual.practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'REF' and individual of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HDREncounter.reason",
          "display" : "A.2.3.4 - Admission reason [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HDREncounter.reason.code",
          "display" : "A.2.3.4.1 - Admission reason [Required]",
          "target" : [
            {
              "code" : "Encounter.reasonCode",
              "equivalence" : "equal",
              "comment" : "if just a code"
            }
          ]
        },
        {
          "code" : "HDREncounter.reason.comment",
          "display" : "A.2.3.4.2 - Admission reason comment [Optional]",
          "target" : [
            {
              "code" : "Encounter.reasonCode.text",
              "equivalence" : "equivalent",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "HDREncounter.reason.legalStatus",
          "display" : "A.2.3.4.3 - Admission legal status [Required]",
          "target" : [
            {
              "code" : "Encounter.",
              "equivalence" : "relatedto",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "HDREncounter.discharge",
          "display" : "A.2.3.5 - Discharge [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HDREncounter.discharge.dateTime",
          "display" : "A.2.3.5.1 - Discharge date [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.period.end",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HDREncounter.discharge.destinationType",
          "display" : "A.2.3.5.2 - Discharge destination type [Required]",
          "target" : [
            {
              "code" : "Encounter.hospitalization.dischargeDisposition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HDREncounter.discharge.destinationLocation",
          "display" : "A.2.3.5.3 - Destination location [Required]",
          "target" : [
            {
              "code" : "Encounter.destination",
              "equivalence" : "relatedto",
              "comment" : "of type Location"
            }
          ]
        },
        {
          "code" : "HDREncounter.location",
          "display" : "A.2.3.6 - Location - All locations/departments where the patient stayed within the hospital. [Required]",
          "target" : [
            {
              "code" : "Encounter.location",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HDREncounter.location.period",
          "display" : "A.2.3.6.1 - Period [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.location.period",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HDREncounter.location.organization",
          "display" : "- Organization Id []",
          "target" : [
            {
              "code" : "Encounter.location.location.managingOrganization",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HDREncounter.location.organization.identifier",
          "display" : "A.2.3.6.2 - Organization Id [Required]",
          "target" : [
            {
              "code" : "Encounter.location.location.managingOrganization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HDREncounter.location.organization.name",
          "display" : "A.2.3.6.3 - Organization Part Name [Mandatory]",
          "target" : [
            {
              "code" : "Encounter.location.location.managingOrganization.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HDREncounter.location.organization.details",
          "display" : "A.2.3.6.4 - Organization Part Details [Required]",
          "target" : [
            {
              "code" : "Encounter.location.location.managingOrganization",
              "equivalence" : "relatedto",
              "comment" : "to be checked"
            }
          ]
        }
      ]
    }
  ]
}

```
