# eHN HDR header metadata to this guide Map - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN HDR header metadata to this guide Map**

## ConceptMap: eHN HDR header metadata to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-HeaderMeta2FHIR-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HeaderMeta2FHIR |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
eHN eHN HDR header metadata Model to this guide mapping 

 
Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide 

Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh

**Group 1**Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to `http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh`

* **Source Code**: HospitalDischargeReport.header.documentMetadata (A.1.8 - Document metadata [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.identifier (A.1.8.1 - Document ID [Mandatory])
  * **Relationship**: [maps loosely to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#inexact)
  * **Target Code**: Composition.identifier
  * **Comment**: if it is the identifer of the document (indipendently by its versions) and not of this particular document instance
* **Source Code**: HospitalDischargeReport.header.documentMetadata.type (A.1.8.2 - Document type [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.type
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.status (A.1.8.3 - Document status [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.status
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.dateTime (A.1.8.4 - Report date and time [Mandatory])
  * **Relationship**: [maps loosely to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#inexact)
  * **Target Code**: Composition.date
  * **Comment**: dateTime is used for tracking, organizing versions and searching. Note that this is the time of authoring. When packaged in a document, Bundle.timestamp is the date of packaging.
* **Source Code**: HospitalDischargeReport.header.documentMetadata.title (A.1.8.5 - Document title [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.title
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.custodian (A.1.8.6 - Report custodian [Optional])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.custodian
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.confidentiality (A.1.8.7 - Confidentiality [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.confidentiality
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.language (A.1.8.8 - Language [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.language�
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.version (A.1.8.9 - Version [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:versionNumber.valueString
  * **Comment**: As business version, not as resource version
* **Source Code**: HospitalDischargeReport.header.digitalSignature (A.1.9 - Digital signatures [Required])
  * **Relationship**: (not mapped)
* **Source Code**: HospitalDischargeReport.header.digitalSignature.signature (A.1.9.1 - Digital signature [Required])
  * **Relationship**: (not mapped)
* **Source Code**: HospitalDischargeReport.header.digitalSignature.timeStamp (A.1.9.2 - Time stamp [Required])
  * **Relationship**: (not mapped)

-------

**Group 2**Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to `http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Bundle-eu-xpandh`

* **Source Code**: HospitalDischargeReport.header.documentMetadata (A.1.8 - Document metadata [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Bundle
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.identifier (A.1.8.1 - Document ID [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.identifier
  * **Comment**: As idenrtifier of this particular instance
* **Source Code**: HospitalDischargeReport.header.documentMetadata.type (A.1.8.2 - Document type [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.entry:composition.resource.type
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.status (A.1.8.3 - Document status [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.entry:composition.resource.status
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.dateTime (A.1.8.4 - Report date and time [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.timeStamp
  * **Comment**: Date time of this specific document Bundle
* **Source Code**: HospitalDischargeReport.header.documentMetadata.title (A.1.8.5 - Document title [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.entry:composition.resource.title
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.custodian (A.1.8.6 - Report custodian [Optional])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.entry:composition.resource.custodian
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.confidentiality (A.1.8.7 - Confidentiality [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.entry:composition.resource.confidentiality
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.language (A.1.8.8 - Language [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Bundle.entry:composition.resource.language�
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.documentMetadata.version (A.1.8.9 - Version [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.entry:composition.resource.extension:versionNumber.valueString
  * **Comment**: As business version, not as resource version
* **Source Code**: HospitalDischargeReport.header.digitalSignature (A.1.9 - Digital signatures [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Bundle.signature
  * **Comment**: the Signature datatype requires to record Who signed and and the type of signature
* **Source Code**: HospitalDischargeReport.header.digitalSignature.signature (A.1.9.1 - Digital signature [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Bundle.signature.data
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.digitalSignature.timeStamp (A.1.9.2 - Time stamp [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.signature.when
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ConceptMap-HeaderMeta2FHIR-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-HeaderMeta2FHIR-eu-xpandh",
  "version" : "0.1.0",
  "name" : "HeaderMeta2FHIR",
  "title" : "eHN HDR header metadata to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "eHN eHN HDR header metadata Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide",
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "sourceUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
  "targetUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh",
  "group" : [
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
      "target" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh",
      "element" : [
        {
          "code" : "HospitalDischargeReport.header.documentMetadata",
          "display" : "A.1.8 - Document metadata [Mandatory]",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.identifier",
          "display" : "A.1.8.1 - Document ID [Mandatory]",
          "target" : [
            {
              "code" : "Composition.identifier",
              "equivalence" : "inexact",
              "comment" : "if it is the identifer of the document (indipendently by its versions) and not of this particular document instance"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.type",
          "display" : "A.1.8.2 - Document type [Mandatory]",
          "target" : [
            {
              "code" : "Composition.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.status",
          "display" : "A.1.8.3 - Document status [Mandatory]",
          "target" : [
            {
              "code" : "Composition.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.dateTime",
          "display" : "A.1.8.4 - Report date and time [Mandatory]",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "inexact",
              "comment" : "dateTime is used for tracking, organizing versions and searching. Note that this is the time of authoring. When packaged in a document, Bundle.timestamp is the date of packaging."
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.title",
          "display" : "A.1.8.5 - Document title [Mandatory]",
          "target" : [
            {
              "code" : "Composition.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.custodian",
          "display" : "A.1.8.6 - Report custodian [Optional]",
          "target" : [
            {
              "code" : "Composition.custodian",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.confidentiality",
          "display" : "A.1.8.7 - Confidentiality [Mandatory]",
          "target" : [
            {
              "code" : "Composition.confidentiality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.language",
          "display" : "A.1.8.8 - Language [Required]",
          "target" : [
            {
              "code" : "Composition.language�",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.version",
          "display" : "A.1.8.9 - Version [Required]",
          "target" : [
            {
              "code" : "Composition.extension:versionNumber.valueString",
              "equivalence" : "equivalent",
              "comment" : "As business version, not as resource version"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.digitalSignature",
          "display" : "A.1.9 - Digital signatures [Required]",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.digitalSignature.signature",
          "display" : "A.1.9.1 - Digital signature [Required]",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.digitalSignature.timeStamp",
          "display" : "A.1.9.2 - Time stamp [Required]",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        }
      ]
    },
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
      "target" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Bundle-eu-xpandh",
      "element" : [
        {
          "code" : "HospitalDischargeReport.header.documentMetadata",
          "display" : "A.1.8 - Document metadata [Mandatory]",
          "target" : [
            {
              "code" : "Bundle",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.identifier",
          "display" : "A.1.8.1 - Document ID [Mandatory]",
          "target" : [
            {
              "code" : "Bundle.identifier",
              "equivalence" : "equivalent",
              "comment" : "As idenrtifier of this particular instance"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.type",
          "display" : "A.1.8.2 - Document type [Mandatory]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.status",
          "display" : "A.1.8.3 - Document status [Mandatory]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.dateTime",
          "display" : "A.1.8.4 - Report date and time [Mandatory]",
          "target" : [
            {
              "code" : "Bundle.timeStamp",
              "equivalence" : "equivalent",
              "comment" : "Date time of this specific document Bundle"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.title",
          "display" : "A.1.8.5 - Document title [Mandatory]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.custodian",
          "display" : "A.1.8.6 - Report custodian [Optional]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.custodian",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.confidentiality",
          "display" : "A.1.8.7 - Confidentiality [Mandatory]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.confidentiality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.language",
          "display" : "A.1.8.8 - Language [Required]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.language�",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.documentMetadata.version",
          "display" : "A.1.8.9 - Version [Required]",
          "target" : [
            {
              "code" : "Bundle.entry:composition.resource.extension:versionNumber.valueString",
              "equivalence" : "equivalent",
              "comment" : "As business version, not as resource version"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.digitalSignature",
          "display" : "A.1.9 - Digital signatures [Required]",
          "target" : [
            {
              "code" : "Bundle.signature",
              "equivalence" : "relatedto",
              "comment" : "the Signature datatype requires to record Who signed and and the type of signature"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.digitalSignature.signature",
          "display" : "A.1.9.1 - Digital signature [Required]",
          "target" : [
            {
              "code" : "Bundle.signature.data",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.digitalSignature.timeStamp",
          "display" : "A.1.9.2 - Time stamp [Required]",
          "target" : [
            {
              "code" : "Bundle.signature.when",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
