# Home - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ImplementationGuide/hl7.eu.fhir.xpandh.hdr | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:XpandhHospitalDischargeReportIg |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

> The specification herewith documented is for the time being a working specification, and may not be used for any implementation purposes. No liability can be inferred from the use or misuse of this specification, or its consequences.

### Scope

 This is the Hospital Dischareg Report HL7 FHIR Implementation Guide for the XpanDH project, created to assist the work of the pilots for the [XpanDH exprimentation bubbles](#adoption-domains). 

> This guide is kept only for documentation purposes, representing an official deliverable of the XpanDH project.**This guide is not intended to replace or override any other Implementation Guide specified by Standard Development Organizations, MyHealth@Eu and/or JA-09.**Please refer to the**the[HL7 Europe Hospital Discharge Report FHIR IG](https://hl7.eu/fhir/hdr/)**for the specifications related to this domain

### The project

#### The mission

Help individuals and organizations successfully adopt the European Electronic Health Record Exchange Format (EEHRxF) in a way that is empowering and supportive.

#### How to:

Mobilizing and building capacity to ensure the widespread adoption of the European Electronic Health Records Exchange Format (EEHRxF) across Europe. 

More details in [XpanDH Web Site](https://xpandh-project.iscte-iul.pt/) 

### XpanDH Adoption Domains/X-Bubbles

#### What is:

An EEHRxF adoption domain could be considered as an instantiation of a use case, with a specific case application, that has meaning from a health system or clinical perspective, with defined implementable requirements (simple if only one EEHRxF priority category is uses or composite if data from more than one is required), that satisfies all the conditions for users to be ready to implement data exchange in conformity to EEHRxF guidelines and specifications 

XpanDH will exercise a set of adoption domains, involving Hospitals, Regional/National organziation, vendors,.., thorugh experimentaion bubbles (in the Hpandh jargon called X-Bubbles)

#### Adoption domains / X-Bubbles covered by this guide:

* X-Bubble 3: NCZI; organisation to organisation (national). Exchange of discharge reports between different organisations, such as a hospital and a GP or between a hospital local to the patient and a specialist centre treating a disease such as a cancer, in order to enable each clinical actor to be well informed and contribute accurately to the same patient care pathway.
* X-Bubble 4: CHUP; organisation to patient (national. Communicate discharge reports from a hospital to the patient (within the same country) so that they can be informed, raise questions if needed, share this information with other caregivers and take any self-care actions indicated in the report.
* X-Bubble 5: KETEKNY; organisation to national authority.Communicate discharge reports from a hospital to a national authority to support reimbursement decisions or to contribute content to a national registry.
* X-Bubble 6: KETEKNY; national authority to organisation. The national authority communicates discharge reports to a hospital treating a patient, that it has previously received from other hospitals treating that patient, to enable a smooth transfer and continuity of care (e.g. if a patient moves home).

More details on X-Bubbles and Adoption Doamin in XpanDH deliverable D1.4 and D4.1 [XpanDH Web Site](https://xpandh-project.iscte-iul.pt/) 

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.eu.fhir.xpandh.hdr.r4)](package.r4.tgz) and [R4B (hl7.eu.fhir.xpandh.hdr.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0131.html): [Patient/Mracena](Patient-Mracena.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [TravelHistoryXpandh](StructureDefinition-travel-history-xpandh.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [HdrConditionMandatoryXpandhVS](ValueSet-hdr-condition-mandatory-xpandh-vs.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [BMIObservationUnitVS](ValueSet-bmi-observation-unit-vs.md), [BMIProfileXpandh](StructureDefinition-bmi-xpandh.md)...Show 4 more,[BodyWeightUnitsVS](ValueSet-body-weight-units-vs.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[SkinfoldThicknessUnitsVS](ValueSet-skinfold-thickness-units-vs.md)and[SkinfoldThicknessXpandh](StructureDefinition-skinfold-thickness-xpandh.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [AssessmentObservationXpandh](StructureDefinition-assessment-observation-xpandh.md), [CompositionHdrXpandh](StructureDefinition-Composition-hdr-eu-xpandh.md)...Show 7 more,[ObservationCodesDistantMetastasesVS](ValueSet-mcode-observation-codes-distant-metastases-vs.md),[ObservationCodesPrimaryTumorVS](ValueSet-mcode-observation-codes-primary-tumor-vs.md),[ObservationCodesRegionalNodesVS](ValueSet-mcode-observation-codes-regional-nodes-vs.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[TNMDistantMetastasesCategory](StructureDefinition-mcode-tnm-distant-metastases-category.md),[TNMPrimaryTumorCategory](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[TNMRegionalNodesCategory](StructureDefinition-mcode-tnm-regional-nodes-category.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AdmissionVoluntaryStatusVS](ValueSet-admission-voluntary-status-vs.md), [AllVitalSignsObservationVS](ValueSet-vital-signs-observation-vs.md)...Show 48 more,[AllergyIntoleranceSubstancesXpandhVS](ValueSet-allergy-intolerance-substances-xpandh-vs.md),[AnthropometricObservationVS](ValueSet-anthropometric-observation-vs.md),[BMIObservationVS](ValueSet-bmi-observation-vs.md),[BMIProfileXpandh](StructureDefinition-bmi-xpandh.md),[BloodPressureXpandh](StructureDefinition-blood-pressure-xpandh.md),[BodyHeightObservationVS](ValueSet-body-height-observation-vs.md),[BodyHeightXpandh](StructureDefinition-body-height-xpandh.md),[BodyTemperatureXpandh](StructureDefinition-body-temperature-xpandh.md),[BodyWeightObservationVS](ValueSet-body-weight-observation-vs.md),[BodyWeightXpandh](StructureDefinition-body-weight-xpandh.md),[CancerStageGradingVS](ValueSet-cancer-stage-grading-vs.md),[CancerStageGroupHdrXpandh](StructureDefinition-cancer-stage-group-hdr-xpandh.md),[CancerStageGroupVS](ValueSet-cancer-stageGroup-vs.md),[CircumferenceMeasurementXpandh](StructureDefinition-circumference-measurement-xpandh.md),[CircumferenceObservationVS](ValueSet-circumference-observation-vs.md),[CompositionHdrXpandh](StructureDefinition-Composition-hdr-eu-xpandh.md),[ConditionEncounterHdrXpandh](StructureDefinition-condition-encounter-hdr-xpandh.md),[ConditionHdrXpandh](StructureDefinition-condition-hdr-xpandh.md),[EncounterVoluntaryStatus](StructureDefinition-encounter-voluntary-status.md),[ExposureAgentXpandhVS](ValueSet-exposure-agent-xpandh-vs.md),[FunctionalAssessmentScalesVS](ValueSet-functional-assessment-scales-vs.md),[FunctionalStatusAssessmentXpandh](StructureDefinition-functional-status-assessment-xpandh.md),[HdrConditionMandatoryXpandhVS](ValueSet-hdr-condition-mandatory-xpandh-vs.md),[HdrConditionXpandhVS](ValueSet-hdr-condition-xpandh-vs.md),[HdrEncounterTypeXpandhVS](ValueSet-hdr-encounter-type-xpandh-vs.md),[HdrTreatedXpandhVS](ValueSet-hdr-treated-xpandh-vs.md),[HeartRateXpandh](StructureDefinition-heart-rate-xpandh.md),[ImmunicationTargetVS](ValueSet-immunization-target-vs.md),[Immunization/example-it-1-1](Immunization-example-it-1-1.md),[Immunization/example-it-1-2](Immunization-example-it-1-2.md),[ImmunizationXpandh](StructureDefinition-immunization-xpandh.md),[InfectiousContactXpandh](StructureDefinition-infectious-contact-xpandh.md),[InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md),[MedicalDevicesSnomedCtXpandhVS](ValueSet-medical-devices-xpandh-vs.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[OxygenSaturationXpandh](StructureDefinition-oxygen-saturation-xpandh.md),[PediatricHeadOccipitalFrontalCircumferencePercentileXpandh](StructureDefinition-pediatric-head-occ-front-circumfer-percent-xpandh.md),[ProcedureSnomedXpandhVS](ValueSet-procedure-snomed-xpandh-vs.md),[RespiratoryRateXpandh](StructureDefinition-respiratory-rate-xpandh.md),[SkinfoldThicknessVS](ValueSet-skinfold-thickness-vs.md),[SkinfoldThicknessXpandh](StructureDefinition-skinfold-thickness-xpandh.md),[TNM_M_ClinicalCategoryVS](ValueSet-TNM-M-clinical-category-vs.md),[TNM_M_PathologicalCategoryVS](ValueSet-TNM-M-pathologycal-category-vs.md),[TNM_N_ClinicalCategoryVS](ValueSet-TNM-N-clinical-category-vs.md),[TNM_N_PathologicalCategoryVS](ValueSet-TNM-N-pathological-category-vs.md),[TNM_T_ClinicalCategoryVS](ValueSet-TNM-T-clinical-category-vs.md),[TNM_T_PathologicalCategoryVS](ValueSet-TNM-T-pathological-category-vs.md)and[TravelHistoryXpandh](StructureDefinition-travel-history-xpandh.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Admit source](http://terminology.hl7.org/6.5.0/CodeSystem-admit-source.html): [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md)
* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [ConditionEncounterHdrXpandh](StructureDefinition-condition-encounter-hdr-xpandh.md) and [ConditionProblemsHdrXpandh](StructureDefinition-condition-problems-hdr-xpandh.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [ConditionHdrXpandh](StructureDefinition-condition-hdr-xpandh.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [ConditionHdrXpandh](StructureDefinition-condition-hdr-xpandh.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [BMIProfileXpandh](StructureDefinition-bmi-xpandh.md), [BloodPressureXpandh](StructureDefinition-blood-pressure-xpandh.md)...Show 13 more,[BodyHeightXpandh](StructureDefinition-body-height-xpandh.md),[BodyTemperatureXpandh](StructureDefinition-body-temperature-xpandh.md),[BodyWeightXpandh](StructureDefinition-body-weight-xpandh.md),[CircumferenceMeasurementXpandh](StructureDefinition-circumference-measurement-xpandh.md),[HeartRateXpandh](StructureDefinition-heart-rate-xpandh.md),[ObservationResultsPathologyXpandh](StructureDefinition-Observation-results-pathology-eu-xpandh.md),[ObservationResultsRadiologyXpandh](StructureDefinition-Observation-results-radiology-eu-xpandh.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[OxygenSaturationXpandh](StructureDefinition-oxygen-saturation-xpandh.md),[PediatricHeadOccipitalFrontalCircumferencePercentileXpandh](StructureDefinition-pediatric-head-occ-front-circumfer-percent-xpandh.md),[RespiratoryRateXpandh](StructureDefinition-respiratory-rate-xpandh.md),[SkinfoldThicknessXpandh](StructureDefinition-skinfold-thickness-xpandh.md)and[SocialHistoryXpandh](StructureDefinition-social-history-xpandh.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [MUDr. Pes Filipes, praktický lékař](Organization-SK-Organization-GP.md), [Mestská Nemocnica Kubín](Organization-SK-Organization-Hospital.md) and [Nemocnica - oddělení chirurgie](Organization-SK-Organization-Hospital-Department-1.md)
* [ActClass](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActClass.html): [InfectiousContactXpandh](StructureDefinition-infectious-contact-xpandh.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md), [HdrEncounterClassXpandhVS](ValueSet-hdr-encounterClass-xpandh-vs.md) and [InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [ActPriority](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActPriority.html): [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md), [HdrAdmissionUrgencyXpandhVS](ValueSet-hdr-admission-urgency-xpandh-vs.md) and [InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [InfectiousContactXpandh](StructureDefinition-infectious-contact-xpandh.md) and [InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Patient/Mracena](Patient-Mracena.md)


* Used by permission of the XpanDH project, all rights reserved Creative Commons License

* [Xpandh Assessment Category](CodeSystem-assessment-category-xpandh-cs.md): [AssessmentObservationCategoryVS](ValueSet-assessment-observation-category-vs.md), [AssessmentObservationXpandh](StructureDefinition-assessment-observation-xpandh.md), [FunctionalStatusAssessmentXpandh](StructureDefinition-functional-status-assessment-xpandh.md) and [WHODASAssessmentXpandh](StructureDefinition-whodas-assessment-xpandh.md)
* [Present on Admission (POA) Indicator](CodeSystem-poa-indicator-xpandh-cs.md): [ConditionEncounterHdrXpandh](StructureDefinition-condition-encounter-hdr-xpandh.md) and [HdrPOAIndicatorXpandhVS](ValueSet-hdr-poa-indicator-xpandh-vs.md)


