# Procedures - SNOMED CT + Absent/Unknown - IPS - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedures - SNOMED CT + Absent/Unknown - IPS**

## ValueSet: Procedures - SNOMED CT + Absent/Unknown - IPS 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/procedures-snomed-absent-unknown-xpandh-vs | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ProceduresSnomedAbsentUnknownXpandhVS |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | | |

 
This value set includes codes from SNOMED Clinical Terms®: descendants of 71388002 |Procedure (procedure)|, excluding [all subtypes of 14734007 |Administrative procedure (procedure)|, all subtypes of 59524001 |Blood bank procedure (procedure)|, all subtypes of 389067005 |Community health procedure (procedure)|, all subtypes of 442006003 |Determination of information related to transfusion (procedure)|, all subtypes of 225288009 |Environmental care procedure (procedure)|, all subtypes of 308335008 |Patient encounter procedure (procedure)|, all subtypes of 710135002 |Promotion (procedure)|, all subtypes of 389084004 |Staff related procedure (procedure)|], plus IPS codes for absent/unknown procedures. 

 **References** 

* [Procedure (Xpandh)](StructureDefinition-Procedure-xpandh.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Procedure codes: Snomed CT](ValueSet-procedure-snomed-xpandh-vs.md)
* Import all the codes that are contained in [Absent or Unknown Procedures - IPS](http://hl7.org/fhir/uv/ips/STU1.1/ValueSet-absent-or-unknown-procedures-uv-ips.html)

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem Absent and Unknown Data - IPS v1.1.0 (CodeSystem)](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html)
* SNOMED CT International edition 01-Feb 2025
* [valueset Procedure codes: Snomed CT v0.1.0 (ValueSet)](ValueSet-procedure-snomed-xpandh-vs.md)
* [valueset Absent or Unknown Procedures - IPS v1.1.0 (ValueSet)](http://hl7.org/fhir/uv/ips/STU1.1/ValueSet-absent-or-unknown-procedures-uv-ips.html)

This value set expansion contains 982 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "procedures-snomed-absent-unknown-xpandh-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/procedures-snomed-absent-unknown-xpandh-vs",
  "version" : "0.1.0",
  "name" : "ProceduresSnomedAbsentUnknownXpandhVS",
  "title" : "Procedures - SNOMED CT + Absent/Unknown - IPS",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This value set includes codes from SNOMED Clinical Terms®: descendants of 71388002 \\|Procedure (procedure)\\|, excluding [all subtypes of 14734007 \\|Administrative procedure (procedure)\\|, all subtypes of 59524001 \\|Blood bank procedure (procedure)\\|, all subtypes of 389067005 \\|Community health procedure (procedure)\\|, all subtypes of 442006003 \\|Determination of information related to transfusion (procedure)\\|, all subtypes of 225288009 \\|Environmental care procedure (procedure)\\|, all subtypes of 308335008 \\|Patient encounter procedure (procedure)\\|, all subtypes of 710135002 \\|Promotion (procedure)\\|, all subtypes of 389084004 \\|Staff related procedure (procedure)\\|], plus IPS codes for absent/unknown procedures.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/procedure-snomed-xpandh-vs"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.org/fhir/uv/ips/ValueSet/absent-or-unknown-procedures-uv-ips"
        ]
      }
    ]
  }
}

```
